/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.IconLoader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;

public class UnknownSdkType
extends SdkType {
    public static final Icon ICON = IconLoader.getIcon((String)"/nodes/unknownJdkClosed.png");
    private static final Icon JDK_ICON_EXPANDED = IconLoader.getIcon((String)"/nodes/unknownJdkOpen.png");
    private static final Map<String, UnknownSdkType> ourTypeNameToInstanceMap = new HashMap<String, UnknownSdkType>();

    private UnknownSdkType(String typeName) {
        super(typeName);
    }

    public static UnknownSdkType getInstance(String typeName) {
        UnknownSdkType instance = ourTypeNameToInstanceMap.get(typeName);
        if (instance == null) {
            instance = new UnknownSdkType(typeName);
            ourTypeNameToInstanceMap.put(typeName, instance);
        }
        return instance;
    }

    @Override
    public String suggestHomePath() {
        return null;
    }

    @Override
    public boolean isValidSdkHome(String path) {
        return false;
    }

    @Override
    public String getVersionString(String sdkHome) {
        return "";
    }

    @Override
    public String suggestSdkName(String currentSdkName, String sdkHome) {
        return currentSdkName;
    }

    @Override
    public void setupSdkPaths(Sdk sdk) {
    }

    @Override
    public AdditionalDataConfigurable createAdditionalDataConfigurable(SdkModel sdkModel, SdkModificator sdkModificator) {
        return null;
    }

    public String getBinPath(Sdk sdk) {
        return null;
    }

    public String getToolsPath(Sdk sdk) {
        return null;
    }

    public String getVMExecutablePath(Sdk sdk) {
        return null;
    }

    @Override
    public void saveAdditionalData(SdkAdditionalData additionalData, Element additional) {
    }

    @Override
    public SdkAdditionalData loadAdditionalData(Element additional) {
        return null;
    }

    @Override
    public String getPresentableName() {
        return ProjectBundle.message("sdk.unknown.name", new Object[0]);
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public Icon getIconForExpandedTreeNode() {
        return JDK_ICON_EXPANDED;
    }
}

