/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.PathUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Nullable;

public class JdkUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.JdkUtil");
    private static final String WRAPPER_CLASS = "com.intellij.rt.execution.CommandLineWrapper";

    private JdkUtil() {
    }

    @Nullable
    public static String getJdkMainAttribute(Sdk jdk, Attributes.Name attributeName) {
        ZipFile manifestJarFile;
        VirtualFile homeDirectory = jdk.getHomeDirectory();
        if (homeDirectory == null) {
            return null;
        }
        VirtualFile rtJar = homeDirectory.findFileByRelativePath("jre/lib/rt.jar");
        if (rtJar == null) {
            rtJar = homeDirectory.findFileByRelativePath("lib/rt.jar");
        }
        if (rtJar == null) {
            rtJar = homeDirectory.findFileByRelativePath("jre/lib/vm.jar");
        }
        if (rtJar == null) {
            rtJar = homeDirectory.findFileByRelativePath("../Classes/classes.jar");
        }
        if (rtJar == null) {
            return null;
        }
        VirtualFile rtJarFileContent = JarFileSystem.getInstance().findFileByPath(rtJar.getPath() + "!/");
        if (rtJarFileContent == null) {
            return null;
        }
        try {
            manifestJarFile = JarFileSystem.getInstance().getJarFile(rtJarFileContent);
        }
        catch (IOException e) {
            return null;
        }
        if (manifestJarFile == null) {
            return null;
        }
        try {
            ZipEntry entry = manifestJarFile.getEntry("META-INF/MANIFEST.MF");
            if (entry == null) {
                return null;
            }
            InputStream is = manifestJarFile.getInputStream(entry);
            Manifest manifest = new Manifest(is);
            is.close();
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue(attributeName);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean checkForJdk(File file) {
        if (!(file = new File(file.getAbsolutePath() + File.separator + "bin")).exists()) {
            return false;
        }
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                return Comparing.strEqual((String)FileUtil.getNameWithoutExtension((File)f), (String)"javac") || Comparing.strEqual((String)FileUtil.getNameWithoutExtension((File)f), (String)"javah");
            }
        };
        File[] children = file.listFiles(fileFilter);
        return children != null && children.length >= 2;
    }

    public static boolean checkForJre(String file) {
        File ioFile = new File(new File(file.replace('/', File.separatorChar)).getAbsolutePath() + File.separator + "bin");
        if (!ioFile.exists()) {
            return false;
        }
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isDirectory() && Comparing.strEqual((String)FileUtil.getNameWithoutExtension((File)f), (String)"java");
            }
        };
        File[] children = ioFile.listFiles(fileFilter);
        return children != null && children.length >= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeneralCommandLine setupJVMCommandLine(String exePath, SimpleJavaParameters javaParameters, boolean forceDynamicClasspath) {
        Class commandLineWrapper;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(exePath);
        ParametersList parametersList = javaParameters.getVMParametersList();
        commandLine.addParameters(parametersList.getList());
        if (!parametersList.hasProperty("file.encoding")) {
            Charset charset = javaParameters.getCharset();
            if (charset == null) {
                charset = EncodingManager.getInstance().getDefaultCharset();
            }
            if (charset == null) {
                charset = CharsetToolkit.getDefaultSystemCharset();
            }
            commandLine.setCharset(charset);
        }
        if (forceDynamicClasspath && (commandLineWrapper = JdkUtil.getCommandLineWrapperClass()) != null) {
            File classpathFile = null;
            if (!parametersList.hasParameter("-classpath") && !parametersList.hasParameter("-cp")) {
                try {
                    classpathFile = FileUtil.createTempFile((String)"classpath", null);
                    PrintWriter writer = new PrintWriter(classpathFile);
                    try {
                        for (String path : javaParameters.getClassPath().getPathList()) {
                            writer.println(path);
                        }
                    }
                    finally {
                        writer.close();
                    }
                    String classpath = PathUtil.getJarPathForClass(commandLineWrapper);
                    Class<UrlClassLoader> ourUrlClassLoader = UrlClassLoader.class;
                    if (ourUrlClassLoader.getName().equals(parametersList.getPropertyValue("java.system.class.loader"))) {
                        classpath = classpath + File.pathSeparator + PathUtil.getJarPathForClass(ourUrlClassLoader);
                    }
                    commandLine.addParameter("-classpath");
                    commandLine.addParameter(classpath);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (classpathFile != null) {
                commandLine.addParameter(commandLineWrapper.getName());
                commandLine.addParameter(classpathFile.getAbsolutePath());
            }
        } else if (!parametersList.hasParameter("-classpath") && !parametersList.hasParameter("-cp")) {
            commandLine.addParameter("-classpath");
            commandLine.addParameter(javaParameters.getClassPath().getPathsString());
        }
        String mainClass = javaParameters.getMainClass();
        commandLine.addParameter(mainClass);
        commandLine.addParameters(javaParameters.getProgramParametersList().getList());
        commandLine.setWorkDirectory(javaParameters.getWorkingDirectory());
        Map<String, String> env = javaParameters.getEnv();
        if (env != null) {
            commandLine.setEnvParams(env);
            commandLine.setPassParentEnvs(javaParameters.isPassParentEnvs());
        }
        return commandLine;
    }

    @Nullable
    private static Class getCommandLineWrapperClass() {
        try {
            return Class.forName(WRAPPER_CLASS);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean useDynamicClasspath(@Nullable Project project) {
        String hasDynamicProperty = System.getProperty("idea.dynamic.classpath", "false");
        return Boolean.valueOf(project != null ? PropertiesComponent.getInstance(project).getOrInit("dynamic.classpath", hasDynamicProperty) : hasDynamicProperty);
    }
}

