/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.BalloonHandler;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumbService {
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic("dumb mode", DumbModeListener.class);
    private static final NotNullLazyKey<DumbService, Project> INSTANCE_KEY = ServiceManager.createLazyKey(DumbService.class);

    public abstract boolean isDumb();

    public abstract void runWhenSmart(Runnable var1);

    public abstract void waitForSmartMode();

    public void smartInvokeLater(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/DumbService.smartInvokeLater must not be null");
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                DumbService.this.runWhenSmart(runnable);
            }
        });
    }

    public void smartInvokeLater(final @NotNull Runnable runnable, ModalityState modalityState) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/DumbService.smartInvokeLater must not be null");
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                DumbService.this.runWhenSmart(runnable);
            }
        }, modalityState);
    }

    public static DumbService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/DumbService.getInstance must not be null");
        }
        return (DumbService)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    public <T> List<T> filterByDumbAwareness(@Nullable Collection<T> collection) {
        if (this.isDumb()) {
            ArrayList<T> result = new ArrayList<T>(collection);
            Iterator<T> iterator = result.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof DumbAware) continue;
                iterator.remove();
            }
            return result;
        }
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    public DumbUnawareHider wrapGently(@NotNull JComponent dumbUnawareContent, @NotNull Disposable parentDisposable) {
        if (dumbUnawareContent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/DumbService.wrapGently must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/project/DumbService.wrapGently must not be null");
        }
        final DumbUnawareHider wrapper = new DumbUnawareHider(dumbUnawareContent);
        wrapper.setContentVisible(!this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, (Object)new DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                wrapper.setContentVisible(false);
            }

            @Override
            public void exitDumbMode() {
                wrapper.setContentVisible(true);
            }
        });
        return wrapper;
    }

    public void makeDumbAware(final @NotNull JComponent component, @NotNull Disposable disposable) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/DumbService.makeDumbAware must not be null");
        }
        if (disposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/project/DumbService.makeDumbAware must not be null");
        }
        component.setEnabled(!this.isDumb());
        this.getProject().getMessageBus().connect(disposable).subscribe(DUMB_MODE, (Object)new DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                component.setEnabled(false);
            }

            @Override
            public void exitDumbMode() {
                component.setEnabled(true);
            }
        });
    }

    public abstract BalloonHandler showDumbModeNotification(String var1);

    public abstract Project getProject();

    public static interface DumbModeListener {
        public void enteredDumbMode();

        public void exitDumbMode();
    }
}

