/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Task
implements TaskInfo {
    protected final Project myProject;
    protected String myTitle;
    private final boolean myCanBeCancelled;
    private String myCancelText;
    private String myCancelTooltipText;

    public Task(@Nullable Project project, @NotNull String title, boolean canBeCancelled) {
        if (title == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/progress/Task.<init> must not be null");
        }
        this.myCancelText = CommonBundle.getCancelButtonText();
        this.myCancelTooltipText = CommonBundle.getCancelButtonText();
        this.myProject = project;
        this.myTitle = title;
        this.myCanBeCancelled = canBeCancelled;
    }

    public abstract void run(@NotNull ProgressIndicator var1);

    public void onCancel() {
    }

    public void onSuccess() {
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final void queue() {
        ProgressManager.getInstance().run(this);
    }

    @Override
    public String getProcessId() {
        return "<unknown>";
    }

    @Override
    public final String getTitle() {
        return this.myTitle;
    }

    public final Task setTitle(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/Task.setTitle must not be null");
        }
        this.myTitle = title;
        return this;
    }

    @Override
    public final String getCancelText() {
        return this.myCancelText;
    }

    public final Task setCancelText(String cancelText) {
        this.myCancelText = cancelText;
        return this;
    }

    @Nullable
    public NotificationInfo getNotificationInfo() {
        return null;
    }

    public boolean isHeadless() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public final Task setCancelTooltipText(String cancelTooltipText) {
        this.myCancelTooltipText = cancelTooltipText;
        return this;
    }

    @Override
    public final String getCancelTooltipText() {
        return this.myCancelTooltipText;
    }

    @Override
    public final boolean isCancellable() {
        return this.myCanBeCancelled;
    }

    public abstract boolean isModal();

    public final Modal asModal() {
        if (this.isModal()) {
            return (Modal)this;
        }
        throw new IllegalStateException("Not a modal task");
    }

    public final Backgroundable asBackgroundable() {
        if (!this.isModal()) {
            return (Backgroundable)this;
        }
        throw new IllegalStateException("Not a backgroundable task");
    }

    public static class NotificationInfo {
        private final String myNotificationName;
        private final String myNotificationTitle;
        private final String myNotificationText;
        private final boolean myShowWhenFocused;

        public NotificationInfo(String notificationName, String notificationTitle, String notificationText) {
            this(notificationName, notificationTitle, notificationText, false);
        }

        public NotificationInfo(String notificationName, String notificationTitle, String notificationText, boolean showWhenFocused) {
            this.myNotificationName = notificationName;
            this.myNotificationTitle = notificationTitle;
            this.myNotificationText = notificationText;
            this.myShowWhenFocused = showWhenFocused;
        }

        public String getNotificationName() {
            return this.myNotificationName;
        }

        public String getNotificationTitle() {
            return this.myNotificationTitle;
        }

        public String getNotificationText() {
            return this.myNotificationText;
        }

        public boolean isShowWhenFocused() {
            return this.myShowWhenFocused;
        }
    }

    public static abstract class ConditionalModal
    extends Backgroundable {
        public ConditionalModal(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @NotNull PerformInBackgroundOption backgroundOption) {
            if (title == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/progress/Task$ConditionalModal.<init> must not be null");
            }
            if (backgroundOption == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/progress/Task$ConditionalModal.<init> must not be null");
            }
            super(project, title, canBeCancelled, backgroundOption);
        }

        @Override
        public final boolean isConditionalModal() {
            return true;
        }
    }

    public static abstract class Modal
    extends Task {
        public Modal(@Nullable Project project, @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/progress/Task$Modal.<init> must not be null");
            }
            super(project, title, canBeCancelled);
        }

        @Override
        public final boolean isModal() {
            return true;
        }
    }

    public static abstract class Backgroundable
    extends Task
    implements PerformInBackgroundOption {
        protected final PerformInBackgroundOption myBackgroundOption;

        public Backgroundable(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @Nullable PerformInBackgroundOption backgroundOption) {
            if (title == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/progress/Task$Backgroundable.<init> must not be null");
            }
            super(project, title, canBeCancelled);
            this.myBackgroundOption = backgroundOption;
        }

        public Backgroundable(@Nullable Project project, @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/progress/Task$Backgroundable.<init> must not be null");
            }
            this(project, title, canBeCancelled, null);
        }

        public Backgroundable(@Nullable Project project, @NotNull String title) {
            if (title == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/progress/Task$Backgroundable.<init> must not be null");
            }
            this(project, title, true);
        }

        @Override
        public boolean shouldStartInBackground() {
            return this.myBackgroundOption == null || this.myBackgroundOption.shouldStartInBackground();
        }

        @Override
        public void processSentToBackground() {
            if (this.myBackgroundOption != null) {
                this.myBackgroundOption.processSentToBackground();
            }
        }

        @Override
        public final boolean isModal() {
            return false;
        }

        public boolean isConditionalModal() {
            return false;
        }

        public DumbModeAction getDumbModeAction() {
            return DumbModeAction.NOTHING;
        }
    }
}

