/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTypedHandlerBean;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class TypedAction {
    private TypedActionHandler myHandler = new Handler();
    private boolean myHandlersLoaded;

    private void ensureHandlersLoaded() {
        if (!this.myHandlersLoaded) {
            this.myHandlersLoaded = true;
            for (EditorTypedHandlerBean handlerBean : (EditorTypedHandlerBean[])Extensions.getExtensions(EditorTypedHandlerBean.EP_NAME)) {
                this.myHandler = handlerBean.getHandler(this.myHandler);
            }
        }
    }

    public TypedActionHandler getHandler() {
        this.ensureHandlersLoaded();
        return this.myHandler;
    }

    public TypedActionHandler setupHandler(TypedActionHandler handler) {
        this.ensureHandlersLoaded();
        TypedActionHandler tmp = this.myHandler;
        this.myHandler = handler;
        return tmp;
    }

    public final void actionPerformed(final Editor editor, final char charTyped, final DataContext dataContext) {
        if (editor == null) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new DocumentRunnable(editor.getDocument(), editor.getProject()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Document doc = editor.getDocument();
                        doc.startGuardedBlockChecking();
                        try {
                            TypedAction.this.getHandler().execute(editor, charTyped, dataContext);
                        }
                        catch (ReadOnlyFragmentModificationException e) {
                            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
                        }
                        finally {
                            doc.stopGuardedBlockChecking();
                        }
                    }
                });
            }
        };
        CommandProcessor.getInstance().executeCommand(PlatformDataKeys.PROJECT.getData(dataContext), command, "", editor.getDocument(), UndoConfirmationPolicy.DEFAULT, editor.getDocument());
    }

    private static class Handler
    implements TypedActionHandler {
        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/actionSystem/TypedAction$Handler.execute must not be null");
            }
            if (dataContext == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/actionSystem/TypedAction$Handler.execute must not be null");
            }
            if (editor.isViewer()) {
                return;
            }
            Document doc = editor.getDocument();
            Project project = PlatformDataKeys.PROJECT.getData(dataContext);
            if (!FileDocumentManager.getInstance().requestWriting(doc, project)) {
                return;
            }
            doc.startGuardedBlockChecking();
            try {
                String str = String.valueOf(charTyped);
                CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message("typing.in.editor.command.name", new Object[0]));
                EditorModificationUtil.typeInStringAtCaretHonorBlockSelection(editor, str, true);
            }
            catch (ReadOnlyFragmentModificationException e) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
            }
            finally {
                doc.stopGuardedBlockChecking();
            }
        }
    }
}

