/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NotNull;

public class ServiceManager {
    private ServiceManager() {
    }

    public static <T> T getService(Class<T> serviceClass) {
        return (T)ApplicationManager.getApplication().getPicoContainer().getComponentInstance((Object)serviceClass.getName());
    }

    public static <T> T getService(Project project, Class<T> serviceClass) {
        return (T)project.getPicoContainer().getComponentInstance((Object)serviceClass.getName());
    }

    public static <T> NotNullLazyKey<T, Project> createLazyKey(final Class<T> serviceClass) {
        return NotNullLazyKey.create((String)("Service: " + serviceClass.getName()), (NotNullFunction)new NotNullFunction<Project, T>(){

            @NotNull
            public T fun(Project project) {
                Object t = ServiceManager.getService(project, serviceClass);
                if (t == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/components/ServiceManager$1.fun must not return null");
                }
                return t;
            }
        });
    }
}

