/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionInGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.util.Pair;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultActionGroup
extends ActionGroup {
    private final List<AnAction> mySortedChildren = new CopyOnWriteArrayList<AnAction>();
    private final List<Pair<AnAction, Constraints>> myPairs = new CopyOnWriteArrayList<Pair<AnAction, Constraints>>();

    public DefaultActionGroup() {
        this(null, false);
    }

    public DefaultActionGroup(AnAction ... actions) {
        this(null, false);
        for (AnAction action : actions) {
            this.add(action);
        }
    }

    public DefaultActionGroup(String shortName, boolean popup) {
        super(shortName, popup);
    }

    public final void add(@NotNull AnAction action, @NotNull ActionManager actionManager) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        if (actionManager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        this.add(action, new Constraints(Anchor.LAST, null), actionManager);
    }

    public final void add(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        this.addAction(action, new Constraints(Anchor.LAST, null));
    }

    public final ActionInGroup addAction(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.addAction must not be null");
        }
        return this.addAction(action, new Constraints(Anchor.LAST, null));
    }

    public final void addSeparator() {
        this.add(Separator.getInstance());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        if (constraint == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        this.add(action, constraint, ActionManager.getInstance());
    }

    public final ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.addAction must not be null");
        }
        if (constraint == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.addAction must not be null");
        }
        return this.addAction(action, constraint, ActionManager.getInstance());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        if (constraint == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        if (actionManager == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.add must not be null");
        }
        this.addAction(action, constraint, actionManager);
    }

    public final ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.addAction must not be null");
        }
        if (constraint == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.addAction must not be null");
        }
        if (actionManager == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/actionSystem/DefaultActionGroup.addAction must not be null");
        }
        if (action == this) {
            throw new IllegalArgumentException("Cannot add a group to itself");
        }
        if (!(action instanceof Separator)) {
            if (this.mySortedChildren.contains(action)) {
                throw new IllegalArgumentException("cannot add an action twice: " + action);
            }
            for (Pair<AnAction, Constraints> pair : this.myPairs) {
                if (!action.equals(pair.first)) continue;
                throw new IllegalArgumentException("cannot add an action twice: " + action);
            }
        }
        constraint = (Constraints)constraint.clone();
        if (constraint.myAnchor == Anchor.FIRST) {
            this.mySortedChildren.add(0, action);
        } else if (constraint.myAnchor == Anchor.LAST) {
            this.mySortedChildren.add(action);
        } else if (this.addToSortedList(action, constraint, actionManager)) {
            this.actionAdded(action, actionManager);
        } else {
            this.myPairs.add((Pair<AnAction, Constraints>)new Pair((Object)action, (Object)constraint));
        }
        return new ActionInGroup(this, action);
    }

    private void actionAdded(AnAction addedAction, ActionManager actionManager) {
        String addedActionId;
        String string = addedActionId = addedAction instanceof ActionStub ? ((ActionStub)addedAction).getId() : actionManager.getId(addedAction);
        if (addedActionId == null) {
            return;
        }
        block0: while (!this.myPairs.isEmpty()) {
            for (int i = 0; i < this.myPairs.size(); ++i) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i);
                if (!this.addToSortedList((AnAction)pair.first, (Constraints)pair.second, actionManager)) continue;
                this.myPairs.remove(i);
                continue block0;
            }
        }
    }

    private boolean addToSortedList(AnAction action, Constraints constraint, ActionManager actionManager) {
        int index = DefaultActionGroup.findIndex(constraint.myRelativeToActionId, this.mySortedChildren, actionManager);
        if (index == -1) {
            return false;
        }
        if (constraint.myAnchor == Anchor.BEFORE) {
            this.mySortedChildren.add(index, action);
        } else {
            this.mySortedChildren.add(index + 1, action);
        }
        return true;
    }

    private static int findIndex(String actionId, List<AnAction> actions, ActionManager actionManager) {
        for (int i = 0; i < actions.size(); ++i) {
            String id;
            AnAction action = actions.get(i);
            if (!(action instanceof ActionStub ? ((ActionStub)action).getId().equals(actionId) : (id = actionManager.getId(action)) != null && id.equals(actionId))) continue;
            return i;
        }
        return -1;
    }

    public final void remove(AnAction action) {
        if (!this.mySortedChildren.remove(action)) {
            for (int i = 0; i < this.myPairs.size(); ++i) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i);
                if (!((AnAction)pair.first).equals(action)) continue;
                this.myPairs.remove(i);
                break;
            }
        }
    }

    public final void removeAll() {
        this.mySortedChildren.clear();
        this.myPairs.clear();
    }

    @Override
    @NotNull
    public final AnAction[] getChildren(@Nullable AnActionEvent e) {
        int i;
        int sortedSize = this.mySortedChildren.size();
        AnAction[] children = new AnAction[sortedSize + this.myPairs.size()];
        for (i = 0; i < sortedSize; ++i) {
            AnAction action = this.mySortedChildren.get(i);
            if (action instanceof ActionStub) {
                action = this.unstub(e, (ActionStub)action);
                this.mySortedChildren.set(i, action);
            }
            children[i] = action;
        }
        for (i = 0; i < this.myPairs.size(); ++i) {
            Pair<AnAction, Constraints> pair = this.myPairs.get(i);
            AnAction action = (AnAction)pair.first;
            if (action instanceof ActionStub) {
                action = this.unstub(e, (ActionStub)action);
                this.myPairs.set(i, (Pair<AnAction, Constraints>)Pair.create((Object)action, (Object)pair.second));
            }
            children[i + sortedSize] = action;
        }
        if (children == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/actionSystem/DefaultActionGroup.getChildren must not return null");
        }
        return children;
    }

    private AnAction unstub(AnActionEvent e, ActionStub stub) {
        ActionManager actionManager = e != null ? e.getActionManager() : ActionManager.getInstance();
        AnAction action = actionManager.getAction(stub.getId());
        this.replace(stub, action);
        return action;
    }

    public final int getChildrenCount() {
        return this.mySortedChildren.size() + this.myPairs.size();
    }

    @NotNull
    public final AnAction[] getChildActionsOrStubs() {
        int i;
        int sortedSize = this.mySortedChildren.size();
        AnAction[] children = new AnAction[sortedSize + this.myPairs.size()];
        for (i = 0; i < sortedSize; ++i) {
            children[i] = this.mySortedChildren.get(i);
        }
        for (i = 0; i < this.myPairs.size(); ++i) {
            children[i + sortedSize] = (AnAction)this.myPairs.get((int)i).first;
        }
        if (children == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/actionSystem/DefaultActionGroup.getChildActionsOrStubs must not return null");
        }
        return children;
    }

    public final void addAll(ActionGroup group) {
        for (AnAction each : group.getChildren(null)) {
            this.add(each);
        }
    }

    public final void addAll(AnAction ... actions) {
        for (AnAction each : actions) {
            this.add(each);
        }
    }

    public void addSeparator(@Nullable String separatorText) {
        this.add(new Separator(separatorText));
    }
}

