/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.awt.EventQueue;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Notifications {
    public static final Topic<Notifications> TOPIC = Topic.create((String)"Notifications", Notifications.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);
    public static final String SYSTEM_MESSAGES_GROUP_ID = "System Messages";

    public void notify(@NotNull Notification var1);

    public void notify(@NotNull Notification var1, @NotNull NotificationDisplayType var2);

    public static class Bus {
        public static void notify(@NotNull Notification notification) {
            if (notification == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/Notifications$Bus.notify must not be null");
            }
            Bus.notify(notification, NotificationDisplayType.BALLOON, null);
        }

        public static void notify(@NotNull Notification notification, @Nullable Project project) {
            if (notification == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/Notifications$Bus.notify must not be null");
            }
            Bus.notify(notification, NotificationDisplayType.BALLOON, project);
        }

        public static void notify(final @NotNull Notification notification, final @NotNull NotificationDisplayType defaultDisplayType, final @Nullable Project project) {
            MessageBus bus;
            if (notification == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/Notifications$Bus.notify must not be null");
            }
            if (defaultDisplayType == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/notification/Notifications$Bus.notify must not be null");
            }
            if (project != null && !project.isInitialized()) {
                StartupManager.getInstance(project).runWhenProjectIsInitialized(new Runnable(){

                    @Override
                    public void run() {
                        ((Notifications)project.getMessageBus().syncPublisher(TOPIC)).notify(notification, defaultDisplayType);
                    }
                });
                return;
            }
            MessageBus messageBus = bus = project == null ? ApplicationManager.getApplication().getMessageBus() : project.getMessageBus();
            if (EventQueue.isDispatchThread()) {
                ((Notifications)bus.syncPublisher(TOPIC)).notify(notification, defaultDisplayType);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((Notifications)bus.syncPublisher(TOPIC)).notify(notification, defaultDisplayType);
                    }
                });
            }
        }
    }
}

