/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class MergingLexerAdapter
extends DelegateLexer {
    private final TokenSet myTokensToMerge;
    private IElementType myTokenType;
    private int myState;
    private int myTokenStart;

    public MergingLexerAdapter(Lexer original, TokenSet tokensToMerge) {
        super(original);
        this.myTokensToMerge = tokensToMerge;
    }

    @Override
    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        super.start(buffer, startOffset, endOffset, initialState);
        this.myTokenType = null;
    }

    @Override
    public int getState() {
        this.locateToken();
        return this.myState;
    }

    @Override
    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    @Override
    public int getTokenStart() {
        this.locateToken();
        return this.myTokenStart;
    }

    @Override
    public int getTokenEnd() {
        this.locateToken();
        return super.getTokenStart();
    }

    @Override
    public void advance() {
        this.myTokenType = null;
    }

    private void locateToken() {
        if (this.myTokenType == null) {
            Lexer orig = this.getDelegate();
            this.myTokenType = orig.getTokenType();
            this.myTokenStart = orig.getTokenStart();
            this.myState = orig.getState();
            if (this.myTokenType == null) {
                return;
            }
            orig.advance();
            if (this.myTokensToMerge.contains(this.myTokenType)) {
                IElementType tokenType;
                while ((tokenType = orig.getTokenType()) == this.myTokenType) {
                    orig.advance();
                }
            }
        }
    }

    public Lexer getOriginal() {
        return this.getDelegate();
    }

    @Override
    public void restore(LexerPosition position) {
        MyLexerPosition pos = (MyLexerPosition)position;
        this.getDelegate().restore(pos.getOriginalPosition());
        this.myTokenType = pos.getType();
        this.myTokenStart = pos.getOffset();
        this.myState = pos.getOldState();
    }

    @Override
    public LexerPosition getCurrentPosition() {
        return new MyLexerPosition(this.myTokenStart, this.myTokenType, this.getDelegate().getCurrentPosition(), this.myState);
    }

    private static class MyLexerPosition
    implements LexerPosition {
        private final int myOffset;
        private final IElementType myTokenType;
        private final LexerPosition myOriginalPosition;
        private final int myOldState;

        public MyLexerPosition(int offset, IElementType tokenType, LexerPosition originalPosition, int oldState) {
            this.myOffset = offset;
            this.myTokenType = tokenType;
            this.myOriginalPosition = originalPosition;
            this.myOldState = oldState;
        }

        @Override
        public int getOffset() {
            return this.myOffset;
        }

        @Override
        public int getState() {
            return this.myOriginalPosition.getState();
        }

        public IElementType getType() {
            return this.myTokenType;
        }

        public LexerPosition getOriginalPosition() {
            return this.myOriginalPosition;
        }

        public int getOldState() {
            return this.myOldState;
        }
    }
}

