/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T myDefaultImplementation;
    private final Key<T> IN_LANGUAGE_CACHE = new Key("EXTENSIONS_IN_LANGUAGE");

    public LanguageExtension(@NonNls String epName) {
        this(epName, null);
    }

    public LanguageExtension(@NonNls String epName, T defaultImplementation) {
        super(epName);
        this.myDefaultImplementation = defaultImplementation;
    }

    @Override
    protected String keyToString(Language key) {
        return key.getID();
    }

    public T forLanguage(Language l) {
        Language base;
        Object cached = l.getUserData(this.IN_LANGUAGE_CACHE);
        if (cached != null) {
            return (T)cached;
        }
        List extensions = this.forKey(l);
        Object result = extensions.isEmpty() ? ((base = l.getBaseLanguage()) != null ? this.forLanguage(base) : this.myDefaultImplementation) : extensions.get(0);
        l.putUserData(this.IN_LANGUAGE_CACHE, result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<T> allForLanguage(Language l) {
        List list;
        Language base;
        List list2 = this.forKey(l);
        if (list2.isEmpty() && (base = l.getBaseLanguage()) != null) {
            list = this.allForLanguage(base);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/lang/LanguageExtension.allForLanguage must not return null");
            return list;
        }
        list = list2;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/lang/LanguageExtension.allForLanguage must not return null");
    }

    protected T getDefaultImplementation() {
        return this.myDefaultImplementation;
    }

    protected Key<T> getLanguageCache() {
        return this.IN_LANGUAGE_CACHE;
    }
}

