/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.text.StringTokenizer;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class SplitterProportionsDataImpl
implements SplitterProportionsData {
    private List<Float> proportions = new ArrayList<Float>();
    private static final String DATA_VERSION = "1";
    @NonNls
    private static final String ATTRIBUTE_PROPORTIONS = "proportions";
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";

    @Override
    public void saveSplitterProportions(Component root) {
        this.proportions.clear();
        this.doSaveSplitterProportions(root);
    }

    private void doSaveSplitterProportions(Component root) {
        if (root instanceof Splitter) {
            Float prop = Float.valueOf(((Splitter)root).getProportion());
            this.proportions.add(prop);
        }
        if (root instanceof Container) {
            Component[] children;
            for (Component child : children = ((Container)root).getComponents()) {
                this.doSaveSplitterProportions(child);
            }
        }
    }

    @Override
    public void restoreSplitterProportions(Component root) {
        this.restoreSplitterProportions(root, 0);
    }

    private int restoreSplitterProportions(Component root, int index) {
        if (root instanceof Splitter) {
            if (this.proportions.size() <= index) {
                return index;
            }
            ((Splitter)root).setProportion(this.proportions.get(index++).floatValue());
        }
        if (root instanceof Container) {
            Component[] children;
            for (Component child : children = ((Container)root).getComponents()) {
                index = this.restoreSplitterProportions(child, index);
            }
        }
        return index;
    }

    @Override
    public void externalizeToDimensionService(String key) {
        for (int i = 0; i < this.proportions.size(); ++i) {
            float proportion = this.proportions.get(i).floatValue();
            String serviceKey = key + "." + i;
            int value = (int)(proportion * 1000.0f);
            DimensionService.getInstance().setExtendedState(serviceKey, value);
        }
    }

    @Override
    public void externalizeFromDimensionService(String key) {
        this.proportions.clear();
        int i = 0;
        while (true) {
            String serviceKey = key + "." + i;
            int value = DimensionService.getInstance().getExtendedState(serviceKey);
            if (value == -1) break;
            double proportion = (double)value * 0.001;
            this.proportions.add(new Float(proportion));
            ++i;
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.proportions.clear();
        String prop = element.getAttributeValue(ATTRIBUTE_PROPORTIONS);
        String version = element.getAttributeValue(ATTRIBUTE_VERSION);
        if (prop != null && Comparing.equal((String)version, (String)DATA_VERSION)) {
            StringTokenizer tokenizer = new StringTokenizer(prop, ",");
            while (tokenizer.hasMoreTokens()) {
                String p = tokenizer.nextToken();
                this.proportions.add(Float.valueOf(p));
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        StringBuilder result = new StringBuilder();
        String sep = "";
        for (Float proportion : this.proportions) {
            result.append(sep);
            result.append(proportion);
            sep = ",";
        }
        element.setAttribute(ATTRIBUTE_PROPORTIONS, result.toString());
        element.setAttribute(ATTRIBUTE_VERSION, DATA_VERSION);
    }

    public List<Float> getProportions() {
        return this.proportions;
    }

    public void setProportions(List<Float> proportions) {
        this.proportions = proportions;
    }
}

