/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;

public abstract class QuickSwitchSchemeAction
extends AnAction
implements DumbAware {
    protected static final Icon ourCurrentAction = IconLoader.getIcon((String)"/diff/currentLine.png");
    protected static final Icon ourNotCurrentAction = new EmptyIcon(ourCurrentAction.getIconWidth(), ourCurrentAction.getIconHeight());

    @Override
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getData(PlatformDataKeys.PROJECT);
        DefaultActionGroup group = new DefaultActionGroup();
        this.fillActions(project, group, e.getDataContext());
        this.showPopup(e, group);
    }

    protected abstract void fillActions(Project var1, DefaultActionGroup var2, DataContext var3);

    private void showPopup(AnActionEvent e, DefaultActionGroup group) {
        if (group.getChildrenCount() == 0) {
            return;
        }
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(this.getPopupTitle(e), group, e.getDataContext(), this.getAidMethod(), true);
        popup.showCenteredInCurrentWindow(e.getData(PlatformDataKeys.PROJECT));
    }

    protected JBPopupFactory.ActionSelectionAid getAidMethod() {
        return JBPopupFactory.ActionSelectionAid.NUMBERING;
    }

    protected String getPopupTitle(AnActionEvent e) {
        return e.getPresentation().getText();
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(e.getData(PlatformDataKeys.PROJECT) != null && this.isEnabled());
    }

    protected abstract boolean isEnabled();
}

