/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.IconLoader;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ContextHelpAction
extends AnAction
implements DumbAware {
    private static final Icon myIcon = IconLoader.getIcon((String)"/actions/help.png");
    private final String myHelpID;

    public ContextHelpAction() {
        this(null);
    }

    public ContextHelpAction(@NonNls String helpID) {
        this.myHelpID = helpID;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        String helpId = this.getHelpId(dataContext);
        if (helpId != null) {
            HelpManager.getInstance().invokeHelp(helpId);
        }
    }

    @Nullable
    protected String getHelpId(DataContext dataContext) {
        return this.myHelpID != null ? this.myHelpID : PlatformDataKeys.HELP_ID.getData(dataContext);
    }

    @Override
    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        if ("MainMenu".equals(event.getPlace())) {
            DataContext dataContext = event.getDataContext();
            presentation.setEnabled(this.getHelpId(dataContext) != null);
        } else {
            presentation.setIcon(myIcon);
            presentation.setText(CommonBundle.getHelpButtonText());
        }
    }
}

