/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.CommonBundle;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.GuiUtils;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.ui.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BrowserUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + BrowserUtil.class.getName()));
    @NonNls
    private static final Pattern ourExternalPrefix = Pattern.compile("^[\\w\\+\\.\\-]{2,}:");
    private static final Pattern ourAnchorsuffix = Pattern.compile("#(.*)$");

    private BrowserUtil() {
    }

    public static boolean isAbsoluteURL(String url) {
        return ourExternalPrefix.matcher(url.toLowerCase()).find();
    }

    public static String getDocURL(String url) {
        Matcher anchorMatcher = ourAnchorsuffix.matcher(url);
        if (anchorMatcher.find()) {
            return anchorMatcher.reset().replaceAll("");
        }
        return url;
    }

    public static URL getURL(String url) throws MalformedURLException {
        if (!BrowserUtil.isAbsoluteURL(url)) {
            return new URL("file", "", url);
        }
        return VfsUtil.convertToURL(url);
    }

    private static void launchBrowser(String url, String[] command) {
        try {
            URL curl = BrowserUtil.getURL(url);
            if (curl != null) {
                String[] commandLine;
                String urlString = curl.toString();
                if (SystemInfo.isWindows && BrowserUtil.isUseDefaultBrowser()) {
                    commandLine = new String[command.length + 2];
                    System.arraycopy(command, 0, commandLine, 0, command.length);
                    commandLine[commandLine.length - 2] = "\"\"";
                    commandLine[commandLine.length - 1] = "\"" + BrowserUtil.redirectUrl(url, urlString) + "\"";
                } else {
                    commandLine = new String[command.length + 1];
                    System.arraycopy(command, 0, commandLine, 0, command.length);
                    commandLine[commandLine.length - 1] = BrowserUtil.escapeUrl(urlString);
                }
                Runtime.getRuntime().exec(commandLine);
            } else {
                BrowserUtil.showErrorMessage(IdeBundle.message("error.malformed.url", url), CommonBundle.getErrorTitle());
            }
        }
        catch (IOException e) {
            BrowserUtil.showErrorMessage(IdeBundle.message("error.cannot.start.browser", e.getMessage()), CommonBundle.getErrorTitle());
        }
    }

    private static String redirectUrl(String url, @NonNls String urlString) throws IOException {
        if (!(url.indexOf(38) != -1 || urlString.startsWith("file:") && urlString.indexOf("#") != -1)) {
            return urlString;
        }
        File redirect = File.createTempFile("redirect", ".html");
        redirect.deleteOnExit();
        FileWriter writer = new FileWriter(redirect);
        writer.write("<html><head></head><body><script type=\"text/javascript\">window.location=\"" + url + "\";</script></body></html>");
        writer.close();
        return VfsUtil.pathToUrl(redirect.getAbsolutePath());
    }

    private static boolean isUseDefaultBrowser() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return true;
        }
        return BrowserUtil.getGeneralSettingsInstance().isUseDefaultBrowser();
    }

    private static void showErrorMessage(final String message, final String title) {
        Application app = ApplicationManager.getApplication();
        if (app == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Messages.showMessageDialog(message, title, Messages.getErrorIcon());
            }
        };
        if (app.isDispatchThread()) {
            runnable.run();
        } else {
            app.invokeLater(runnable, ModalityState.NON_MODAL);
        }
    }

    private static void launchBrowserUsingStandardWay(String url) {
        String[] command;
        block3: {
            try {
                String browserPath = BrowserUtil.getGeneralSettingsInstance().getBrowserPath();
                if (browserPath == null || browserPath.trim().length() == 0) {
                    BrowserUtil.showErrorMessage(IdeBundle.message("error.please.specify.path.to.web.browser", new Object[0]), IdeBundle.message("title.browser.not.found", new Object[0]));
                    return;
                }
                command = new String[]{browserPath};
            }
            catch (NullPointerException e) {
                command = BrowserUtil.getDefaultBrowserCommand();
                if (command != null) break block3;
                BrowserUtil.showErrorMessage(IdeBundle.message("error.please.open.url.manually", url, ApplicationNamesInfo.getInstance().getProductName()), IdeBundle.message("title.browser.path.not.found", new Object[0]));
                return;
            }
        }
        BrowserUtil.launchBrowser(url, command);
    }

    private static GeneralSettings getGeneralSettingsInstance() {
        GeneralSettings settings = GeneralSettings.getInstance();
        if (settings != null) {
            return settings;
        }
        return new GeneralSettings();
    }

    public static void launchBrowser(String url, String name) {
        if (url.startsWith("jar:") && (url = BrowserUtil.extractFiles(url)) == null) {
            return;
        }
        if (BrowserUtil.canStartDefaultBrowser() && BrowserUtil.isUseDefaultBrowser()) {
            BrowserUtil.launchBrowser(url, BrowserUtil.getDefaultBrowserCommand());
        } else {
            BrowserUtil.launchBrowserUsingStandardWay(url);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String escapeUrl(@NotNull @NonNls String url) {
        String string;
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/BrowserUtil.escapeUrl must not be null");
        }
        if (SystemInfo.isWindows) {
            string = url.indexOf(32) > 0 ? "\"" + url + "\"" : url;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/ide/BrowserUtil.escapeUrl must not return null");
            return string;
        }
        string = url.replaceAll(" ", "%20");
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/ide/BrowserUtil.escapeUrl must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String extractFiles(String url) {
        try {
            VirtualFile file;
            int sharpPos = url.indexOf(35);
            String anchor = "";
            if (sharpPos != -1) {
                anchor = url.substring(sharpPos);
                url = url.substring(0, sharpPos);
            }
            if ((file = VirtualFileManager.getInstance().findFileByUrl(url)) == null || !(file.getFileSystem() instanceof JarFileSystem)) {
                return null;
            }
            JarFileSystem jarFileSystem = (JarFileSystem)file.getFileSystem();
            VirtualFile jarVirtualFile = jarFileSystem.getVirtualFileForJar(file);
            if (jarVirtualFile == null) {
                return null;
            }
            String targetFilePath = file.getPath();
            String targetFileRelativePath = targetFilePath.substring(targetFilePath.indexOf("!/") + "!/".length());
            String jarVirtualFileLocationHash = jarVirtualFile.getName() + Integer.toHexString(jarVirtualFile.getUrl().hashCode());
            final File outputDir = new File(BrowserUtil.getExtractedFilesDir(), jarVirtualFileLocationHash);
            final String currentTimestamp = String.valueOf(new File(jarVirtualFile.getPath()).lastModified());
            final File timestampFile = new File(outputDir, ".idea.timestamp");
            String previousTimestamp = null;
            if (timestampFile.exists()) {
                previousTimestamp = new String(FileUtil.loadFileText((File)timestampFile));
            }
            if (!currentTimestamp.equals(previousTimestamp)) {
                final Ref extract = new Ref();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        ConfirmExtractDialog dialog = new ConfirmExtractDialog();
                        if (dialog.isToBeShown()) {
                            dialog.show();
                            extract.set((Object)dialog.isOK());
                        } else {
                            extract.set((Object)true);
                        }
                    }
                };
                try {
                    GuiUtils.runOrInvokeAndWait(r);
                }
                catch (InvocationTargetException e) {
                    extract.set((Object)false);
                }
                catch (InterruptedException e) {
                    extract.set((Object)false);
                }
                if (!((Boolean)extract.get()).booleanValue()) {
                    return null;
                }
                final ZipFile jarFile = jarFileSystem.getJarFile(file);
                ZipEntry entry = jarFile.getEntry(targetFileRelativePath);
                if (entry == null) {
                    return null;
                }
                InputStream is = jarFile.getInputStream(entry);
                try {
                    ZipUtil.extractEntry((ZipEntry)entry, (InputStream)is, (File)outputDir);
                }
                finally {
                    is.close();
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new Task.Backgroundable(null, "Extracting files...", true){

                            @Override
                            public void run(final @NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/BrowserUtil$3$1.run must not be null");
                                }
                                final int size = jarFile.size();
                                final int[] counter = new int[]{0};
                                try {
                                    class MyFilter
                                    implements FilenameFilter {
                                        private final Set<File> myImportantDirs;
                                        private final boolean myImportantOnly;

                                        MyFilter(boolean importantOnly) {
                                            this.myImportantDirs = new HashSet<File>(Arrays.asList(outputDir, new File(outputDir, "resources")));
                                            this.myImportantOnly = importantOnly;
                                        }

                                        @Override
                                        public boolean accept(File dir, String name) {
                                            boolean result;
                                            indicator.checkCanceled();
                                            boolean bl = result = this.myImportantOnly == this.myImportantDirs.contains(dir);
                                            if (result) {
                                                indicator.setFraction((double)counter[0] / (double)size);
                                                counter[0] = counter[0] + 1;
                                            }
                                            return result;
                                        }
                                    }
                                    ZipUtil.extract((ZipFile)jarFile, (File)outputDir, (FilenameFilter)new MyFilter(true));
                                    ZipUtil.extract((ZipFile)jarFile, (File)outputDir, (FilenameFilter)new MyFilter(false));
                                    FileUtil.writeToFile((File)timestampFile, (byte[])currentTimestamp.getBytes());
                                }
                                catch (IOException ignore) {
                                    // empty catch block
                                }
                            }
                        }.queue();
                    }
                });
            }
            return VfsUtil.pathToUrl(FileUtil.toSystemIndependentName((String)new File(outputDir, targetFileRelativePath).getPath())) + anchor;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            Messages.showErrorDialog("Cannot extract files: " + e.getMessage(), "Error");
            return null;
        }
    }

    public static void clearExtractedFiles() {
        FileUtil.delete((File)BrowserUtil.getExtractedFilesDir());
    }

    private static File getExtractedFilesDir() {
        return new File(PathManager.getSystemPath(), "ExtractedFiles");
    }

    public static void launchBrowser(@NonNls String url) {
        BrowserUtil.launchBrowser(url, (String)null);
    }

    @NonNls
    private static String[] getDefaultBrowserCommand() {
        if (SystemInfo.isWindows9x) {
            return new String[]{"command.com", "/c", "start"};
        }
        if (SystemInfo.isWindows) {
            return new String[]{"cmd.exe", "/c", "start"};
        }
        if (SystemInfo.isMac) {
            return new String[]{"open"};
        }
        if (SystemInfo.isUnix) {
            return new String[]{"mozilla"};
        }
        return null;
    }

    public static boolean canStartDefaultBrowser() {
        if (SystemInfo.isMac) {
            return true;
        }
        return SystemInfo.isWindows;
    }

    private static class ConfirmExtractDialog
    extends OptionsDialog {
        private ConfirmExtractDialog() {
            super(null);
            this.setTitle("Confirmation");
            this.init();
        }

        @Override
        protected boolean isToBeShown() {
            return BrowserUtil.getGeneralSettingsInstance().isConfirmExtractFiles();
        }

        @Override
        protected void setToBeShown(boolean value, boolean onOk) {
            BrowserUtil.getGeneralSettingsInstance().setConfirmExtractFiles(value);
        }

        @Override
        protected boolean shouldSaveOptionsOnCancel() {
            return true;
        }

        @Override
        protected Action[] createActions() {
            this.setOKButtonText(CommonBundle.getYesButtonText());
            return new Action[]{this.getOKAction(), this.getCancelAction()};
        }

        @Override
        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            String message = "The files are inside an archive, do you want them to be extracted?";
            JLabel label = new JLabel(message);
            label.setIconTextGap(10);
            label.setIcon(Messages.getQuestionIcon());
            panel.add((Component)label, "Center");
            panel.add(Box.createVerticalStrut(10), "South");
            return panel;
        }
    }
}

