/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionEnvironment {
    private DataContext myDataContext;
    private RunProfile myRunProfile;
    private RunnerSettings myRunnerSettings;
    private ConfigurationPerRunnerSettings myConfigurationSettings;

    public ExecutionEnvironment() {
    }

    public ExecutionEnvironment(@NotNull ProgramRunner runner, @NotNull RunnerAndConfigurationSettings configuration, DataContext context) {
        if (runner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/runners/ExecutionEnvironment.<init> must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/runners/ExecutionEnvironment.<init> must not be null");
        }
        this(configuration.getConfiguration(), configuration.getRunnerSettings(runner), configuration.getConfigurationSettings(runner), context);
    }

    public ExecutionEnvironment(@NotNull RunProfile profile, DataContext dataContext) {
        if (profile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/runners/ExecutionEnvironment.<init> must not be null");
        }
        this.myRunProfile = profile;
        this.myDataContext = dataContext;
    }

    public ExecutionEnvironment(@NotNull RunProfile runProfile, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings, DataContext dataContext) {
        if (runProfile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/runners/ExecutionEnvironment.<init> must not be null");
        }
        this(runProfile, dataContext);
        this.myRunnerSettings = runnerSettings;
        this.myConfigurationSettings = configurationSettings;
    }

    @NotNull
    public RunProfile getRunProfile() {
        RunProfile runProfile = this.myRunProfile;
        if (runProfile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/runners/ExecutionEnvironment.getRunProfile must not return null");
        }
        return runProfile;
    }

    @Nullable
    public Project getProject() {
        return PlatformDataKeys.PROJECT.getData(this.myDataContext);
    }

    @Deprecated
    public DataContext getDataContext() {
        return this.myDataContext;
    }

    @Nullable
    public RunContentDescriptor getContentToReuse() {
        return GenericProgramRunner.CONTENT_TO_REUSE_DATA_KEY.getData(this.myDataContext);
    }

    @Nullable
    public RunnerSettings getRunnerSettings() {
        return this.myRunnerSettings;
    }

    public ConfigurationPerRunnerSettings getConfigurationSettings() {
        return this.myConfigurationSettings;
    }

    @Nullable
    public RunProfileState getState(Executor executor) throws ExecutionException {
        return this.myRunProfile.getState(executor, this);
    }
}

