/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import java.nio.charset.Charset;

public class CapturingProcessHandler
extends OSProcessHandler {
    private final Charset myCharset;
    private final ProcessOutput myOutput = new ProcessOutput();

    public CapturingProcessHandler(Process process) {
        this(process, null, "");
    }

    public CapturingProcessHandler(Process process, Charset charset) {
        this(process, charset, "");
    }

    public CapturingProcessHandler(Process process, Charset charset, String commandLine) {
        super(process, commandLine);
        this.myCharset = charset;
        this.addProcessListener(new ProcessAdapter(){

            @Override
            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType == ProcessOutputTypes.STDOUT) {
                    CapturingProcessHandler.this.myOutput.appendStdout(event.getText());
                }
                if (outputType == ProcessOutputTypes.STDERR) {
                    CapturingProcessHandler.this.myOutput.appendStderr(event.getText());
                }
            }
        });
    }

    public ProcessOutput runProcess() {
        this.startNotify();
        this.waitFor();
        this.myOutput.setExitCode(this.getProcess().exitValue());
        return this.myOutput;
    }

    public ProcessOutput runProcess(int timeoutInMilliseconds) {
        if (timeoutInMilliseconds < 0) {
            return this.runProcess();
        }
        this.startNotify();
        if (this.waitFor(timeoutInMilliseconds)) {
            this.myOutput.setExitCode(this.getProcess().exitValue());
        } else {
            this.destroyProcess();
            this.myOutput.setTimeout();
        }
        return this.myOutput;
    }

    @Override
    public Charset getCharset() {
        if (this.myCharset != null) {
            return this.myCharset;
        }
        return super.getCharset();
    }
}

