/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParametersList
implements Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.ParametersList");
    private List<String> myParameters = new ArrayList<String>();
    private Map<String, String> myMacroMap = null;

    public boolean hasParameter(@NonNls String param) {
        return this.myParameters.contains(param);
    }

    public boolean hasProperty(@NonNls String name) {
        for (String parameter : this.myParameters) {
            if (!StringUtil.startsWithConcatenationOf((String)parameter, (String)("-D" + name), (String)"=")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getPropertyValue(@NonNls String name) {
        for (String parameter : this.myParameters) {
            String prefix;
            if (!parameter.startsWith(prefix = "-D" + name + "=")) continue;
            return parameter.substring(prefix.length());
        }
        return null;
    }

    public String getParametersString() {
        StringBuilder buffer = new StringBuilder();
        String separator = " ";
        for (String param : this.myParameters) {
            buffer.append(" ");
            buffer.append(GeneralCommandLine.quote(param));
        }
        return buffer.toString();
    }

    public String[] getArray() {
        return ArrayUtil.toStringArray(this.myParameters);
    }

    public void addParametersString(String parameters) {
        if (parameters != null) {
            String[] parms;
            for (String parm : parms = ParametersList.parse(parameters)) {
                this.add(parm);
            }
        }
    }

    public void add(@NonNls String parameter) {
        this.myParameters.add(this.expandMacros(parameter));
    }

    public void addAt(int index, @NotNull String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/configurations/ParametersList.addAt must not be null");
        }
        this.myParameters.add(index, this.expandMacros(parameter));
    }

    public void defineProperty(@NonNls String propertyName, @NonNls String propertyValue) {
        this.myParameters.add("-D" + propertyName + "=" + propertyValue);
    }

    public void replaceOrAppend(@NonNls String parameterPrefix, @NonNls String replacement) {
        this.replaceOrAdd(parameterPrefix, replacement, this.myParameters.size());
    }

    private void replaceOrAdd(@NonNls String parameterPrefix, @NonNls String replacement, int position) {
        ListIterator<String> iterator = this.myParameters.listIterator();
        while (iterator.hasNext()) {
            String param = iterator.next();
            if (!param.startsWith(parameterPrefix)) continue;
            if ("".equals(replacement)) {
                iterator.remove();
            } else {
                iterator.set(replacement);
            }
            return;
        }
        if (!"".equals(replacement)) {
            this.myParameters.add(position, replacement);
        }
    }

    public void replaceOrPrepend(@NonNls String parameter, @NonNls String replacement) {
        this.replaceOrAdd(parameter, replacement, 0);
    }

    public List<String> getList() {
        return Collections.unmodifiableList(this.myParameters);
    }

    public void prepend(@NonNls String parameter) {
        this.addAt(0, parameter);
    }

    public void add(@NonNls String name, @NonNls String value) {
        this.add(name);
        this.add(value);
    }

    public void addAll(String[] parameters) {
        this.myParameters.addAll(Arrays.asList(parameters));
    }

    public void addAll(List<String> parameters) {
        this.myParameters.addAll(parameters);
    }

    public ParametersList clone() {
        try {
            ParametersList clone = (ParametersList)super.clone();
            clone.myParameters = new ArrayList<String>(this.myParameters);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static String[] parse(String string) {
        return new ParametersTokenizer(string).execute();
    }

    public String expandMacros(String text) {
        Map<String, String> macroMap = this.getMacroMap();
        Set<String> set = macroMap.keySet();
        for (String from : set) {
            String to = macroMap.get(from);
            text = StringUtil.replace((String)text, (String)from, (String)to, (boolean)true);
        }
        return text;
    }

    private Map<String, String> getMacroMap() {
        if (this.myMacroMap == null) {
            this.myMacroMap = new LinkedHashMap<String, String>();
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                application.runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        PathMacros pathMacros = PathMacros.getInstance();
                        Set<String> names = pathMacros.getAllMacroNames();
                        for (String name : names) {
                            ParametersList.this.myMacroMap.put("${" + name + "}", pathMacros.getValue(name));
                        }
                    }
                });
                Map env = EnvironmentUtil.getEnviromentProperties();
                for (String name : env.keySet()) {
                    String key = "${" + name + "}";
                    if (this.myMacroMap.containsKey(key)) continue;
                    this.myMacroMap.put(key, (String)env.get(name));
                }
            }
        }
        return this.myMacroMap;
    }

    private static class ParametersTokenizer {
        private final String myParamsString;
        private final List<String> myArray = new ArrayList<String>();
        private final StringBuffer myBuffer = new StringBuffer(128);
        private boolean myTokenStarted = false;
        private boolean myUnquotedSlash = false;

        public ParametersTokenizer(String parmsString) {
            this.myParamsString = parmsString;
        }

        public String[] execute() {
            boolean inQuotes = false;
            boolean wasEscaped = false;
            for (int i = 0; i < this.myParamsString.length(); ++i) {
                char c = this.myParamsString.charAt(i);
                if (inQuotes) {
                    LOG.assertTrue(!this.myUnquotedSlash);
                    if (wasEscaped) {
                        this.append(c);
                        wasEscaped = false;
                        continue;
                    }
                    if (c == '\"') {
                        inQuotes = false;
                        continue;
                    }
                    if (c == '\\') {
                        this.myTokenStarted = true;
                        this.append(c);
                        wasEscaped = true;
                        continue;
                    }
                    this.append(c);
                    continue;
                }
                inQuotes = this.processNotQuoted(c);
            }
            this.tokenFinished();
            return ArrayUtil.toStringArray(this.myArray);
        }

        private boolean processNotQuoted(char c) {
            if (c == '\"') {
                if (this.myUnquotedSlash) {
                    this.append(c);
                    this.myUnquotedSlash = false;
                    return false;
                }
                this.myTokenStarted = true;
                return true;
            }
            if (c == ' ') {
                this.tokenFinished();
            } else {
                if (c == '\\') {
                    this.myUnquotedSlash = true;
                    this.append(c);
                    return false;
                }
                this.append(c);
            }
            this.myUnquotedSlash = false;
            return false;
        }

        private void append(char nextChar) {
            this.myBuffer.append(nextChar);
            this.myTokenStarted = true;
        }

        private void tokenFinished() {
            if (this.myTokenStarted) {
                String token = this.myBuffer.length() == 0 ? "\"\"" : this.myBuffer.toString();
                this.myArray.add(token);
            }
            this.myBuffer.setLength(0);
            this.myTokenStarted = false;
        }
    }
}

