/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.XmlSuppressionProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlSuppressableInspectionTool
extends LocalInspectionTool
implements CustomSuppressableInspectionTool {
    @NonNls
    static final String ALL = "ALL";

    @Override
    public SuppressIntentionAction[] getSuppressActions(PsiElement element) {
        return new SuppressIntentionAction[]{new SuppressTag(), new SuppressForFile(this.getID()), new SuppressAllForFile()};
    }

    @Override
    public boolean isSuppressedFor(PsiElement element) {
        return XmlSuppressionProvider.isSuppressed(element, this.getID());
    }

    public static class SuppressAllForFile
    extends SuppressForFile {
        public SuppressAllForFile() {
            super(XmlSuppressableInspectionTool.ALL);
        }

        @Override
        @NotNull
        public String getText() {
            String string = InspectionsBundle.message("xml.suppressable.all.for.file.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressAllForFile.getText must not return null");
            }
            return string;
        }
    }

    public static class SuppressForFile
    extends SuppressIntentionAction {
        private final String myInspectionId;

        public SuppressForFile(String inspectionId) {
            this.myInspectionId = inspectionId;
        }

        @Override
        @NotNull
        public String getText() {
            String string = InspectionsBundle.message("xml.suppressable.for.file.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile.getText must not return null");
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile.getFamilyName must not return null");
            }
            return string;
        }

        @Override
        public void invoke(Project project, Editor editor, PsiElement element) throws IncorrectOperationException {
            XmlSuppressionProvider.getProvider(element.getContainingFile()).suppressForFile(element, this.myInspectionId);
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile.isAvailable must not be null");
            }
            return element != null && element.isValid() && element.getContainingFile() instanceof XmlFile;
        }

        @Override
        public boolean startInWriteAction() {
            return true;
        }
    }

    public class SuppressTag
    extends SuppressIntentionAction {
        @Override
        @NotNull
        public String getText() {
            String string = InspectionsBundle.message("xml.suppressable.for.tag.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTag.getText must not return null");
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTag.getFamilyName must not return null");
            }
            return string;
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTag.isAvailable must not be null");
            }
            return PsiTreeUtil.getParentOfType(element, XmlTag.class) != null;
        }

        @Override
        public void invoke(Project project, Editor editor, PsiElement element) throws IncorrectOperationException {
            XmlSuppressionProvider.getProvider(element.getContainingFile()).suppressForTag(element, XmlSuppressableInspectionTool.this.getID());
        }

        @Override
        public boolean startInWriteAction() {
            return true;
        }
    }
}

