/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.util.FilePathByPathComparator;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.FilePathUtil;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnVcs;

public class SvnUpdateContext
implements SequentialUpdatesContext {
    private final Set<File> myUpdatedExternals;
    private final SvnVcs myVcs;
    private final List<FilePath> myContentRoots;

    public SvnUpdateContext(SvnVcs vcs, FilePath[] contentRoots) {
        this.myVcs = vcs;
        this.myContentRoots = Arrays.asList(contentRoots);
        Collections.sort(this.myContentRoots, FilePathByPathComparator.getInstance());
        this.myUpdatedExternals = new HashSet<File>();
    }

    @NotNull
    public String getMessageWhenInterruptedBeforeStart() {
        if (null == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/update/SvnUpdateContext.getMessageWhenInterruptedBeforeStart must not return null");
        }
        return null;
    }

    public boolean shouldFail() {
        return false;
    }

    public void registerExternalRootBeingUpdated(File root) {
        this.myUpdatedExternals.add(root);
    }

    public boolean shouldRunFor(File ioRoot) {
        RootUrlInfo info;
        if (this.myUpdatedExternals.contains(ioRoot)) {
            return false;
        }
        if (FilePathUtil.isNested(this.myContentRoots, ioRoot) && (info = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(ioRoot)) != null) {
            return !NestedCopyType.switched.equals((Object)info.getType());
        }
        return true;
    }
}

