/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.messages.Topic;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.dialogs.WCPaths;
import org.jetbrains.idea.svn.history.CopyData;
import org.jetbrains.idea.svn.history.FirstInBranch;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.mergeinfo.BranchInfo;
import org.jetbrains.idea.svn.mergeinfo.MergeinfoCached;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnMergeInfoCache {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache");
    private final Project myProject;
    private final MyState myState;
    private final SVNWCClient myClient;
    public static Topic<SvnMergeInfoCacheListener> SVN_MERGE_INFO_CACHE = new Topic("SVN_MERGE_INFO_CACHE", SvnMergeInfoCacheListener.class);

    private SvnMergeInfoCache(Project project) {
        this.myProject = project;
        this.myState = new MyState();
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        this.myClient = vcs.createWCClient();
        this.myClient.setOptions((ISVNOptions)new DefaultSVNOptions(){

            public byte[] getNativeEOL() {
                return new byte[]{10};
            }
        });
    }

    public static SvnMergeInfoCache getInstance(Project project) {
        return (SvnMergeInfoCache)ServiceManager.getService((Project)project, SvnMergeInfoCache.class);
    }

    public void clear(WCPaths info, String branchPath) {
        BranchInfo mergeChecker;
        String currentUrl = info.getRootUrl();
        MyCurrentUrlData rootMapping = this.myState.getCurrentUrlMapping().get(currentUrl);
        if (rootMapping != null && (mergeChecker = rootMapping.getBranchInfo(branchPath)) != null) {
            mergeChecker.clear();
        }
    }

    @Nullable
    public MergeinfoCached getCachedState(WCPaths info, String branchPath) {
        BranchInfo branchInfo;
        String currentUrl = info.getRootUrl();
        MyCurrentUrlData rootMapping = this.myState.getCurrentUrlMapping().get(currentUrl);
        if (rootMapping != null && (branchInfo = rootMapping.getBranchInfo(branchPath)) != null) {
            return branchInfo.getCached();
        }
        return null;
    }

    public MergeCheckResult getState(WCInfoWithBranches info, SvnChangeList list, WCInfoWithBranches.Branch selectedBranch) {
        return this.getState(info, list, selectedBranch, null);
    }

    public MergeCheckResult getState(WCInfoWithBranches info, SvnChangeList list, WCInfoWithBranches.Branch selectedBranch, String branchPath) {
        String currentUrl = info.getRootUrl();
        String branchUrl = selectedBranch.getUrl();
        MyCurrentUrlData rootMapping = this.myState.getCurrentUrlMapping().get(currentUrl);
        BranchInfo mergeChecker = null;
        if (rootMapping == null) {
            rootMapping = new MyCurrentUrlData();
            this.myState.getCurrentUrlMapping().put(currentUrl, rootMapping);
        } else {
            mergeChecker = rootMapping.getBranchInfo(branchPath);
        }
        if (mergeChecker == null) {
            mergeChecker = new BranchInfo(SvnVcs.getInstance(this.myProject), info.getRepoUrl(), branchUrl, currentUrl, info.getTrunkRoot(), this.myClient);
            rootMapping.addBranchInfo(branchPath, mergeChecker);
        }
        return mergeChecker.checkList(list, branchPath);
    }

    public boolean isMixedRevisions(WCInfoWithBranches info, String branchPath) {
        BranchInfo branchInfo;
        String currentUrl = info.getRootUrl();
        MyCurrentUrlData rootMapping = this.myState.getCurrentUrlMapping().get(currentUrl);
        if (rootMapping != null && (branchInfo = rootMapping.getBranchInfo(branchPath)) != null) {
            return branchInfo.isMixedRevisionsFound();
        }
        return false;
    }

    public static interface SvnMergeInfoCacheListener {
        public void copyRevisionUpdated();
    }

    private static class MyCurrentUrlData {
        private final Map<String, BranchInfo> myBranchInfo = new SoftHashMap();

        private MyCurrentUrlData() {
        }

        public BranchInfo getBranchInfo(String branchUrl) {
            return this.myBranchInfo.get(branchUrl);
        }

        public void addBranchInfo(String branchUrl, BranchInfo mergeChecker) {
            this.myBranchInfo.put(branchUrl, mergeChecker);
        }
    }

    static class CopyRevison {
        private final String myPath;
        private volatile long myRevision;

        CopyRevison(final SvnVcs vcs, String path, String repositoryRoot, String branchUrl, String trunkUrl) {
            this.myPath = path;
            this.myRevision = -1L;
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)new FirstInBranch(vcs, repositoryRoot, branchUrl, trunkUrl, new Consumer<CopyData>(){

                public void consume(CopyData copyData) {
                    if (copyData == null) {
                        return;
                    }
                    CopyRevison.this.myRevision = copyData.getCopySourceRevision();
                    if (CopyRevison.this.myRevision != -1L) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (vcs.getProject().isDisposed()) {
                                    return;
                                }
                                ((SvnMergeInfoCacheListener)vcs.getProject().getMessageBus().syncPublisher(SVN_MERGE_INFO_CACHE)).copyRevisionUpdated();
                            }
                        });
                    }
                }
            }));
        }

        public String getPath() {
            return this.myPath;
        }

        public long getRevision() {
            return this.myRevision;
        }
    }

    public static enum MergeCheckResult {
        COMMON,
        MERGED,
        NOT_MERGED,
        NOT_EXISTS,
        NOT_EXISTS_PARTLY_MERGED;


        public static MergeCheckResult getInstance(boolean merged) {
            if (merged) {
                return MERGED;
            }
            return NOT_MERGED;
        }
    }

    private static class MyState {
        private Map<String, MyCurrentUrlData> myCurrentUrlMapping = new HashMap<String, MyCurrentUrlData>();

        private MyState() {
        }

        public Map<String, MyCurrentUrlData> getCurrentUrlMapping() {
            return this.myCurrentUrlMapping;
        }

        public void setCurrentUrlMapping(Map<String, MyCurrentUrlData> currentUrlMapping) {
            this.myCurrentUrlMapping = currentUrlMapping;
        }
    }
}

