/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListDecorator;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListsListener;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.AbstractIntegrateChangesAction;
import org.jetbrains.idea.svn.actions.ChangeListsMergerFactory;
import org.jetbrains.idea.svn.actions.RecordOnlyMergerFactory;
import org.jetbrains.idea.svn.actions.ShowSvnMapAction;
import org.jetbrains.idea.svn.dialogs.SvnMapDialog;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnMergeInfoRootPanelManual;
import org.jetbrains.idea.svn.history.WcInfoLoader;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.Merger;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.SelectedChangeListsChecker;
import org.jetbrains.idea.svn.integrate.SelectedCommittedStuffChecker;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoHolder;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;

public class RootsAndBranches
implements CommittedChangeListDecorator {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.history.RootsAndBranches");
    private final Project myProject;
    private final DecoratorManager myManager;
    private final RepositoryLocation myLocation;
    private JPanel myPanel;
    private final Map<String, SvnMergeInfoRootPanelManual> myMergePanels;
    private final Map<String, MergeInfoHolder> myHolders;
    private boolean myHighlightingOn;
    private boolean myFromHereDirection;
    private JPanel myPanelWrapper;
    private final MergePanelFiltering myStrategy;
    private final FilterOutMerged myFilterMerged;
    private final FilterOutNotMerged myFilterNotMerged;
    private final FilterOutAlien myFilterAlien;
    private final IntegrateChangeListsAction myIntegrateAction;
    private final UndoIntegrateChangeListsAction myUndoIntegrateChangeListsAction;
    private JComponent myToolbarComponent;
    private boolean myDisposed;
    private final WcInfoLoader myDataLoader;
    public static final Topic<Runnable> REFRESH_REQUEST = new Topic("REFRESH_REQUEST", Runnable.class);

    private MergeInfoHolder getHolder(String key) {
        MergeInfoHolder holder = this.myHolders.get(key);
        if (holder != null) {
            return holder;
        }
        return this.myHolders.get(key.endsWith(File.separator) ? key.substring(0, key.length() - 1) : key + File.separator);
    }

    private SvnMergeInfoRootPanelManual getPanelData(String key) {
        SvnMergeInfoRootPanelManual panel = this.myMergePanels.get(key);
        if (panel != null) {
            return panel;
        }
        return this.myMergePanels.get(key.endsWith(File.separator) ? key.substring(0, key.length() - 1) : key + File.separator);
    }

    public RootsAndBranches(Project project, DecoratorManager manager, RepositoryLocation location) {
        this.myProject = project;
        this.myManager = manager;
        this.myLocation = location;
        this.myDataLoader = new WcInfoLoader(this.myProject, this.myLocation);
        this.myMergePanels = new HashMap<String, SvnMergeInfoRootPanelManual>();
        this.myHolders = new HashMap<String, MergeInfoHolder>();
        this.myFilterMerged = new FilterOutMerged();
        this.myFilterNotMerged = new FilterOutNotMerged();
        this.myFilterAlien = new FilterOutAlien();
        this.myIntegrateAction = new IntegrateChangeListsAction();
        this.myUndoIntegrateChangeListsAction = new UndoIntegrateChangeListsAction();
        this.myPanel = new JPanel(new GridBagLayout());
        this.myFromHereDirection = true;
        this.createToolbar();
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 0, new Insets(1, 1, 1, 1), 0, 0);
        gb.insets = new Insets(20, 1, 1, 1);
        this.myPanel.add((Component)new JLabel("Loading..."), gb);
        this.myPanel.setPreferredSize(new Dimension(200, 60));
        this.myManager.install((CommittedChangeListDecorator)this);
        this.setDirectionToPanels();
        this.myStrategy = new MergePanelFiltering(this.getPanel());
    }

    public IntegrateChangeListsAction getIntegrateAction() {
        return this.myIntegrateAction;
    }

    public UndoIntegrateChangeListsAction getUndoIntegrateAction() {
        return this.myUndoIntegrateChangeListsAction;
    }

    public void reloadPanels() {
        final HashMap<Pair, SvnMergeInfoRootPanelManual.InfoHolder> states = new HashMap<Pair, SvnMergeInfoRootPanelManual.InfoHolder>();
        for (Map.Entry<String, SvnMergeInfoRootPanelManual> entry : this.myMergePanels.entrySet()) {
            String localPath = entry.getKey();
            WCInfoWithBranches wcInfo = entry.getValue().getWcInfo();
            states.put(new Pair((Object)localPath, (Object)wcInfo.getUrl().toString()), entry.getValue().getInfo());
        }
        this.createPanels(this.myLocation, new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : RootsAndBranches.this.myMergePanels.entrySet()) {
                    WCInfoWithBranches wcInfo;
                    String localPath = (String)entry.getKey();
                    Pair key = new Pair((Object)localPath, (Object)(wcInfo = ((SvnMergeInfoRootPanelManual)entry.getValue()).getWcInfo()).getUrl().toString());
                    SvnMergeInfoRootPanelManual.InfoHolder infoHolder = (SvnMergeInfoRootPanelManual.InfoHolder)states.get(key);
                    if (infoHolder == null) continue;
                    ((SvnMergeInfoRootPanelManual)entry.getValue()).initSelection(infoHolder);
                }
            }
        });
    }

    public void turnFromHereHighlighting() {
        this.myHighlightingOn = true;
        this.myFromHereDirection = true;
        this.setDirectionToPanels();
        for (MergeInfoHolder holder : this.myHolders.values()) {
            holder.updateMixedRevisionsForPanel();
        }
        this.myManager.repaintTree();
    }

    public void turnFromThereHighlighting() {
        this.myHighlightingOn = true;
        this.myFromHereDirection = false;
        this.setDirectionToPanels();
        this.myManager.repaintTree();
    }

    private void setDirectionToPanels() {
        for (SvnMergeInfoRootPanelManual panel : this.myMergePanels.values()) {
            panel.setDirection(this.myFromHereDirection);
        }
    }

    public void turnOff() {
        this.myHighlightingOn = false;
        for (SvnMergeInfoRootPanelManual panelManual : this.myMergePanels.values()) {
            panelManual.setMixedRevisions(false);
        }
        this.myManager.repaintTree();
    }

    public Icon decorate(CommittedChangeList list) {
        MergeInfoHolder.ListMergeStatus status = this.getStatus(list, false);
        return status == null ? MergeInfoHolder.ListMergeStatus.ALIEN.getIcon() : status.getIcon();
    }

    private void createPanels(RepositoryLocation location, final Runnable afterRefresh) {
        Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, "Subversion: loading working copies data..", false, BackgroundFromStartOption.getInstance()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/history/RootsAndBranches$2.run must not be null");
                }
                indicator.setIndeterminate(true);
                final HashMap panels = new HashMap();
                final HashMap holders = new HashMap();
                final JPanel mainPanel = RootsAndBranches.this.prepareData(panels, holders);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (RootsAndBranches.this.myDisposed) {
                            return;
                        }
                        RootsAndBranches.this.myMergePanels.clear();
                        RootsAndBranches.this.myHolders.clear();
                        RootsAndBranches.this.myMergePanels.putAll(panels);
                        RootsAndBranches.this.myHolders.putAll(holders);
                        if (RootsAndBranches.this.myPanelWrapper != null) {
                            RootsAndBranches.this.myPanelWrapper.removeAll();
                            if (RootsAndBranches.this.myMergePanels.isEmpty()) {
                                JPanel emptyPanel = new JPanel(new GridBagLayout());
                                GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0);
                                JLabel label = new JLabel("No Subversion 1.5 working copies\nof 1.5 repositories in the project");
                                label.setUI((LabelUI)new MultiLineLabelUI());
                                emptyPanel.add((Component)label, gb);
                                gb.fill = 2;
                                RootsAndBranches.this.myPanelWrapper.add((Component)emptyPanel, gb);
                            } else {
                                for (MergeInfoHolder holder : RootsAndBranches.this.myHolders.values()) {
                                    holder.updateMixedRevisionsForPanel();
                                }
                                RootsAndBranches.this.myPanelWrapper.add((Component)mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
                            }
                            RootsAndBranches.this.myPanelWrapper.repaint();
                        } else {
                            RootsAndBranches.this.myPanel = mainPanel;
                        }
                        if (afterRefresh != null) {
                            afterRefresh.run();
                        }
                    }
                });
            }
        };
        ProgressManager.getInstance().run((Task)backgroundable);
    }

    public void refreshByLists(List<CommittedChangeList> committedChangeLists) {
        MergeInfoHolder holder;
        SvnChangeList svnList;
        String wcPath;
        if (!committedChangeLists.isEmpty() && (wcPath = (svnList = (SvnChangeList)committedChangeLists.get(0)).getWcPath()) != null && (holder = this.getHolder(wcPath)) != null) {
            holder.refresh(true);
        }
    }

    private void createToolbar() {
        DefaultActionGroup svnGroup = this.createActions();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)svnGroup, true);
        this.myToolbarComponent = actionToolbar.getComponent();
    }

    private JPanel prepareData(Map<String, SvnMergeInfoRootPanelManual> panels, Map<String, MergeInfoHolder> holders) {
        List<WCInfoWithBranches> roots = this.myDataLoader.loadRoots();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        boolean onlyOneRoot = roots.size() == 1;
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0);
        mainPanel.add((Component)this.myToolbarComponent, gb);
        ++gb.gridy;
        for (final WCInfoWithBranches root : roots) {
            if (root == null) continue;
            SvnMergeInfoRootPanelManual panel = new SvnMergeInfoRootPanelManual(this.myProject, new NullableFunction<WCInfoWithBranches, WCInfoWithBranches>(){

                public WCInfoWithBranches fun(WCInfoWithBranches wcInfoWithBranches) {
                    WCInfoWithBranches newInfo = RootsAndBranches.this.myDataLoader.reloadInfo(wcInfoWithBranches);
                    if (newInfo == null) {
                        ((Runnable)RootsAndBranches.this.myProject.getMessageBus().syncPublisher(SvnMapDialog.WC_CONVERTED)).run();
                        return wcInfoWithBranches;
                    }
                    return newInfo;
                }
            }, new Runnable(){

                @Override
                public void run() {
                    MergeInfoHolder holder = RootsAndBranches.this.getHolder(root.getPath());
                    if (holder != null) {
                        holder.refresh(false);
                    }
                }
            }, onlyOneRoot, root);
            panels.put(root.getPath(), panel);
            holders.put(root.getPath(), this.createHolder(panel));
            JPanel contentPanel = panel.getContentPanel();
            mainPanel.add((Component)contentPanel, gb);
            ++gb.gridy;
        }
        if (panels.size() == 1) {
            for (SvnMergeInfoRootPanelManual panel : panels.values()) {
                panel.setOnlyOneRoot(true);
            }
        }
        return mainPanel;
    }

    private DefaultActionGroup createActions() {
        DefaultActionGroup svnGroup = new DefaultActionGroup();
        svnGroup.add((AnAction)new HighlightFrom());
        svnGroup.add((AnAction)this.myIntegrateAction);
        svnGroup.add((AnAction)this.myUndoIntegrateChangeListsAction);
        svnGroup.add((AnAction)new MarkAsMerged());
        svnGroup.add((AnAction)new MarkAsNotMerged());
        svnGroup.add((AnAction)this.myFilterMerged);
        svnGroup.add((AnAction)this.myFilterNotMerged);
        svnGroup.add((AnAction)this.myFilterAlien);
        svnGroup.add((AnAction)new ShowSvnMapAction());
        svnGroup.add((AnAction)new MyRefresh());
        return svnGroup;
    }

    private MergeInfoHolder createHolder(final SvnMergeInfoRootPanelManual panel) {
        return new MergeInfoHolder(this.myProject, this.myManager, new Getter<WCInfoWithBranches>(){

            public WCInfoWithBranches get() {
                if (RootsAndBranches.this.myFromHereDirection) {
                    return panel.getWcInfo();
                }
                return null;
            }
        }, new Getter<WCInfoWithBranches.Branch>(){

            public WCInfoWithBranches.Branch get() {
                if (RootsAndBranches.this.myFromHereDirection) {
                    return panel.getBranch();
                }
                WCInfoWithBranches wcInfo = panel.getWcInfo();
                return new WCInfoWithBranches.Branch(wcInfo.getUrl().toString());
            }
        }, new Getter<String>(){

            public String get() {
                if (RootsAndBranches.this.myFromHereDirection) {
                    return panel.getLocalBranch();
                }
                WCInfoWithBranches wcInfo = panel.getWcInfo();
                return wcInfo.getPath();
            }
        }, new Getter<Boolean>(){

            public Boolean get() {
                return RootsAndBranches.this.myHighlightingOn && panel.isEnabled();
            }
        }, new Consumer<Boolean>(){

            public void consume(Boolean aBoolean) {
                panel.setMixedRevisions(aBoolean);
            }
        });
    }

    public JComponent getPanel() {
        this.myPanelWrapper = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension oldSize = super.getPreferredSize();
                oldSize.width = 200;
                return oldSize;
            }
        };
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.myPanelWrapper.add((Component)this.myPanel, gb);
        return new JScrollPane(this.myPanelWrapper, 20, 30);
    }

    private String ensureEndsWithSeparator(String wcPath) {
        return wcPath.endsWith(File.separator) ? wcPath : wcPath + File.separator;
    }

    public void refresh() {
        final HashMap<String, CommittedChangeListsListener> refreshers = new HashMap<String, CommittedChangeListsListener>();
        for (Map.Entry<String, MergeInfoHolder> entry : this.myHolders.entrySet()) {
            CommittedChangeListsListener refresher = entry.getValue().createRefresher(false);
            if (refresher == null) continue;
            refreshers.put(this.ensureEndsWithSeparator(entry.getKey()), refresher);
        }
        if (!refreshers.isEmpty()) {
            this.myManager.reportLoadedLists(new CommittedChangeListsListener(){

                public void onBeforeStartReport() {
                }

                public boolean report(CommittedChangeList list) {
                    CommittedChangeListsListener refresher;
                    SvnChangeList svnList;
                    String wcPath;
                    if (list instanceof SvnChangeList && (wcPath = (svnList = (SvnChangeList)list).getWcPath()) != null && (refresher = (CommittedChangeListsListener)refreshers.get(RootsAndBranches.this.ensureEndsWithSeparator(wcPath))) != null) {
                        refresher.report(list);
                    }
                    return true;
                }

                public void onAfterEndReport() {
                    for (CommittedChangeListsListener refresher : refreshers.values()) {
                        refresher.onAfterEndReport();
                    }
                    RootsAndBranches.this.myStrategy.notifyListener();
                }
            });
            this.myManager.repaintTree();
        }
    }

    private boolean mergeEnabled(List<CommittedChangeList> listsList, boolean forMerge) {
        if (listsList == null || listsList.isEmpty()) {
            return false;
        }
        for (CommittedChangeList list : listsList) {
            if (this.mergeEnabled(list, forMerge)) continue;
            return false;
        }
        return true;
    }

    private boolean mergeEnabled(CommittedChangeList list, boolean forMerge) {
        MergeInfoHolder.ListMergeStatus mergeStatus = this.getStatus(list, true);
        if (mergeStatus == null || MergeInfoHolder.ListMergeStatus.ALIEN.equals((Object)mergeStatus)) {
            return false;
        }
        if (MergeInfoHolder.ListMergeStatus.REFRESHING.equals((Object)mergeStatus)) {
            return true;
        }
        if (forMerge) {
            return MergeInfoHolder.ListMergeStatus.NOT_MERGED.equals((Object)mergeStatus);
        }
        return MergeInfoHolder.ListMergeStatus.MERGED.equals((Object)mergeStatus);
    }

    private SvnMergeInfoRootPanelManual getPanelData(List<CommittedChangeList> listsList) {
        for (CommittedChangeList list : listsList) {
            if (!(list instanceof SvnChangeList)) {
                return null;
            }
            SvnChangeList svnList = (SvnChangeList)list;
            String wcPath = svnList.getWcPath();
            if (wcPath == null) continue;
            return this.getPanelData(wcPath);
        }
        return null;
    }

    @Nullable
    public MergeInfoHolder.ListMergeStatus getStatus(CommittedChangeList list, boolean ignoreEnabled) {
        if (!(list instanceof SvnChangeList)) {
            return null;
        }
        SvnChangeList svnList = (SvnChangeList)list;
        String wcPath = svnList.getWcPath();
        MergeInfoHolder holder = null;
        if (wcPath == null) {
            for (Map.Entry<String, SvnMergeInfoRootPanelManual> entry : this.myMergePanels.entrySet()) {
                SvnMergeInfoRootPanelManual panelManual = entry.getValue();
                if (panelManual.getBranch() == null || panelManual.getBranch().getUrl() == null || !svnList.allPathsUnder(panelManual.getBranch().getUrl())) continue;
                holder = this.getHolder(entry.getKey());
            }
        } else {
            holder = this.getHolder(wcPath);
        }
        if (holder != null) {
            return holder.getDecorator().check(list, ignoreEnabled);
        }
        return null;
    }

    public MergePanelFiltering getStrategy() {
        return this.myStrategy;
    }

    public boolean strategyInitialized() {
        return this.myStrategy.isInitialized();
    }

    public void fireRepaint() {
        this.myManager.repaintTree();
    }

    public void dispose() {
        this.myDisposed = true;
    }

    private class MergePanelFiltering
    implements ChangeListFilteringStrategy {
        private final JComponent myPanel;
        private ChangeListener myListener;
        private boolean myInitialized;

        public MergePanelFiltering(JComponent panel) {
            this.myPanel = panel;
        }

        public boolean isInitialized() {
            return this.myInitialized;
        }

        public JComponent getFilterUI() {
            if (!this.myInitialized) {
                RootsAndBranches.this.createPanels(RootsAndBranches.this.myLocation, null);
            }
            this.myInitialized = true;
            return this.myPanel;
        }

        public void setFilterBase(List<CommittedChangeList> changeLists) {
        }

        public void addChangeListener(ChangeListener listener) {
            this.myListener = listener;
        }

        public void removeChangeListener(ChangeListener listener) {
            this.myListener = null;
        }

        public void resetFilterBase() {
        }

        public void appendFilterBase(List<CommittedChangeList> changeLists) {
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public List<CommittedChangeList> filterChangeLists(List<CommittedChangeList> changeLists) {
            List<CommittedChangeList> list;
            if (!(RootsAndBranches.this.myFilterAlien.isSelected(null) || RootsAndBranches.this.myFilterNotMerged.isSelected(null) || RootsAndBranches.this.myFilterMerged.isSelected(null))) {
                list = changeLists;
                if (list == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/history/RootsAndBranches$MergePanelFiltering.filterChangeLists must not return null");
                return list;
            }
            ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
            for (CommittedChangeList list2 : changeLists) {
                MergeInfoHolder.ListMergeStatus status = RootsAndBranches.this.getStatus(list2, true);
                if (MergeInfoHolder.ListMergeStatus.REFRESHING.equals((Object)status)) {
                    result.add(list2);
                    continue;
                }
                if (status == null || MergeInfoHolder.ListMergeStatus.ALIEN.equals((Object)status)) {
                    if (RootsAndBranches.this.myFilterAlien.isSelected(null)) continue;
                    result.add(list2);
                    continue;
                }
                if (MergeInfoHolder.ListMergeStatus.MERGED.equals((Object)status) || MergeInfoHolder.ListMergeStatus.COMMON.equals((Object)status)) {
                    if (RootsAndBranches.this.myFilterMerged.isSelected(null)) continue;
                    result.add(list2);
                    continue;
                }
                if (RootsAndBranches.this.myFilterNotMerged.isSelected(null)) continue;
                result.add(list2);
            }
            list = result;
            if (list != null) return list;
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/history/RootsAndBranches$MergePanelFiltering.filterChangeLists must not return null");
        }

        public void notifyListener() {
            if (this.myListener != null) {
                this.myListener.stateChanged(new ChangeEvent(this));
            }
            RootsAndBranches.this.myManager.repaintTree();
        }
    }

    private class IntegrateChangeListsAction
    extends AbstractIntegrateChangesAction<SelectedChangeListsChecker> {
        private final boolean myDirect;

        public IntegrateChangeListsAction() {
            this(true);
        }

        protected IntegrateChangeListsAction(boolean direct) {
            super(false);
            this.myDirect = direct;
        }

        @Override
        @NotNull
        protected MergerFactory createMergerFactory(SelectedChangeListsChecker checker) {
            ChangeListsMergerFactory changeListsMergerFactory = new ChangeListsMergerFactory(checker.getSelectedLists()){

                @Override
                public IMerger createMerger(SvnVcs vcs, File target, UpdateEventHandler handler, SVNURL currentBranchUrl, String branchName) {
                    return new Merger(vcs, this.myChangeListsList, target, handler, currentBranchUrl, branchName){

                        @Override
                        protected SVNRevisionRange createRange() {
                            if (IntegrateChangeListsAction.this.myDirect) {
                                return super.createRange();
                            }
                            return new SVNRevisionRange(SVNRevision.create((long)this.myLatestProcessed.getNumber()), SVNRevision.create((long)(this.myLatestProcessed.getNumber() - 1L)));
                        }
                    };
                }
            };
            if (changeListsMergerFactory == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/history/RootsAndBranches$IntegrateChangeListsAction.createMergerFactory must not return null");
            }
            return changeListsMergerFactory;
        }

        @Override
        @NotNull
        protected SelectedChangeListsChecker createChecker() {
            SelectedChangeListsChecker selectedChangeListsChecker = new SelectedChangeListsChecker();
            if (selectedChangeListsChecker == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/history/RootsAndBranches$IntegrateChangeListsAction.createChecker must not return null");
            }
            return selectedChangeListsChecker;
        }

        @Override
        protected void updateWithChecker(AnActionEvent e, SelectedCommittedStuffChecker checker) {
            e.getPresentation().setIcon(IconLoader.getIcon((String)"/icons/IntegrateToBranch.png"));
        }

        @Override
        protected String getSelectedBranchUrl(SelectedCommittedStuffChecker checker) {
            SvnMergeInfoRootPanelManual data = RootsAndBranches.this.getPanelData(checker.getSelectedLists());
            if (data != null && data.getBranch() != null) {
                return data.getBranch().getUrl();
            }
            return null;
        }

        @Override
        protected String getSelectedBranchLocalPath(SelectedCommittedStuffChecker checker) {
            SvnMergeInfoRootPanelManual data = RootsAndBranches.this.getPanelData(checker.getSelectedLists());
            if (data != null) {
                return data.getLocalBranch();
            }
            return null;
        }

        @Override
        protected String getDialogTitle() {
            return null;
        }
    }

    private class UndoIntegrateChangeListsAction
    extends IntegrateChangeListsAction {
        private UndoIntegrateChangeListsAction() {
            super(false);
        }

        @Override
        protected void updateWithChecker(AnActionEvent e, SelectedCommittedStuffChecker checker) {
            e.getPresentation().setIcon(IconLoader.getIcon((String)"/icons/UndoIntegrateToBranch.png"));
            e.getPresentation().setText(SvnBundle.message("undo.integrate.to.branch", new Object[0]));
            e.getPresentation().setDescription(SvnBundle.message("undo.integrate.to.branch.description", new Object[0]));
        }

        @Override
        protected String getDialogTitle() {
            return SvnBundle.message("undo.integrate.to.branch.dialog.title", new Object[0]);
        }
    }

    private class MarkAsNotMerged
    extends AbstractIntegrateChangesAction<SelectedChangeListsChecker> {
        private final String myText;
        private final String myDescription;

        private MarkAsNotMerged() {
            super(false);
            this.myText = SvnBundle.message("action.mark.list.as.not.merged.title", new Object[0]);
            this.myDescription = SvnBundle.message("action.mark.list.as.not.merged.descrition", new Object[0]);
        }

        @Override
        @NotNull
        protected MergerFactory createMergerFactory(SelectedChangeListsChecker checker) {
            RecordOnlyMergerFactory recordOnlyMergerFactory = new RecordOnlyMergerFactory(checker.getSelectedLists(), true);
            if (recordOnlyMergerFactory == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/history/RootsAndBranches$MarkAsNotMerged.createMergerFactory must not return null");
            }
            return recordOnlyMergerFactory;
        }

        @Override
        @NotNull
        protected SelectedChangeListsChecker createChecker() {
            SelectedChangeListsChecker selectedChangeListsChecker = new SelectedChangeListsChecker();
            if (selectedChangeListsChecker == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/history/RootsAndBranches$MarkAsNotMerged.createChecker must not return null");
            }
            return selectedChangeListsChecker;
        }

        @Override
        protected void updateWithChecker(AnActionEvent e, SelectedCommittedStuffChecker checker) {
            Presentation presentation = e.getPresentation();
            presentation.setIcon(IconLoader.getIcon((String)"/icons/MarkAsNotMerged.png"));
            presentation.setText(this.myText);
            presentation.setDescription(this.myDescription);
            presentation.setEnabled(presentation.isEnabled() && RootsAndBranches.this.mergeEnabled(checker.getSelectedLists(), false));
        }

        @Override
        @Nullable
        protected String getSelectedBranchUrl(SelectedCommittedStuffChecker checker) {
            SvnMergeInfoRootPanelManual data = RootsAndBranches.this.getPanelData(checker.getSelectedLists());
            if (data != null) {
                return data.getBranch().getUrl();
            }
            return null;
        }

        @Override
        @Nullable
        protected String getSelectedBranchLocalPath(SelectedCommittedStuffChecker checker) {
            SvnMergeInfoRootPanelManual data = RootsAndBranches.this.getPanelData(checker.getSelectedLists());
            if (data != null) {
                return data.getLocalBranch();
            }
            return null;
        }

        @Override
        protected String getDialogTitle() {
            return this.myText;
        }
    }

    private class MarkAsMerged
    extends AbstractIntegrateChangesAction<SelectedChangeListsChecker> {
        private final String myText;
        private final String myDescription;

        private MarkAsMerged() {
            super(false);
            this.myText = SvnBundle.message("action.mark.list.as.merged.text", new Object[0]);
            this.myDescription = SvnBundle.message("action.mark.list.as.merged.description", new Object[0]);
        }

        @Override
        @NotNull
        protected MergerFactory createMergerFactory(SelectedChangeListsChecker checker) {
            RecordOnlyMergerFactory recordOnlyMergerFactory = new RecordOnlyMergerFactory(checker.getSelectedLists(), false);
            if (recordOnlyMergerFactory == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/history/RootsAndBranches$MarkAsMerged.createMergerFactory must not return null");
            }
            return recordOnlyMergerFactory;
        }

        @Override
        @NotNull
        protected SelectedChangeListsChecker createChecker() {
            SelectedChangeListsChecker selectedChangeListsChecker = new SelectedChangeListsChecker();
            if (selectedChangeListsChecker == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/history/RootsAndBranches$MarkAsMerged.createChecker must not return null");
            }
            return selectedChangeListsChecker;
        }

        @Override
        protected void updateWithChecker(AnActionEvent e, SelectedCommittedStuffChecker checker) {
            Presentation presentation = e.getPresentation();
            presentation.setIcon(IconLoader.getIcon((String)"/icons/MarkAsMerged.png"));
            presentation.setText(this.myText);
            presentation.setDescription(this.myDescription);
            presentation.setEnabled(presentation.isEnabled() && RootsAndBranches.this.mergeEnabled(checker.getSelectedLists(), true));
        }

        @Override
        @Nullable
        protected String getSelectedBranchUrl(SelectedCommittedStuffChecker checker) {
            SvnMergeInfoRootPanelManual data = RootsAndBranches.this.getPanelData(checker.getSelectedLists());
            if (data != null) {
                return data.getBranch().getUrl();
            }
            return null;
        }

        @Override
        @Nullable
        protected String getSelectedBranchLocalPath(SelectedCommittedStuffChecker checker) {
            SvnMergeInfoRootPanelManual data = RootsAndBranches.this.getPanelData(checker.getSelectedLists());
            if (data != null) {
                return data.getLocalBranch();
            }
            return null;
        }

        @Override
        protected String getDialogTitle() {
            return this.myText;
        }
    }

    private class FilterOutAlien
    extends CommonFilter {
        private FilterOutAlien() {
            super(IconLoader.getIcon((String)"/icons/FilterOthers.png"), SvnBundle.message("tab.repository.merge.panel.filter.others", new Object[0]));
        }
    }

    private class FilterOutNotMerged
    extends CommonFilter {
        private FilterOutNotMerged() {
            super(IconLoader.getIcon((String)"/icons/FilterNotIntegrated.png"), SvnBundle.message("tab.repository.merge.panel.filter.minus", new Object[0]));
        }
    }

    private class FilterOutMerged
    extends CommonFilter {
        private FilterOutMerged() {
            super(IconLoader.getIcon((String)"/icons/FilterIntegrated.png"), SvnBundle.message("tab.repository.merge.panel.filter.plus", new Object[0]));
        }
    }

    private abstract class CommonFilter
    extends ToggleAction {
        private boolean mySelected;
        private final Icon myIcon;

        protected CommonFilter(Icon icon, String text) {
            super(text);
            this.myIcon = icon;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(RootsAndBranches.this.myHighlightingOn);
            presentation.setIcon(this.myIcon);
            presentation.setText(this.getTemplatePresentation().getText());
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySelected;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySelected = state;
            RootsAndBranches.this.myStrategy.notifyListener();
        }
    }

    private class HighlightFrom
    extends ToggleAction {
        private HighlightFrom() {
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setIcon(IconLoader.getIcon((String)"/icons/ShowIntegratedFrom.png"));
            presentation.setText(SvnBundle.message("committed.changes.action.enable.merge.highlighting", new Object[0]));
            presentation.setDescription(SvnBundle.message("committed.changes.action.enable.merge.highlighting.description.text", new Object[0]));
        }

        public boolean isSelected(AnActionEvent e) {
            return RootsAndBranches.this.myHighlightingOn && RootsAndBranches.this.myFromHereDirection;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                RootsAndBranches.this.turnFromHereHighlighting();
            } else {
                RootsAndBranches.this.turnOff();
            }
        }
    }

    private class HighlightTo
    extends ToggleAction {
        private HighlightTo() {
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setIcon(IconLoader.getIcon((String)"/icons/ShowIntegratedTo.png"));
        }

        public boolean isSelected(AnActionEvent e) {
            return RootsAndBranches.this.myHighlightingOn && !RootsAndBranches.this.myFromHereDirection;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                RootsAndBranches.this.turnFromThereHighlighting();
            } else {
                RootsAndBranches.this.turnOff();
            }
        }
    }

    private class MyRefresh
    extends AnAction {
        private MyRefresh() {
            super(SvnBundle.message("committed.changes.action.merge.highlighting.refresh.text", new Object[0]), SvnBundle.message("committed.changes.action.merge.highlighting.refresh.description", new Object[0]), IconLoader.getIcon((String)"/actions/sync.png"));
        }

        public void update(AnActionEvent e) {
            for (MergeInfoHolder holder : RootsAndBranches.this.myHolders.values()) {
                if (!holder.refreshEnabled(false)) continue;
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            RootsAndBranches.this.refresh();
        }
    }
}

