/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.continuation.Continuation;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import org.jetbrains.annotations.Nullable;

public abstract class RunOrContinuation<T> {
    protected final Project myProject;
    private final String myTaskTitle;
    private boolean myWasCanceled;

    protected RunOrContinuation(Project project, String taskTitle) {
        this.myProject = project;
        this.myTaskTitle = taskTitle;
    }

    @Nullable
    protected abstract T calculate();

    @Nullable
    protected abstract T calculateLong();

    protected abstract void processResult(T var1);

    protected void cancel() {
        this.myWasCanceled = true;
    }

    public TaskDescriptor getTask() {
        final Ref refT = new Ref();
        final TaskDescriptor pooled = new TaskDescriptor(this.myTaskTitle, Where.POOLED){

            public void run(ContinuationContext context) {
                refT.set(RunOrContinuation.this.calculateLong());
                if (!RunOrContinuation.this.myWasCanceled) {
                    context.next(new TaskDescriptor[]{new TaskDescriptor("final part", Where.AWT){

                        public void run(ContinuationContext context) {
                            RunOrContinuation.this.processResult(refT.get());
                        }
                    }});
                }
            }
        };
        return new TaskDescriptor("short part", Where.AWT){

            public void run(ContinuationContext context) {
                refT.set(RunOrContinuation.this.calculate());
                if (!RunOrContinuation.this.myWasCanceled && !refT.isNull()) {
                    RunOrContinuation.this.processResult(refT.get());
                    return;
                }
                context.next(new TaskDescriptor[]{pooled});
            }
        };
    }

    public void execute() {
        new Continuation(this.myProject, true).run(new TaskDescriptor[]{this.getTask()});
    }
}

