/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.config;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnServerFileManager;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.config.GroupsValidator;
import org.jetbrains.idea.svn.config.SvnConfigureProxiesComponent;
import org.jetbrains.idea.svn.config.TestConnectionPerformer;
import org.jetbrains.idea.svn.config.ValidationListener;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SvnConfigureProxiesDialog
extends DialogWrapper
implements ValidationListener,
TestConnectionPerformer {
    private final SvnConfigureProxiesComponent mySystemTab;
    private final SvnConfigureProxiesComponent myUserTab;
    private JPanel myPanel;
    private JTabbedPane myTabbedPane;
    private final GroupsValidator myValidator;
    private final Project myProject;
    private boolean valid = true;

    public SvnConfigureProxiesDialog(Project project) {
        super(project, true);
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(SvnBundle.message("dialog.title.edit.http.proxies.settings", objectArray));
        Ref systemManager = new Ref();
        Ref userManager = new Ref();
        SvnConfiguration.getInstance(project).getServerFilesManagers((Ref<SvnServerFileManager>)systemManager, (Ref<SvnServerFileManager>)userManager);
        this.myValidator = new GroupsValidator(this);
        this.mySystemTab = new SvnConfigureProxiesComponent((SvnServerFileManager)systemManager.get(), this.myValidator, this);
        this.myUserTab = new SvnConfigureProxiesComponent((SvnServerFileManager)userManager.get(), this.myValidator, this);
        this.init();
        this.mySystemTab.reset();
        this.myUserTab.reset();
        this.myValidator.run();
    }

    @Override
    public void onError(String text, JComponent component, boolean forbidSave) {
        this.myTabbedPane.setSelectedComponent(component);
        String prefixString = "";
        for (int i = 0; i < this.myTabbedPane.getComponentCount(); ++i) {
            Component currentComponent = this.myTabbedPane.getComponentAt(i);
            if (currentComponent != component) continue;
            prefixString = this.myTabbedPane.getTitleAt(i) + ": ";
        }
        this.setOKActionEnabled(!forbidSave);
        this.setInvalid(prefixString + text);
    }

    @Override
    public void onSuccess() {
        if (this.isVisible()) {
            this.setOKActionEnabled(true);
            this.setInvalid(null);
        }
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    private boolean applyToTab(SvnConfigureProxiesComponent component) {
        try {
            component.apply();
        }
        catch (ConfigurationException e) {
            this.myTabbedPane.setSelectedComponent(component.createComponent());
            this.setInvalid(e.getMessage());
            return false;
        }
        return true;
    }

    public void doCancelAction() {
        this.myValidator.stop();
        super.doCancelAction();
    }

    private boolean applyImpl() {
        if (!this.applyToTab(this.myUserTab)) {
            return false;
        }
        return this.applyToTab(this.mySystemTab);
    }

    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            if (!this.applyImpl()) {
                return;
            }
            this.myValidator.stop();
            this.close(0);
        }
    }

    @Override
    public void execute(final String url) {
        Messages.showInfoMessage((Project)this.myProject, (String)SvnBundle.message("dialog.edit.http.proxies.settings.test.connection.settings.will.be.stored.text", new Object[0]), (String)SvnBundle.message("dialog.edit.http.proxies.settings.test.connection.settings.will.be.stored.title", new Object[0]));
        if (!this.applyImpl()) {
            return;
        }
        final Ref excRef = new Ref();
        final ProgressManager pm = ProgressManager.getInstance();
        pm.runProcessWithProgressSynchronously(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressIndicator pi = pm.getProgressIndicator();
                if (pi != null) {
                    pi.setText("Connecting to " + url);
                }
                SVNRepository repository = null;
                try {
                    repository = SvnVcs.getInstance(SvnConfigureProxiesDialog.this.myProject).createRepository(url);
                    repository.testConnection();
                }
                catch (SVNException exc) {
                    excRef.set((Object)exc);
                }
                finally {
                    if (repository != null) {
                        repository.closeSession();
                    }
                }
            }
        }, "Test connection", true, this.myProject);
        if (!excRef.isNull()) {
            Messages.showErrorDialog((Project)this.myProject, (String)((SVNException)((Object)excRef.get())).getMessage(), (String)SvnBundle.message("dialog.edit.http.proxies.settings.test.connection.error.title", new Object[0]));
        } else {
            Messages.showInfoMessage((Project)this.myProject, (String)SvnBundle.message("dialog.edit.http.proxies.settings.test.connection.succes.text", new Object[0]), (String)SvnBundle.message("dialog.edit.http.proxies.settings.test.connection.succes.title", new Object[0]));
        }
    }

    public void setInvalid(String text) {
        this.valid = text == null || "".equals(text.trim());
        this.setErrorText(text);
    }

    @Override
    public boolean enabled() {
        return this.valid;
    }

    protected JComponent createCenterPanel() {
        this.myTabbedPane = new JTabbedPane();
        this.myTabbedPane.add((Component)this.myUserTab.createComponent(), SvnBundle.message("dialog.edit.http.proxies.settings.tab.edit.user.file.title", new Object[0]));
        this.myTabbedPane.add((Component)this.mySystemTab.createComponent(), SvnBundle.message("dialog.edit.http.proxies.settings.tab.edit.system.file.title", new Object[0]));
        this.myPanel.add((Component)this.myTabbedPane, "North");
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setMinimumSize(new Dimension(820, 630));
        jPanel.setAlignmentX(0.5f);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

