/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ui.ChangesViewBalloonProblemNotifier;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnCheckinEnvironment
implements CheckinEnvironment {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.checkin.SvnCheckinEnvironment");
    private final SvnVcs mySvnVcs;

    public SvnCheckinEnvironment(SvnVcs svnVcs) {
        this.mySvnVcs = svnVcs;
    }

    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel panel) {
        return new KeepLocksComponent((Refreshable)panel);
    }

    @Nullable
    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        return null;
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    private List<VcsException> commitInt(List<File> paths, final String comment, final boolean force, final boolean recursive) {
        final ArrayList<VcsException> exception = new ArrayList<VcsException>();
        final Collection<File> committables = this.getCommitables(paths);
        final SVNCommitClient committer = this.mySvnVcs.createCommitClient();
        final ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        final ArrayList deletedFiles = new ArrayList();
        if (progress != null) {
            committer.setEventHandler(new ISVNEventHandler(){

                public void handleEvent(SVNEvent event, double p) {
                    String path = SvnUtil.getPathForProgress(event);
                    if (path == null) {
                        return;
                    }
                    if (event.getAction() == SVNEventAction.COMMIT_ADDED) {
                        progress.setText2(SvnBundle.message("progress.text2.adding", path));
                    } else if (event.getAction() == SVNEventAction.COMMIT_DELETED) {
                        final String filePath = "file://" + event.getFile().getAbsolutePath().replace(File.separatorChar, '/');
                        VirtualFile vf = (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

                            @Nullable
                            public VirtualFile compute() {
                                return VirtualFileManager.getInstance().findFileByUrl(filePath);
                            }
                        });
                        if (vf != null) {
                            deletedFiles.add(vf);
                        }
                        progress.setText2(SvnBundle.message("progress.text2.deleting", path));
                    } else if (event.getAction() == SVNEventAction.COMMIT_MODIFIED) {
                        progress.setText2(SvnBundle.message("progress.text2.sending", path));
                    } else if (event.getAction() == SVNEventAction.COMMIT_REPLACED) {
                        progress.setText2(SvnBundle.message("progress.text2.replacing", path));
                    } else if (event.getAction() == SVNEventAction.COMMIT_DELTA_SENT) {
                        progress.setText2(SvnBundle.message("progress.text2.transmitting.delta", path));
                    }
                }

                public void checkCancelled() throws SVNCancelException {
                    try {
                        progress.checkCanceled();
                    }
                    catch (ProcessCanceledException ex) {
                        throw new SVNCancelException();
                    }
                }
            });
        }
        if (progress != null) {
            this.doCommit(committables, progress, committer, comment, force, recursive, exception);
        } else if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    ProgressIndicator p = ProgressManager.getInstance().getProgressIndicator();
                    SvnCheckinEnvironment.this.doCommit(committables, p, committer, comment, force, recursive, exception);
                }
            }, SvnBundle.message("progress.title.commit", new Object[0]), false, this.mySvnVcs.getProject());
        } else {
            this.doCommit(committables, progress, committer, comment, force, recursive, exception);
        }
        for (VirtualFile f : deletedFiles) {
            f.putUserData(VirtualFile.REQUESTOR_MARKER, (Object)this);
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommit(Collection<File> committables, ProgressIndicator progress, SVNCommitClient committer, String comment, boolean force, boolean recursive, List<VcsException> exception) {
        SVNCommitInfo[] results;
        if (committables.isEmpty()) {
            return;
        }
        File[] pathsToCommit = committables.toArray(new File[committables.size()]);
        boolean keepLocks = SvnConfiguration.getInstanceChecked(this.mySvnVcs.getProject()).isKeepLocks();
        SVNCommitPacket[] commitPackets = null;
        try {
            commitPackets = committer.doCollectCommitItems(pathsToCommit, keepLocks, force, recursive, true);
            results = committer.doCommit(commitPackets, keepLocks, comment);
            commitPackets = null;
        }
        catch (SVNException e) {
            exception.add(new VcsException((Throwable)e));
            LOG.info((Throwable)e);
            return;
        }
        finally {
            if (commitPackets != null) {
                for (int i = 0; i < commitPackets.length; ++i) {
                    SVNCommitPacket commitPacket = commitPackets[i];
                    try {
                        commitPacket.dispose();
                        continue;
                    }
                    catch (SVNException e) {}
                }
            }
        }
        final StringBuffer committedRevisions = new StringBuffer();
        for (SVNCommitInfo result : results) {
            if (result.getErrorMessage() != null) {
                exception.add(new VcsException(result.getErrorMessage().getFullMessage()));
                continue;
            }
            if (result == SVNCommitInfo.NULL || result.getNewRevision() <= 0L) continue;
            if (committedRevisions.length() > 0) {
                committedRevisions.append(", ");
            }
            committedRevisions.append(result.getNewRevision());
        }
        if (committedRevisions.length() > 0) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    new ChangesViewBalloonProblemNotifier(SvnCheckinEnvironment.this.mySvnVcs.getProject(), SvnBundle.message("status.text.comitted.revision", committedRevisions), MessageType.INFO).run();
                }
            });
        }
    }

    private Collection<File> getCommitables(List<File> paths) {
        Adder adder = new Adder();
        SVNStatusClient statusClient = this.mySvnVcs.createStatusClient();
        for (File path : paths) {
            File file = path.getAbsoluteFile();
            adder.add(file);
            if (file.getParentFile() == null) continue;
            SvnCheckinEnvironment.addParents(statusClient, file.getParentFile(), adder);
        }
        return adder.getResult();
    }

    private static void addParents(SVNStatusClient statusClient, File file, Adder adder) {
        SVNStatus status;
        try {
            status = statusClient.doStatus(file, false);
        }
        catch (SVNException e) {
            return;
        }
        if (status != null && (status.getContentsStatus() == SVNStatusType.STATUS_ADDED || status.getContentsStatus() == SVNStatusType.STATUS_REPLACED)) {
            adder.add(file);
            file = file.getParentFile();
            if (file != null) {
                SvnCheckinEnvironment.addParents(statusClient, file, adder);
            }
        }
    }

    private static List<File> collectPaths(List<Change> changes) {
        ArrayList<File> result = new ArrayList<File>();
        HashSet<String> pathesSet = new HashSet<String>();
        for (Change change : changes) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null) {
                pathesSet.add(beforeRevision.getFile().getIOFile().getAbsolutePath());
            }
            if (afterRevision == null) continue;
            pathesSet.add(afterRevision.getFile().getIOFile().getAbsolutePath());
        }
        for (String s : pathesSet) {
            result.add(new File(s));
        }
        return result;
    }

    public String getCheckinOperationName() {
        return SvnBundle.message("checkin.operation.name", new Object[0]);
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment) {
        return this.commitInt(SvnCheckinEnvironment.collectPaths(changes), preparedComment, true, false);
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment, Object parameters) {
        return this.commit(changes, preparedComment);
    }

    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> filePaths) {
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        SVNWCClient wcClient = this.mySvnVcs.createWCClient();
        List files = ChangesUtil.filePathsToFiles(filePaths);
        for (File file : files) {
            try {
                wcClient.doDelete(file, true, false);
            }
            catch (SVNException e) {
                exceptions.add(new VcsException((Throwable)e));
            }
        }
        return exceptions;
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        ArrayList<VcsException> result = new ArrayList<VcsException>();
        SVNWCClient wcClient = this.mySvnVcs.createWCClient();
        List<SVNException> exceptionList = SvnCheckinEnvironment.scheduleUnversionedFilesForAddition(wcClient, files);
        for (SVNException svnException : exceptionList) {
            result.add(new VcsException((Throwable)svnException));
        }
        return result;
    }

    public static List<SVNException> scheduleUnversionedFilesForAddition(SVNWCClient wcClient, List<VirtualFile> files) {
        return SvnCheckinEnvironment.scheduleUnversionedFilesForAddition(wcClient, files, false);
    }

    public static List<SVNException> scheduleUnversionedFilesForAddition(SVNWCClient wcClient, List<VirtualFile> files, boolean recursive) {
        ArrayList<SVNException> exceptions = new ArrayList<SVNException>();
        Collections.sort(files, FilePathComparator.getInstance());
        for (VirtualFile file : files) {
            try {
                wcClient.doAdd(new File(FileUtil.toSystemDependentName((String)file.getPath())), true, false, true, recursive);
            }
            catch (SVNException e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return false;
    }

    private class KeepLocksComponent
    implements RefreshableOnComponent {
        private final JCheckBox myKeepLocksBox;
        private boolean myIsKeepLocks;
        private final JPanel myPanel = new JPanel(new BorderLayout());

        public KeepLocksComponent(Refreshable panel) {
            this.myKeepLocksBox = new JCheckBox(SvnBundle.message("checkbox.chckin.keep.files.locked", new Object[0]));
            this.myKeepLocksBox.setSelected(this.myIsKeepLocks);
            this.myPanel.add((Component)this.myKeepLocksBox, "Center");
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public boolean isKeepLocks() {
            return this.myKeepLocksBox != null && this.myKeepLocksBox.isSelected();
        }

        public void refresh() {
        }

        public void saveState() {
            SvnCheckinEnvironment.this.mySvnVcs.getSvnConfiguration().setKeepLocks(this.isKeepLocks());
        }

        public void restoreState() {
            this.myIsKeepLocks = SvnCheckinEnvironment.this.mySvnVcs.getSvnConfiguration().isKeepLocks();
        }
    }

    private static class Adder {
        private final Collection<File> myResult = new ArrayList<File>();
        private final Set<String> myDuplicatesControlSet = new HashSet<String>();

        private Adder() {
        }

        public void add(File file) {
            String path = file.getAbsolutePath();
            if (!this.myDuplicatesControlSet.contains(path)) {
                this.myResult.add(file);
                this.myDuplicatesControlSet.add(path);
            }
        }

        public Collection<File> getResult() {
            return this.myResult;
        }
    }
}

