/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.impl.ExcludedFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;

public class SvnExcludingIgnoredOperation {
    private final Operation myImportAction;
    private final SVNDepth myDepth;
    private final Filter myFilter;

    public SvnExcludingIgnoredOperation(Project project, Operation importAction, SVNDepth depth) {
        this.myImportAction = importAction;
        this.myDepth = depth;
        this.myFilter = new Filter(project);
    }

    private boolean operation(VirtualFile file) throws SVNException {
        if (!this.myFilter.accept(file)) {
            return false;
        }
        this.myImportAction.doOperation(file);
        return true;
    }

    private void executeDown(VirtualFile file) throws SVNException {
        if (!this.operation(file)) {
            return;
        }
        for (VirtualFile child : file.getChildren()) {
            this.executeDown(child);
        }
    }

    public void execute(VirtualFile file) throws SVNException {
        if (SVNDepth.INFINITY.equals((Object)this.myDepth)) {
            this.executeDown(file);
            return;
        }
        if (!this.operation(file)) {
            return;
        }
        if (SVNDepth.EMPTY.equals((Object)this.myDepth)) {
            return;
        }
        for (VirtualFile child : file.getChildren()) {
            if (SVNDepth.FILES.equals((Object)this.myDepth) && child.isDirectory()) continue;
            this.operation(child);
        }
    }

    public static interface Operation {
        public void doOperation(VirtualFile var1) throws SVNException;
    }

    public static class Filter {
        private final Project myProject;
        private final ExcludedFileIndex myIndex;
        private final ChangeListManager myClManager;

        public Filter(Project project) {
            this.myProject = project;
            if (!project.isDefault()) {
                this.myIndex = ExcludedFileIndex.getInstance((Project)project);
                this.myClManager = ChangeListManager.getInstance((Project)project);
            } else {
                this.myIndex = null;
                this.myClManager = null;
            }
        }

        public boolean accept(VirtualFile file) {
            if (!this.myProject.isDefault()) {
                if (this.myIndex.isExcludedFile(file)) {
                    return false;
                }
                if (this.myClManager.isIgnoredFile(file)) {
                    return false;
                }
            }
            return true;
        }
    }
}

