/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import java.io.File;
import javax.swing.JComponent;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.dialogs.PropertiesComponent;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class ShowPropertiesAction
extends BasicAction {
    @Override
    protected String getActionName(AbstractVcs vcs) {
        return "Show Properties";
    }

    @Override
    protected boolean needsAllFiles() {
        return false;
    }

    @Override
    protected boolean isEnabled(Project project, SvnVcs vcs, VirtualFile file) {
        if (!file.isDirectory()) {
            file = file.getParent();
        }
        return file != null && file.getPath() != null && SVNWCUtil.isVersionedDirectory((File)new File(file.getPath()));
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    @Override
    protected void perform(Project project, SvnVcs activeVcs, VirtualFile file, DataContext context) throws VcsException {
        this.batchPerform(project, activeVcs, new VirtualFile[]{file}, context);
    }

    @Override
    protected void batchPerform(Project project, final SvnVcs activeVcs, VirtualFile[] file, DataContext context) throws VcsException {
        final File[] ioFiles = new File[file.length];
        for (int i = 0; i < ioFiles.length; ++i) {
            ioFiles[i] = new File(file[i].getPath());
        }
        if (ioFiles.length > 0) {
            ToolWindow w = ToolWindowManager.getInstance((Project)project).getToolWindow("SVN Properties");
            PropertiesComponent component = null;
            if (w == null) {
                component = new PropertiesComponent();
                w = ToolWindowManager.getInstance((Project)project).registerToolWindow("SVN Properties", (JComponent)component, ToolWindowAnchor.BOTTOM);
            } else {
                component = (PropertiesComponent)w.getContentManager().getContents()[0].getComponent();
            }
            w.setTitle(ioFiles[0].getName());
            w.show(null);
            final PropertiesComponent comp = component;
            w.activate(new Runnable(){

                @Override
                public void run() {
                    comp.setFile(activeVcs, ioFiles[0]);
                }
            });
        }
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }
}

