/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;

public class LockAction
extends BasicAction {
    @Override
    protected String getActionName(AbstractVcs vcs) {
        return SvnBundle.message("action.Subversion.Lock.description", new Object[0]);
    }

    @Override
    protected boolean needsAllFiles() {
        return true;
    }

    @Override
    protected boolean isEnabled(Project project, SvnVcs vcs, VirtualFile file) {
        if (file == null || file.isDirectory()) {
            return false;
        }
        return SvnStatusUtil.isUnderControl(project, file) && !SvnStatusUtil.isAdded(project, file) && !SvnStatusUtil.isExplicitlyLocked(project, file);
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    @Override
    protected void perform(Project project, SvnVcs activeVcs, VirtualFile file, DataContext context) throws VcsException {
        this.batchPerform(project, activeVcs, new VirtualFile[]{file}, context);
    }

    @Override
    protected void batchPerform(Project project, SvnVcs activeVcs, VirtualFile[] files, DataContext context) throws VcsException {
        File[] ioFiles = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            VirtualFile virtualFile = files[i];
            ioFiles[i] = new File(virtualFile.getPath());
        }
        SvnUtil.doLockFiles(project, activeVcs, ioFiles);
    }

    @Override
    protected boolean isBatchAction() {
        return true;
    }
}

