/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.PrimeFinder;

public abstract class THash
implements Cloneable {
    protected transient int _size;
    protected transient int _free;
    protected static final float DEFAULT_LOAD_FACTOR = 0.8f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 4;
    protected float _loadFactor;
    protected int _maxSize;

    public THash() {
        this(4, 0.8f);
    }

    public THash(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public THash(int initialCapacity, float loadFactor) {
        this._loadFactor = loadFactor;
        this.setUp((int)((float)initialCapacity / loadFactor) + 1);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public boolean isEmpty() {
        return 0 == this._size;
    }

    public int size() {
        return this._size;
    }

    protected abstract int capacity();

    public void ensureCapacity(int desiredCapacity) {
        if (desiredCapacity > this._maxSize - this.size()) {
            this.rehash(PrimeFinder.nextPrime((int)((float)desiredCapacity + (float)this.size() / this._loadFactor) + 2));
            this.computeMaxSize(this.capacity());
        }
    }

    public void compact() {
        this.rehash(PrimeFinder.nextPrime((int)((float)this.size() / this._loadFactor) + 2));
        this.computeMaxSize(this.capacity());
    }

    public final void trimToSize() {
        this.compact();
    }

    protected void removeAt(int index) {
        --this._size;
    }

    public void clear() {
        this._size = 0;
        this._free = this.capacity();
    }

    protected int setUp(int initialCapacity) {
        int capacity = PrimeFinder.nextPrime(initialCapacity);
        this.computeMaxSize(capacity);
        return capacity;
    }

    protected abstract void rehash(int var1);

    private final void computeMaxSize(int capacity) {
        this._maxSize = Math.min(capacity - 1, (int)((float)capacity * this._loadFactor));
        this._free = capacity - this._size;
    }

    protected final void postInsertHook(boolean usedFreeSlot) {
        if (usedFreeSlot) {
            --this._free;
        }
        if (++this._size > this._maxSize || this._free == 0) {
            this.rehash(PrimeFinder.nextPrime(this.calculateGrownCapacity()));
            this.computeMaxSize(this.capacity());
        }
    }

    protected int calculateGrownCapacity() {
        return this.capacity() << 1;
    }
}

