/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.RunJavaConfiguration;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit2.configuration.CommonJavaParameters;
import com.intellij.execution.junit2.configuration.ConfigurationModuleSelector;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.ui.AlternativeJREPanel;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ListTableModel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.browser.GroupBrowser;
import com.theoryinpractice.testng.configuration.browser.MethodBrowser;
import com.theoryinpractice.testng.configuration.browser.PackageBrowser;
import com.theoryinpractice.testng.configuration.browser.SuiteBrowser;
import com.theoryinpractice.testng.configuration.browser.TestClassBrowser;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestListenerFilter;
import com.theoryinpractice.testng.model.TestNGConfigurationModel;
import com.theoryinpractice.testng.model.TestNGListenersTableModel;
import com.theoryinpractice.testng.model.TestNGParametersTableModel;
import com.theoryinpractice.testng.model.TestType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testng.TestNG;

public class TestNGConfigurationEditor
extends SettingsEditor<TestNGConfiguration> {
    private final Project project;
    private JPanel panel;
    private LabeledComponent<TextFieldWithBrowseButton> classField;
    private EnvironmentVariablesComponent envVariablesComponent;
    private LabeledComponent<JComboBox> moduleClasspath;
    private AlternativeJREPanel alternateJDK;
    private final ConfigurationModuleSelector moduleSelector;
    private JRadioButton suiteTest;
    private JRadioButton packageTest;
    private JRadioButton classTest;
    private JRadioButton methodTest;
    private JRadioButton groupTest;
    private final TestNGConfigurationModel model;
    private LabeledComponent<TextFieldWithBrowseButton> methodField;
    private LabeledComponent<TextFieldWithBrowseButton> packageField;
    private LabeledComponent<TextFieldWithBrowseButton> groupField;
    private LabeledComponent<TextFieldWithBrowseButton> suiteField;
    private JRadioButton packagesInProject;
    private JRadioButton packagesInModule;
    private JRadioButton packagesAcrossModules;
    private JPanel packagePanel;
    private TestNGParametersTableModel propertiesTableModel;
    private LabeledComponent<TextFieldWithBrowseButton> propertiesFile;
    private LabeledComponent<TextFieldWithBrowseButton> outputDirectory;
    private JButton myAddButton;
    private JButton myRemoveButton;
    private TableView propertiesTableView;
    private JPanel commonParametersPanel;
    private JButton addListener;
    private JList listenersTable;
    private JButton removeListener;
    private LabeledComponent<JComboBox> annotationType;
    private JCheckBox myUseDefaultReportersCheckBox;
    private final CommonJavaParameters commonJavaParameters;
    private ArrayList<Map.Entry> propertiesList;
    private TestNGListenersTableModel listenerModel;
    private TestNGConfiguration config;

    public TestNGConfigurationEditor(Project project) {
        this.$$$setupUI$$$();
        this.commonJavaParameters = new CommonJavaParameters();
        this.project = project;
        BrowseModuleValueActionListener[] browseListeners = new BrowseModuleValueActionListener[]{new PackageBrowser(project), new TestClassBrowser(project, this), new MethodBrowser(project, this), new GroupBrowser(project, this), new SuiteBrowser(project)};
        this.model = new TestNGConfigurationModel(project);
        this.model.setListener(this);
        this.createView();
        this.moduleSelector = new ConfigurationModuleSelector(project, this.getModulesComponent());
        TestNGConfigurationEditor.registerListener(new JRadioButton[]{this.packageTest, this.classTest, this.methodTest, this.groupTest, this.suiteTest}, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ButtonModel buttonModel = (ButtonModel)e.getSource();
                if (buttonModel.isSelected()) {
                    if (buttonModel == TestNGConfigurationEditor.this.packageTest.getModel()) {
                        TestNGConfigurationEditor.this.model.setType(TestType.PACKAGE);
                    } else if (buttonModel == TestNGConfigurationEditor.this.classTest.getModel()) {
                        TestNGConfigurationEditor.this.model.setType(TestType.CLASS);
                    } else if (buttonModel == TestNGConfigurationEditor.this.methodTest.getModel()) {
                        TestNGConfigurationEditor.this.model.setType(TestType.METHOD);
                    } else if (buttonModel == TestNGConfigurationEditor.this.groupTest.getModel()) {
                        TestNGConfigurationEditor.this.model.setType(TestType.GROUP);
                    } else if (buttonModel == TestNGConfigurationEditor.this.suiteTest.getModel()) {
                        TestNGConfigurationEditor.this.model.setType(TestType.SUITE);
                    }
                    TestNGConfigurationEditor.this.redisplay();
                }
            }
        });
        TestNGConfigurationEditor.registerListener(new JRadioButton[]{this.packagesInProject, this.packagesInModule, this.packagesAcrossModules}, null);
        this.packagesInProject.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TestNGConfigurationEditor.this.evaluateModuleClassPath();
            }
        });
        LabeledComponent[] components = new LabeledComponent[]{this.packageField, this.classField, this.methodField, this.groupField, this.suiteField};
        for (int i = 0; i < components.length; ++i) {
            TextFieldWithBrowseButton field = (TextFieldWithBrowseButton)components[i].getComponent();
            Document document = this.model.getDocument(i);
            field.getTextField().setDocument(document);
            browseListeners[i].setField(field);
        }
        this.model.setType(TestType.CLASS);
        this.addListener.addActionListener(new AddTestListenerListener());
        this.removeListener.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int idx = TestNGConfigurationEditor.this.listenersTable.getSelectedIndex() - 1;
                for (int row : TestNGConfigurationEditor.this.listenersTable.getSelectedIndices()) {
                    TestNGConfigurationEditor.this.listenerModel.removeListener(row);
                }
                if (idx > -1) {
                    TestNGConfigurationEditor.this.listenersTable.setSelectedIndex(idx);
                }
            }
        });
        ((TextFieldWithBrowseButton)this.propertiesFile.getComponent()).getTextField().setDocument(this.model.getPropertiesFileDocument());
        ((TextFieldWithBrowseButton)this.outputDirectory.getComponent()).getTextField().setDocument(this.model.getOutputDirectoryDocument());
    }

    private void evaluateModuleClassPath() {
        this.moduleClasspath.setEnabled(!this.packagesInProject.isSelected());
    }

    private void redisplay() {
        if (this.packageTest.isSelected()) {
            this.packagePanel.setVisible(true);
            this.classField.setVisible(false);
            this.methodField.setVisible(false);
            this.groupField.setVisible(false);
            this.suiteField.setVisible(false);
        } else if (this.classTest.isSelected()) {
            this.packagePanel.setVisible(false);
            this.classField.setVisible(true);
            this.methodField.setVisible(false);
            this.groupField.setVisible(false);
            this.suiteField.setVisible(false);
        } else if (this.methodTest.isSelected()) {
            this.packagePanel.setVisible(false);
            this.classField.setVisible(true);
            this.methodField.setVisible(true);
            this.groupField.setVisible(false);
            this.suiteField.setVisible(false);
        } else if (this.groupTest.isSelected()) {
            this.packagePanel.setVisible(false);
            this.classField.setVisible(false);
            this.methodField.setVisible(false);
            this.groupField.setVisible(true);
            this.suiteField.setVisible(false);
        } else if (this.suiteTest.isSelected()) {
            this.packagePanel.setVisible(false);
            this.classField.setVisible(false);
            this.methodField.setVisible(false);
            this.groupField.setVisible(false);
            this.suiteField.setVisible(true);
        }
    }

    public String getClassName() {
        return ((TextFieldWithBrowseButton)this.classField.getComponent()).getText();
    }

    public JComboBox getModulesComponent() {
        return (JComboBox)this.moduleClasspath.getComponent();
    }

    protected void resetEditorFrom(TestNGConfiguration config) {
        this.config = config;
        this.model.reset(config);
        this.commonJavaParameters.reset((RunJavaConfiguration)config);
        this.getModuleSelector().reset((ModuleBasedConfiguration)config);
        TestData data = config.getPersistantData();
        TestSearchScope scope = data.getScope();
        if (scope == TestSearchScope.SINGLE_MODULE) {
            this.packagesInModule.setSelected(true);
        } else if (scope == TestSearchScope.MODULE_WITH_DEPENDENCIES) {
            this.packagesAcrossModules.setSelected(true);
        } else {
            this.packagesInProject.setSelected(true);
        }
        this.alternateJDK.init(config.ALTERNATIVE_JRE_PATH, config.ALTERNATIVE_JRE_PATH_ENABLED);
        this.envVariablesComponent.setEnvs(config.getPersistantData().getEnvs());
        this.envVariablesComponent.setPassParentEnvs(config.getPersistantData().PASS_PARENT_ENVS);
        this.propertiesList = new ArrayList();
        this.propertiesList.addAll(data.TEST_PROPERTIES.entrySet());
        this.propertiesTableModel.setParameterList(this.propertiesList);
        this.listenerModel.setListenerList(data.TEST_LISTENERS);
        this.myUseDefaultReportersCheckBox.setSelected(data.USE_DEFAULT_REPORTERS);
        ((JComboBox)this.annotationType.getComponent()).setSelectedItem(data.ANNOTATION_TYPE);
    }

    public void applyEditorTo(TestNGConfiguration config) {
        this.model.apply(this.getModuleSelector().getModule(), config);
        this.getModuleSelector().applyTo((ModuleBasedConfiguration)config);
        TestData data = config.getPersistantData();
        if (this.packageTest.isSelected()) {
            if (this.packagesInProject.isSelected()) {
                data.setScope(TestSearchScope.WHOLE_PROJECT);
            } else if (this.packagesInModule.isSelected()) {
                data.setScope(TestSearchScope.SINGLE_MODULE);
            } else if (this.packagesAcrossModules.isSelected()) {
                data.setScope(TestSearchScope.MODULE_WITH_DEPENDENCIES);
            }
        } else {
            data.setScope(TestSearchScope.MODULE_WITH_DEPENDENCIES);
        }
        this.commonJavaParameters.applyTo((RunJavaConfiguration)config);
        config.ALTERNATIVE_JRE_PATH = this.alternateJDK.getPath();
        config.ALTERNATIVE_JRE_PATH_ENABLED = this.alternateJDK.isPathEnabled();
        data.ANNOTATION_TYPE = (String)((JComboBox)this.annotationType.getComponent()).getSelectedItem();
        data.TEST_PROPERTIES.clear();
        for (Map.Entry entry : this.propertiesList) {
            data.TEST_PROPERTIES.put((String)entry.getKey(), (String)entry.getValue());
        }
        data.TEST_LISTENERS.clear();
        data.TEST_LISTENERS.addAll(this.listenerModel.getListenerList());
        data.USE_DEFAULT_REPORTERS = this.myUseDefaultReportersCheckBox.isSelected();
        data.setEnvs(this.envVariablesComponent.getEnvs());
        data.PASS_PARENT_ENVS = this.envVariablesComponent.isPassParentEnvs();
    }

    public ConfigurationModuleSelector getModuleSelector() {
        return this.moduleSelector;
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/configuration/TestNGConfigurationEditor.createEditor must not return null");
        }
        return jPanel;
    }

    private static void registerListener(JRadioButton[] buttons, ChangeListener changelistener) {
        ButtonGroup buttongroup = new ButtonGroup();
        for (JRadioButton button : buttons) {
            button.getModel().addChangeListener(changelistener);
            buttongroup.add(button);
        }
        if (buttongroup.getSelection() == null) {
            buttongroup.setSelected(buttons[0].getModel(), true);
        }
    }

    private void createView() {
        this.commonParametersPanel.add((Component)this.commonJavaParameters, "Center");
        this.packageTest.setSelected(false);
        this.suiteTest.setSelected(false);
        this.suiteTest.setEnabled(true);
        this.groupTest.setSelected(false);
        this.groupTest.setEnabled(true);
        this.classTest.setSelected(false);
        this.classTest.setEnabled(true);
        this.classField.setComponent((JComponent)new TextFieldWithBrowseButton());
        this.methodField.setComponent((JComponent)new TextFieldWithBrowseButton());
        this.groupField.setComponent((JComponent)new TextFieldWithBrowseButton());
        this.suiteField.setComponent((JComponent)new TextFieldWithBrowseButton());
        this.packageField.setVisible(true);
        this.packageField.setEnabled(true);
        this.packageField.setComponent((JComponent)new TextFieldWithBrowseButton());
        JComboBox<Object> annotationTypeCombo = new JComboBox<Object>(new Object[]{"", TestNG.JDK_ANNOTATION_TYPE, TestNG.JAVADOC_ANNOTATION_TYPE});
        this.annotationType.setComponent(annotationTypeCombo);
        TextFieldWithBrowseButton outputDirectoryButton = new TextFieldWithBrowseButton();
        this.outputDirectory.setComponent((JComponent)outputDirectoryButton);
        outputDirectoryButton.addBrowseFolderListener("TestNG", "Select test output directory", this.project, new FileChooserDescriptor(false, true, false, false, false, false));
        this.moduleClasspath.setEnabled(true);
        this.moduleClasspath.setComponent(new JComboBox());
        this.propertiesTableModel = new TestNGParametersTableModel();
        this.listenerModel = new TestNGListenersTableModel();
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        this.propertiesFile.setComponent((JComponent)textFieldWithBrowseButton);
        FileChooserDescriptor propertiesFileDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile virtualFile, boolean showHidden) {
                if (!showHidden && virtualFile.getName().charAt(0) == '.') {
                    return false;
                }
                return virtualFile.isDirectory() || "properties".equals(virtualFile.getExtension());
            }
        };
        textFieldWithBrowseButton.addBrowseFolderListener("TestNG", "Select .properties file for test properties", this.project, propertiesFileDescriptor);
        this.propertiesTableView.setModel((ListTableModel)this.propertiesTableModel);
        this.propertiesTableView.setShowGrid(true);
        this.listenersTable.setModel(this.listenerModel);
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestNGConfigurationEditor.this.propertiesTableModel.addParameter();
                int index = TestNGConfigurationEditor.this.propertiesTableModel.getRowCount() - 1;
                TestNGConfigurationEditor.this.propertiesTableView.setRowSelectionInterval(index, index);
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = TestNGConfigurationEditor.this.propertiesTableView.getSelectedRow() - 1;
                for (int row : TestNGConfigurationEditor.this.propertiesTableView.getSelectedRows()) {
                    TestNGConfigurationEditor.this.propertiesTableModel.removeProperty(row);
                }
                if (idx > -1) {
                    TestNGConfigurationEditor.this.propertiesTableView.setRowSelectionInterval(idx, idx);
                }
            }
        });
    }

    protected void disposeEditor() {
    }

    public void onTypeChanged(TestType type) {
        if (type != TestType.PACKAGE && type != TestType.SUITE) {
            this.moduleClasspath.setEnabled(true);
        } else {
            this.evaluateModuleClassPath();
        }
        if (type == TestType.PACKAGE) {
            this.packageTest.setSelected(true);
            this.packageField.setEnabled(true);
            this.classField.setEnabled(false);
            this.methodField.setEnabled(false);
            this.groupField.setEnabled(false);
            this.suiteField.setEnabled(false);
        } else if (type == TestType.CLASS) {
            this.classTest.setSelected(true);
            this.packageField.setEnabled(false);
            this.classField.setEnabled(true);
            this.methodField.setEnabled(false);
            this.groupField.setEnabled(false);
            this.suiteField.setEnabled(false);
        } else if (type == TestType.METHOD) {
            this.methodTest.setSelected(true);
            this.packageField.setEnabled(false);
            this.classField.setEnabled(true);
            this.methodField.setEnabled(true);
            this.groupField.setEnabled(false);
            this.suiteField.setEnabled(false);
        } else if (type == TestType.GROUP) {
            this.groupTest.setSelected(true);
            this.groupField.setEnabled(true);
            this.packageField.setEnabled(false);
            this.classField.setEnabled(false);
            this.methodField.setEnabled(false);
            this.suiteField.setEnabled(false);
        } else if (type == TestType.SUITE) {
            this.suiteTest.setSelected(true);
            this.suiteField.setEnabled(true);
            this.packageField.setEnabled(false);
            this.classField.setEnabled(false);
            this.methodField.setEnabled(false);
            this.groupField.setEnabled(false);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox;
        JList jList;
        JButton jButton;
        JButton jButton2;
        TableView tableView;
        JButton jButton3;
        JButton jButton4;
        LabeledComponent labeledComponent;
        JPanel jPanel;
        AlternativeJREPanel alternativeJREPanel;
        LabeledComponent labeledComponent2;
        EnvironmentVariablesComponent environmentVariablesComponent;
        LabeledComponent labeledComponent3;
        LabeledComponent labeledComponent4;
        LabeledComponent labeledComponent5;
        LabeledComponent labeledComponent6;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        LabeledComponent labeledComponent7;
        JPanel jPanel2;
        LabeledComponent labeledComponent8;
        LabeledComponent labeledComponent9;
        JRadioButton jRadioButton6;
        JRadioButton jRadioButton7;
        JRadioButton jRadioButton8;
        JPanel jPanel3;
        this.panel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.groupTest = jRadioButton8 = new JRadioButton();
        jRadioButton8.setText("Group");
        jRadioButton8.setMnemonic('G');
        jRadioButton8.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jRadioButton8, new GridConstraints(0, 2, 1, 1, 9, 0, 3, 0, null, null, null));
        this.classTest = jRadioButton7 = new JRadioButton();
        jRadioButton7.setText("Class");
        jRadioButton7.setMnemonic('L');
        jRadioButton7.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jRadioButton7, new GridConstraints(0, 3, 1, 1, 9, 0, 3, 0, null, null, null));
        this.methodTest = jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("Method");
        jRadioButton6.setMnemonic('M');
        jRadioButton6.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jRadioButton6, new GridConstraints(0, 4, 1, 1, 9, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 2, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 5, 1, 1, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Search for tests:", 0, 0, null, null));
        this.methodField = labeledComponent9 = new LabeledComponent();
        labeledComponent9.setText("M&ethod");
        jPanel4.add((Component)labeledComponent9, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.suiteField = labeledComponent8 = new LabeledComponent();
        labeledComponent8.setText("&Suite");
        jPanel4.add((Component)labeledComponent8, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.packagePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:max(d;4px):noGrow,left:4dlu:noGrow,fill:max(d;4px):grow", "center:d:noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        jPanel4.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.packageField = labeledComponent7 = new LabeledComponent();
        labeledComponent7.setText("Packa&ge");
        jPanel2.add((Component)labeledComponent7, new CellConstraints(1, 1, 5, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.packagesInProject = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("In whole project");
        jRadioButton5.setMnemonic('W');
        jRadioButton5.setDisplayedMnemonicIndex(3);
        jPanel2.add((Component)jRadioButton5, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.packagesInModule = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("In single module");
        jRadioButton4.setMnemonic('S');
        jRadioButton4.setDisplayedMnemonicIndex(3);
        jPanel2.add((Component)jRadioButton4, new CellConstraints(3, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.packagesAcrossModules = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Across module dependencies");
        jRadioButton3.setMnemonic('D');
        jRadioButton3.setDisplayedMnemonicIndex(14);
        jPanel2.add((Component)jRadioButton3, new CellConstraints(5, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.classField = labeledComponent6 = new LabeledComponent();
        labeledComponent6.setText("&Class");
        jPanel4.add((Component)labeledComponent6, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.outputDirectory = labeledComponent5 = new LabeledComponent();
        labeledComponent5.setText("&Output directory");
        jPanel4.add((Component)labeledComponent5, new GridConstraints(6, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.groupField = labeledComponent4 = new LabeledComponent();
        labeledComponent4.setText("&Group");
        jPanel4.add((Component)labeledComponent4, new GridConstraints(3, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.annotationType = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setText("Annotation type");
        jPanel4.add((Component)labeledComponent3, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel3.add((Component)jTabbedPane, new GridConstraints(2, 0, 1, 5, 0, 3, 3, 0, null, new Dimension(200, 200), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new FormLayout("fill:d:grow", "center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:7dlu:noGrow,center:max(d;4px):noGrow"));
        jTabbedPane.addTab("JDK Settings", null, jPanel5, null);
        this.envVariablesComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        jPanel5.add((Component)environmentVariablesComponent, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 2, 0, 0)));
        this.moduleClasspath = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setText("Use classpath and JDK of m&odule");
        jPanel5.add((Component)labeledComponent2, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 2, 0, 0)));
        this.alternateJDK = alternativeJREPanel = new AlternativeJREPanel();
        jPanel5.add((Component)alternativeJREPanel, new CellConstraints(1, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 2, 0, 0)));
        this.commonParametersPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 2, 0, 0)));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new FormLayout("fill:d:grow", "center:d:noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        jTabbedPane.addTab("Parameters", null, jPanel6, null);
        this.propertiesFile = labeledComponent = new LabeledComponent();
        labeledComponent.setText("&Properties file");
        jPanel6.add((Component)labeledComponent, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new FormLayout("fill:d:grow,left:4dlu:noGrow,fill:max(d;4px):noGrow", "center:32px:noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:d:grow"));
        jPanel6.add((Component)jPanel7, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myAddButton = jButton4 = new JButton();
        jButton4.setText("Add");
        jButton4.setMnemonic('A');
        jButton4.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jButton4, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        this.myRemoveButton = jButton3 = new JButton();
        jButton3.setText("Remove");
        jButton3.setMnemonic('R');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jButton3, new CellConstraints(3, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        Spacer spacer = new Spacer();
        jPanel7.add((Component)spacer, new CellConstraints(3, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel7.add((Component)jScrollPane, new CellConstraints(1, 1, 1, 5, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.propertiesTableView = tableView = new TableView();
        jScrollPane.setViewportView((Component)tableView);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new FormLayout("fill:d:grow", "center:20px:noGrow,top:4dlu:noGrow,center:d:noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        jTabbedPane.addTab("Listeners", null, jPanel8, null);
        LabeledComponent labeledComponent10 = new LabeledComponent();
        labeledComponent10.setText("&Listener classes");
        jPanel8.add((Component)labeledComponent10, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new FormLayout("fill:d:grow,left:4dlu:noGrow,fill:max(d;4px):noGrow", "center:d:noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:d:grow"));
        jPanel8.add((Component)jPanel9, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.addListener = jButton2 = new JButton();
        jButton2.setText("Add");
        jButton2.setMnemonic('A');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel9.add((Component)jButton2, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        this.removeListener = jButton = new JButton();
        jButton.setText("Remove");
        jButton.setMnemonic('R');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel9.add((Component)jButton, new CellConstraints(3, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel9.add((Component)jScrollPane2, new CellConstraints(1, 1, 1, 5, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.listenersTable = jList = new JList();
        jScrollPane2.setViewportView(jList);
        Spacer spacer2 = new Spacer();
        jPanel9.add((Component)spacer2, new CellConstraints(3, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.myUseDefaultReportersCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use default reporters");
        jPanel8.add((Component)jCheckBox, new CellConstraints(1, 5, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.packageTest = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("All in package");
        jRadioButton2.setMnemonic('P');
        jRadioButton2.setDisplayedMnemonicIndex(7);
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.suiteTest = jRadioButton = new JRadioButton();
        jRadioButton.setText("Suite");
        jRadioButton.setMnemonic('U');
        jRadioButton.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 9, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton8);
        buttonGroup.add(jRadioButton7);
        buttonGroup.add(jRadioButton6);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private class AddTestListenerListener
    implements ActionListener {
        private final Logger LOGGER = Logger.getInstance((String)"TestNG Runner");

        private AddTestListenerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String className = this.selectListenerClass();
            if (className != null) {
                TestNGConfigurationEditor.this.listenerModel.addListener(className);
                this.LOGGER.info("Adding listener " + className + " to configuration.");
            }
        }

        @Nullable
        protected GlobalSearchScope getSearchScope(Module[] modules) {
            if (modules == null || modules.length == 0) {
                return null;
            }
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)modules[0]);
            for (int i = 1; i < modules.length; ++i) {
                scope.uniteWith(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)modules[i]));
            }
            return scope;
        }

        @Nullable
        protected String selectListenerClass() {
            GlobalSearchScope searchScope = this.getSearchScope(TestNGConfigurationEditor.this.config.getModules());
            if (searchScope == null) {
                Messages.showErrorDialog((Component)TestNGConfigurationEditor.this.panel, (String)"Module is not selected", (String)"Can't Browse Listeners");
                return null;
            }
            TestListenerFilter filter = new TestListenerFilter(searchScope, TestNGConfigurationEditor.this.project);
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)TestNGConfigurationEditor.this.project).createWithInnerClassesScopeChooser("Choose Listener Class", filter.getScope(), (TreeClassChooser.ClassFilter)filter, null);
            chooser.showDialog();
            PsiClass psiclass = chooser.getSelectedClass();
            if (psiclass == null) {
                return null;
            }
            return JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiclass);
        }
    }
}

