/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.make.ManifestBuilder;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.ZipUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PluginBuildConfiguration;
import org.jetbrains.idea.devkit.build.PluginBuildUtil;
import org.jetbrains.idea.devkit.module.PluginModuleType;

public class PrepareToDeployAction
extends AnAction {
    @NonNls
    private static final String ZIP_EXTENSION = ".zip";
    @NonNls
    private static final String JAR_EXTENSION = ".jar";
    @NonNls
    private static final String TEMP_PREFIX = "temp";
    @NonNls
    private static final String MIDDLE_LIB_DIR = "lib";
    private final FileTypeManager myFileTypeManager = FileTypeManager.getInstance();

    public void actionPerformed(AnActionEvent e) {
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (module != null && module.getModuleType() instanceof PluginModuleType) {
            this.doPrepare(Arrays.asList(module), (Project)LangDataKeys.PROJECT.getData(e.getDataContext()));
        }
    }

    public void doPrepare(final List<Module> pluginModules, Project project) {
        final ArrayList errorMessages = new ArrayList();
        final ArrayList successMessages = new ArrayList();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        compilerManager.make(compilerManager.createModulesCompileScope(pluginModules.toArray(new Module[pluginModules.size()]), true), new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (aborted || errors != 0) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (Module aModule : pluginModules) {
                            if (PrepareToDeployAction.this.doPrepare(aModule, errorMessages, successMessages)) continue;
                            return;
                        }
                        if (!errorMessages.isEmpty()) {
                            Messages.showErrorDialog((String)((String)errorMessages.iterator().next()), (String)DevKitBundle.message("error.occured", new Object[0]));
                        } else if (!successMessages.isEmpty()) {
                            StringBuffer messageBuf = new StringBuffer();
                            for (String message : successMessages) {
                                if (messageBuf.length() != 0) {
                                    messageBuf.append('\n');
                                }
                                messageBuf.append(message);
                            }
                            Messages.showInfoMessage((String)messageBuf.toString(), (String)(pluginModules.size() == 1 ? DevKitBundle.message("success.deployment.message", ((Module)pluginModules.get(0)).getName()) : DevKitBundle.message("success.deployment.message.all", new Object[0])));
                        }
                    }
                });
            }
        });
    }

    private boolean doPrepare(final Module module, final List<String> errorMessages, final List<String> successMessages) {
        final String pluginName = module.getName();
        String defaultPath = new File(module.getModuleFilePath()).getParent() + File.separator + pluginName;
        final HashSet<Module> modules = new HashSet<Module>();
        PluginBuildUtil.getDependencies(module, modules);
        modules.add(module);
        final HashSet<Library> libs = new HashSet<Library>();
        for (Module module1 : modules) {
            PluginBuildUtil.getLibraries(module1, libs);
        }
        final boolean isZip = libs.size() != 0;
        String oldPath = defaultPath + (isZip ? JAR_EXTENSION : ZIP_EXTENSION);
        File oldFile = new File(oldPath);
        if (oldFile.exists() && Messages.showYesNoDialog((Project)module.getProject(), (String)DevKitBundle.message("suggest.to.delete", oldPath), (String)DevKitBundle.message("info.message", new Object[0]), (Icon)Messages.getInformationIcon()) == 0) {
            FileUtil.delete((File)oldFile);
        }
        final String dstPath = defaultPath + (isZip ? ZIP_EXTENSION : JAR_EXTENSION);
        final File dstFile = new File(dstPath);
        return PrepareToDeployAction.clearReadOnly(module.getProject(), dstFile) && ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.setText(DevKitBundle.message("prepare.for.deployment.common", new Object[0]));
                    progressIndicator.setIndeterminate(true);
                }
                try {
                    File jarFile = PrepareToDeployAction.this.preparePluginsJar(module, modules);
                    if (isZip) {
                        PrepareToDeployAction.this.processLibraries(jarFile, dstFile, pluginName, libs, progressIndicator);
                    } else {
                        FileUtil.copy((File)jarFile, (File)dstFile);
                    }
                    successMessages.add(DevKitBundle.message("saved.message", isZip ? 1 : 2, pluginName, dstPath));
                }
                catch (IOException e) {
                    errorMessages.add(e.getMessage() + "\n(" + dstPath + ")");
                }
            }
        }, DevKitBundle.message("prepare.for.deployment", pluginName), true, module.getProject());
    }

    private static boolean clearReadOnly(Project project, File dstFile) {
        URL url;
        try {
            url = dstFile.toURL();
        }
        catch (MalformedURLException e) {
            return true;
        }
        VirtualFile vfile = VfsUtil.findFileByURL((URL)url);
        return vfile == null || !ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{vfile}).hasReadonlyFiles();
    }

    private static FileFilter createFilter(final ProgressIndicator progressIndicator, final FileTypeManager fileTypeManager) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (progressIndicator != null) {
                    progressIndicator.setText2("");
                }
                return fileTypeManager == null || !fileTypeManager.isFileIgnored(FileUtil.toSystemIndependentName((String)pathname.getName()));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLibraries(File jarFile, File zipFile, String pluginName, Set<Library> libs, ProgressIndicator progressIndicator) throws IOException {
        if (FileUtil.ensureCanCreateFile((File)zipFile)) {
            ZipOutputStream zos = null;
            try {
                zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
                PrepareToDeployAction.addStructure(pluginName, zos);
                PrepareToDeployAction.addStructure(pluginName + "/" + MIDDLE_LIB_DIR, zos);
                String entryName = pluginName + JAR_EXTENSION;
                ZipUtil.addFileToZip((ZipOutputStream)zos, (File)jarFile, (String)PrepareToDeployAction.getZipPath(pluginName, entryName), new HashSet(), (FileFilter)PrepareToDeployAction.createFilter(progressIndicator, this.myFileTypeManager));
                HashSet<String> usedJarNames = new HashSet<String>();
                usedJarNames.add(entryName);
                HashSet<VirtualFile> jarredVirtualFiles = new HashSet<VirtualFile>();
                for (Library library : libs) {
                    VirtualFile[] files;
                    for (VirtualFile virtualFile : files = library.getFiles(OrderRootType.CLASSES)) {
                        if (!jarredVirtualFiles.add(virtualFile)) continue;
                        if (virtualFile.getFileSystem() instanceof JarFileSystem) {
                            PrepareToDeployAction.addLibraryJar(virtualFile, zipFile, pluginName, zos, usedJarNames, progressIndicator);
                            continue;
                        }
                        this.makeAndAddLibraryJar(virtualFile, zipFile, pluginName, zos, usedJarNames, progressIndicator, library.getName());
                    }
                }
            }
            finally {
                if (zos != null) {
                    zos.close();
                }
            }
        }
    }

    private static String getZipPath(String pluginName, String entryName) {
        return "/" + pluginName + "/" + MIDDLE_LIB_DIR + "/" + entryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAndAddLibraryJar(VirtualFile virtualFile, File zipFile, String pluginName, ZipOutputStream zos, Set<String> usedJarNames, ProgressIndicator progressIndicator, String preferredName) throws IOException {
        File libraryJar = FileUtil.createTempFile((String)TEMP_PREFIX, (String)JAR_EXTENSION);
        libraryJar.deleteOnExit();
        ZipOutputStream jar = null;
        try {
            jar = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(libraryJar)));
            ZipUtil.addFileOrDirRecursively((ZipOutputStream)jar, (File)libraryJar, (File)VfsUtil.virtualToIoFile((VirtualFile)virtualFile), (String)"", (FileFilter)PrepareToDeployAction.createFilter(progressIndicator, this.myFileTypeManager), null);
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
        String jarName = PrepareToDeployAction.getLibraryJarName(virtualFile.getName() + JAR_EXTENSION, usedJarNames, preferredName == null ? null : preferredName + JAR_EXTENSION);
        ZipUtil.addFileOrDirRecursively((ZipOutputStream)zos, (File)zipFile, (File)libraryJar, (String)PrepareToDeployAction.getZipPath(pluginName, jarName), (FileFilter)PrepareToDeployAction.createFilter(progressIndicator, null), null);
    }

    private static String getLibraryJarName(String fileName, Set<String> usedJarNames, String preferredName) {
        String uniqueName;
        if (preferredName != null && !usedJarNames.contains(preferredName)) {
            uniqueName = preferredName;
        } else {
            uniqueName = fileName;
            if (usedJarNames.contains(uniqueName)) {
                int dotPos = uniqueName.lastIndexOf(".");
                String name = dotPos < 0 ? uniqueName : uniqueName.substring(0, dotPos);
                String ext = dotPos < 0 ? "" : uniqueName.substring(dotPos);
                int i = 0;
                while (usedJarNames.contains(uniqueName = name + ++i + ext)) {
                }
            }
        }
        usedJarNames.add(uniqueName);
        return uniqueName;
    }

    private static void addLibraryJar(VirtualFile virtualFile, File zipFile, String pluginName, ZipOutputStream zos, Set<String> usedJarNames, ProgressIndicator progressIndicator) throws IOException {
        File ioFile = VfsUtil.virtualToIoFile((VirtualFile)virtualFile);
        String jarName = PrepareToDeployAction.getLibraryJarName(ioFile.getName(), usedJarNames, null);
        ZipUtil.addFileOrDirRecursively((ZipOutputStream)zos, (File)zipFile, (File)ioFile, (String)PrepareToDeployAction.getZipPath(pluginName, jarName), (FileFilter)PrepareToDeployAction.createFilter(progressIndicator, null), null);
    }

    private static void addStructure(@NonNls String relativePath, ZipOutputStream zos) throws IOException {
        ZipEntry e = new ZipEntry(relativePath + "/");
        e.setMethod(0);
        e.setSize(0L);
        e.setCrc(0L);
        zos.putNextEntry(e);
        zos.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File preparePluginsJar(Module module, HashSet<Module> modules) throws IOException {
        PluginBuildConfiguration pluginModuleBuildProperties = PluginBuildConfiguration.getInstance(module);
        File jarFile = FileUtil.createTempFile((String)TEMP_PREFIX, (String)JAR_EXTENSION);
        jarFile.deleteOnExit();
        Manifest manifest = PrepareToDeployAction.createOrFindManifest(pluginModuleBuildProperties);
        ZipOutputStream jarPlugin = null;
        try {
            jarPlugin = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(jarFile)), manifest);
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            HashSet writtenItemRelativePaths = new HashSet();
            for (Module module1 : modules) {
                VirtualFile compilerOutputPath = CompilerModuleExtension.getInstance((Module)module1).getCompilerOutputPath();
                if (compilerOutputPath == null) continue;
                ZipUtil.addDirToZipRecursively((ZipOutputStream)jarPlugin, (File)jarFile, (File)new File(compilerOutputPath.getPath()), (String)"", (FileFilter)PrepareToDeployAction.createFilter(progressIndicator, this.myFileTypeManager), writtenItemRelativePaths);
            }
            String pluginXmlPath = pluginModuleBuildProperties.getPluginXmlPath();
            String metainf = "/META-INF/plugin.xml";
            ZipUtil.addFileToZip((ZipOutputStream)jarPlugin, (File)new File(pluginXmlPath), (String)"/META-INF/plugin.xml", writtenItemRelativePaths, (FileFilter)PrepareToDeployAction.createFilter(progressIndicator, null));
        }
        finally {
            if (jarPlugin != null) {
                jarPlugin.close();
            }
        }
        return jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest createOrFindManifest(PluginBuildConfiguration pluginModuleBuildProperties) throws IOException {
        Manifest manifest = new Manifest();
        VirtualFile vManifest = pluginModuleBuildProperties.getManifest();
        if (pluginModuleBuildProperties.isUseUserManifest() && vManifest != null) {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(vManifest.getInputStream());
                manifest.read(in);
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        } else {
            Attributes mainAttributes = manifest.getMainAttributes();
            ManifestBuilder.setGlobalAttributes((Attributes)mainAttributes);
        }
        return manifest;
    }

    public void update(AnActionEvent e) {
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        boolean enabled = module != null && module.getModuleType() instanceof PluginModuleType;
        e.getPresentation().setVisible(enabled);
        e.getPresentation().setEnabled(enabled);
        if (enabled) {
            e.getPresentation().setText(DevKitBundle.message("prepare.for.deployment", module.getName()));
        }
    }
}

