/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.images.editor.impl.ImageFileEditorImpl;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class ImageFileEditorProvider
implements FileEditorProvider,
DumbAware {
    @NonNls
    private static final String EDITOR_TYPE_ID = "images";
    private final ImageFileTypeManager typeManager;

    ImageFileEditorProvider(ImageFileTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/images/editor/impl/ImageFileEditorProvider.accept must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/images/editor/impl/ImageFileEditorProvider.accept must not be null");
        }
        return this.typeManager.isImage(file);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/images/editor/impl/ImageFileEditorProvider.createEditor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/images/editor/impl/ImageFileEditorProvider.createEditor must not be null");
        }
        ImageFileEditorImpl imageFileEditorImpl = new ImageFileEditorImpl(project, file);
        if (imageFileEditorImpl == null) {
            throw new IllegalStateException("@NotNull method org/intellij/images/editor/impl/ImageFileEditorProvider.createEditor must not return null");
        }
        return imageFileEditorImpl;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/images/editor/impl/ImageFileEditorProvider.disposeEditor must not be null");
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/images/editor/impl/ImageFileEditorProvider.readState must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/images/editor/impl/ImageFileEditorProvider.readState must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/intellij/images/editor/impl/ImageFileEditorProvider.readState must not be null");
        }
        FileEditorState fileEditorState = new FileEditorState(){

            public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
                return false;
            }
        };
        if (fileEditorState == null) {
            throw new IllegalStateException("@NotNull method org/intellij/images/editor/impl/ImageFileEditorProvider.readState must not return null");
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/images/editor/impl/ImageFileEditorProvider.writeState must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/images/editor/impl/ImageFileEditorProvider.writeState must not be null");
        }
        if (targetElement == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/intellij/images/editor/impl/ImageFileEditorProvider.writeState must not be null");
        }
    }

    @NotNull
    public String getEditorTypeId() {
        if (EDITOR_TYPE_ID == null) {
            throw new IllegalStateException("@NotNull method org/intellij/images/editor/impl/ImageFileEditorProvider.getEditorTypeId must not return null");
        }
        return EDITOR_TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException("@NotNull method org/intellij/images/editor/impl/ImageFileEditorProvider.getPolicy must not return null");
        }
        return fileEditorPolicy;
    }
}

