/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.UriUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URIReferenceProvider;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.actions.ValidateXmlActionHandler;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXParseException;

public class XmlResourceResolver
implements XMLEntityResolver {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.util.XmlResourceResolver");
    private final XmlFile myFile;
    private final Project myProject;
    private final Map<String, String> myExternalResourcesMap = new HashMap<String, String>(1);
    private boolean myStopOnUnDeclaredResource;
    @NonNls
    public static final String HONOUR_ALL_SCHEMA_LOCATIONS_PROPERTY_KEY = "idea.xml.honour.all.schema.locations";
    private final ValidateXmlActionHandler.ErrorReporter myErrorReporter;

    public XmlResourceResolver(XmlFile _xmlFile, Project _project, ValidateXmlActionHandler.ErrorReporter errorReporter) {
        this.myFile = _xmlFile;
        this.myProject = _project;
        this.myErrorReporter = errorReporter;
    }

    public String getPathByPublicId(String baseId) {
        return this.myExternalResourcesMap.get(baseId);
    }

    public String[] getResourcePaths() {
        return this.myExternalResourcesMap.values().toArray(new String[this.myExternalResourcesMap.size()]);
    }

    @Nullable
    public PsiFile resolve(final String baseSystemId, String _systemId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: resolveEntity(baseSystemId='" + baseSystemId + "' systemId='" + _systemId + "," + super.toString() + "')");
        }
        if (_systemId == null) {
            return null;
        }
        if (this.myStopOnUnDeclaredResource && ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(_systemId)) {
            throw new IgnoredResourceException();
        }
        int length = URIReferenceProvider.getPrefixLength(_systemId);
        final String systemId = _systemId.substring(length);
        final PsiFile[] result = new PsiFile[]{null};
        Runnable action = new Runnable(){

            @Override
            public void run() {
                PsiFile psiFile;
                XmlFile baseFile = null;
                VirtualFile vFile = null;
                if (baseSystemId != null) {
                    baseFile = XmlResourceResolver.this.resolve(null, baseSystemId);
                    if (baseFile == null) {
                        if (XmlResourceResolver.this.myFile != null) {
                            File workingFile = new File("");
                            String workingDir = workingFile.getAbsoluteFile().getAbsolutePath().replace(File.separatorChar, '/');
                            String id = StringUtil.replace((String)baseSystemId, (String)workingDir, (String)XmlResourceResolver.this.myFile.getVirtualFile().getParent().getPath());
                            vFile = UriUtil.findRelativeFile((String)id, null);
                        }
                        if (vFile == null && (vFile = UriUtil.findRelativeFile((String)baseSystemId, null)) == null) {
                            try {
                                vFile = VfsUtil.findFileByURL((URL)new URL(baseSystemId));
                            }
                            catch (MalformedURLException ignore) {
                                // empty catch block
                            }
                        }
                    }
                    if (vFile != null && !vFile.isDirectory() && !(vFile.getFileSystem() instanceof HttpFileSystem)) {
                        baseFile = PsiManager.getInstance((Project)XmlResourceResolver.this.myProject).findFile(vFile);
                    }
                }
                if (baseFile == null) {
                    baseFile = XmlResourceResolver.this.myFile;
                }
                String version = null;
                if (baseFile == XmlResourceResolver.this.myFile) {
                    XmlDocument document = XmlResourceResolver.this.myFile.getDocument();
                    XmlTag rootTag = document != null ? document.getRootTag() : null;
                    String string = version = rootTag != null ? rootTag.getAttributeValue("version") : null;
                }
                if ((psiFile = ExternalResourceManager.getInstance().getResourceLocation(systemId, (PsiFile)baseFile, version)) == null) {
                    psiFile = XmlUtil.findXmlFile((PsiFile)baseFile, systemId);
                }
                if (psiFile == null && baseSystemId != null) {
                    String fullUrl = baseSystemId.substring(0, baseSystemId.lastIndexOf(47) + 1) + systemId;
                    psiFile = XmlUtil.findXmlFile((PsiFile)baseFile, fullUrl);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("before relative file checking:" + psiFile + "," + systemId + "," + baseSystemId + ")");
                }
                if (psiFile == null && baseSystemId == null) {
                    File workingFile = new File("");
                    String workingDir = workingFile.getAbsoluteFile().getAbsolutePath().replace(File.separatorChar, '/') + "/";
                    String relativePath = StringUtil.replace((String)systemId, (String)workingDir, (String)"");
                    if (relativePath.equals(systemId)) {
                        relativePath = systemId.substring(systemId.lastIndexOf(47) + 1);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("next to relative file checking:" + relativePath + "," + XmlResourceResolver.this.myExternalResourcesMap.size() + ")");
                    }
                    for (String path : XmlResourceResolver.this.myExternalResourcesMap.values()) {
                        VirtualFile file;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Finding file by url:" + path);
                        }
                        if ((file = VirtualFileManager.getInstance().findFileByUrl(path)) == null) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Finding " + relativePath + " relative to:" + file.getPath());
                        }
                        VirtualFile relativeFile = UriUtil.findRelativeFile((String)relativePath, (VirtualFile)file);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Found " + (relativeFile != null ? relativeFile.getPath() : "null"));
                        }
                        if (relativeFile == null || (psiFile = PsiManager.getInstance((Project)XmlResourceResolver.this.myProject).findFile(relativeFile)) == null) continue;
                        break;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("resolveEntity: psiFile='" + (psiFile != null ? psiFile.getVirtualFile() : null) + "'");
                }
                result[0] = psiFile;
            }
        };
        ApplicationManager.getApplication().runReadAction(action);
        PsiFile psiFile = result[0];
        if (psiFile != null) {
            String url = psiFile.getVirtualFile().getUrl();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding external resource ref:" + systemId + "," + url + "," + super.toString());
            }
            this.myExternalResourcesMap.put(systemId, url);
        }
        return psiFile;
    }

    @Nullable
    public XMLInputSource resolveEntity(XMLResourceIdentifier xmlResourceIdentifier) throws XNIException, IOException {
        String publicId = xmlResourceIdentifier.getLiteralSystemId() != null ? xmlResourceIdentifier.getLiteralSystemId() : xmlResourceIdentifier.getNamespace();
        PsiFile psiFile = this.resolve(xmlResourceIdentifier.getBaseSystemId(), publicId);
        if (psiFile == null && xmlResourceIdentifier.getBaseSystemId() != null) {
            psiFile = ExternalResourceManager.getInstance().getResourceLocation(xmlResourceIdentifier.getBaseSystemId(), (PsiFile)this.myFile, null);
        }
        if (psiFile == null && xmlResourceIdentifier.getLiteralSystemId() != null && xmlResourceIdentifier.getNamespace() != null) {
            publicId = xmlResourceIdentifier.getNamespace();
            psiFile = this.resolve(xmlResourceIdentifier.getBaseSystemId(), publicId);
        }
        if (psiFile == null) {
            if (publicId != null && publicId.indexOf(":/") != -1) {
                this.myErrorReporter.processError(new SAXParseException(XmlBundle.message((String)"xml.validate.external.resource.is.not.registered", (Object[])new Object[]{publicId}), publicId, null, 0, 0), false);
                XMLInputSource source = new XMLInputSource(xmlResourceIdentifier);
                source.setPublicId(publicId);
                source.setCharacterStream((Reader)new StringReader(""));
                return source;
            }
            return null;
        }
        XMLInputSource source = new XMLInputSource(xmlResourceIdentifier);
        if (xmlResourceIdentifier.getLiteralSystemId() == null) {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            String url = VfsUtil.fixIDEAUrl((String)virtualFile.getUrl());
            source.setBaseSystemId(url);
            source.setSystemId(url);
        }
        source.setPublicId(publicId);
        source.setCharacterStream((Reader)new StringReader(psiFile.getText()));
        return source;
    }

    public void setStopOnUnDeclaredResource(boolean stopOnUnDeclaredResource) {
        this.myStopOnUnDeclaredResource = stopOnUnDeclaredResource;
    }

    public static class IgnoredResourceException
    extends RuntimeException {
    }
}

