/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public enum ResourceRelevance {
    NONE,
    STANDARD,
    LIBRARY,
    SOURCE,
    MAPPED;


    public static ResourceRelevance getRelevance(VirtualFile file, @Nullable Module module, ProjectFileIndex fileIndex) {
        ExternalResourceManagerImpl resourceManager;
        Module moduleForFile;
        if (module != null && (moduleForFile = fileIndex.getModuleForFile(file)) != null) {
            return module.equals(moduleForFile) || ModuleManager.getInstance((Project)module.getProject()).isModuleDependent(module, moduleForFile) ? SOURCE : NONE;
        }
        if (fileIndex.isInLibraryClasses(file)) {
            List orderEntries = fileIndex.getOrderEntriesForFile(file);
            if (orderEntries.isEmpty()) {
                return NONE;
            }
            if (module != null) {
                for (OrderEntry orderEntry : orderEntries) {
                    Module ownerModule = orderEntry.getOwnerModule();
                    if (!ownerModule.equals(module)) continue;
                    return LIBRARY;
                }
            }
        }
        if ((resourceManager = (ExternalResourceManagerImpl)ExternalResourceManager.getInstance()).isUserResource(file)) {
            return MAPPED;
        }
        if (ExternalResourceManagerImpl.isStandardResource(file)) {
            return STANDARD;
        }
        return NONE;
    }
}

