/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dom;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.dom.DomAttributeXmlDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementXmlDescriptor
implements XmlElementDescriptor {
    private final DomChildrenDescription myChildrenDescription;
    private final DomManager myManager;
    @NotNull
    private final DomElement mySomeElement;

    public DomElementXmlDescriptor(@NotNull DomElement domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/dom/DomElementXmlDescriptor.<init> must not be null");
        }
        this.myChildrenDescription = new MyRootDomChildrenDescription(domElement);
        this.myManager = domElement.getManager();
        this.mySomeElement = domElement;
    }

    public DomElementXmlDescriptor(@NotNull DomChildrenDescription childrenDescription, @NotNull DomElement someElement) {
        if (childrenDescription == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/dom/DomElementXmlDescriptor.<init> must not be null");
        }
        if (someElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xml/impl/dom/DomElementXmlDescriptor.<init> must not be null");
        }
        this.myChildrenDescription = childrenDescription;
        this.myManager = someElement.getManager();
        this.mySomeElement = someElement;
    }

    public String getQualifiedName() {
        return this.myChildrenDescription.getXmlElementName();
    }

    public String getDefaultName() {
        return this.myChildrenDescription.getXmlElementName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        DomElement domElement = this.myManager.getDomElement(context);
        if (domElement == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<Object> xmlElementDescriptors = new ArrayList<Object>();
        for (DomCollectionChildDescription childrenDescription : domElement.getGenericInfo().getCollectionChildrenDescriptions()) {
            xmlElementDescriptors.add(new DomElementXmlDescriptor((DomChildrenDescription)childrenDescription, domElement));
        }
        for (DomCollectionChildDescription childrenDescription : domElement.getGenericInfo().getFixedChildrenDescriptions()) {
            xmlElementDescriptors.add(new DomElementXmlDescriptor((DomChildrenDescription)childrenDescription, domElement));
        }
        CustomDomChildrenDescription customDescription = domElement.getGenericInfo().getCustomNameChildrenDescription();
        if (customDescription != null) {
            xmlElementDescriptors.add(new AnyXmlElementDescriptor(this, this.getNSDescriptor()));
        }
        return xmlElementDescriptors.toArray(new XmlElementDescriptor[xmlElementDescriptors.size()]);
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag childTag, @Nullable XmlTag contextTag) {
        if (childTag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/dom/DomElementXmlDescriptor.getElementDescriptor must not be null");
        }
        DomElement domElement = this.myManager.getDomElement(childTag);
        if (domElement == null) {
            AbstractDomChildrenDescription description;
            domElement = this.myManager.getDomElement(contextTag);
            if (domElement != null && (description = this.myManager.findChildrenDescription(childTag, domElement)) instanceof DomChildrenDescription) {
                return new DomElementXmlDescriptor((DomChildrenDescription)description, domElement);
            }
            return null;
        }
        DomElement parent = domElement.getParent();
        if (parent == null) {
            return new DomElementXmlDescriptor(domElement);
        }
        AbstractDomChildrenDescription description = domElement.getChildDescription();
        if (description instanceof CustomDomChildrenDescription) {
            return new AnyXmlElementDescriptor(this, this.getNSDescriptor());
        }
        if (!(description instanceof DomChildrenDescription)) {
            return null;
        }
        return new DomElementXmlDescriptor((DomChildrenDescription)description, parent);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        if (context == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        DomElement domElement = this.myManager.getDomElement(context);
        if (domElement == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        List descriptions = domElement.getGenericInfo().getAttributeChildrenDescriptions();
        ArrayList<DomAttributeXmlDescriptor> descriptors = new ArrayList<DomAttributeXmlDescriptor>();
        for (DomAttributeChildDescription description : descriptions) {
            descriptors.add(new DomAttributeXmlDescriptor(description));
        }
        return descriptors.toArray(new XmlAttributeDescriptor[descriptors.size()]);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, @Nullable XmlTag context) {
        DomElement domElement = this.myManager.getDomElement(context);
        if (domElement == null) {
            return null;
        }
        for (DomAttributeChildDescription description : domElement.getGenericInfo().getAttributeChildrenDescriptions()) {
            if (!attributeName.equals(DomAttributeXmlDescriptor.getQualifiedAttributeName((PsiElement)context, description.getXmlName()))) continue;
            return new DomAttributeXmlDescriptor(description);
        }
        return null;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return new XmlNSDescriptor(){

            @Nullable
            public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
                if (tag == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/dom/DomElementXmlDescriptor$1.getElementDescriptor must not be null");
                }
                throw new UnsupportedOperationException("Method getElementDescriptor not implemented in " + this.getClass());
            }

            @NotNull
            public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument document) {
                throw new UnsupportedOperationException("Method getRootElementsDescriptors not implemented in " + this.getClass());
            }

            @Nullable
            public XmlFile getDescriptorFile() {
                return null;
            }

            public boolean isHierarhyEnabled() {
                throw new UnsupportedOperationException("Method isHierarhyEnabled not implemented in " + this.getClass());
            }

            @Nullable
            public PsiElement getDeclaration() {
                throw new UnsupportedOperationException("Method getDeclaration not implemented in " + this.getClass());
            }

            @NonNls
            public String getName(PsiElement context) {
                throw new UnsupportedOperationException("Method getName not implemented in " + this.getClass());
            }

            @NonNls
            public String getName() {
                throw new UnsupportedOperationException("Method getName not implemented in " + this.getClass());
            }

            public void init(PsiElement element) {
                throw new UnsupportedOperationException("Method init not implemented in " + this.getClass());
            }

            public Object[] getDependences() {
                throw new UnsupportedOperationException("Method getDependences not implemented in " + this.getClass());
            }
        };
    }

    public int getContentType() {
        throw new UnsupportedOperationException("Method getContentType not implemented in " + this.getClass());
    }

    @Nullable
    public PsiElement getDeclaration() {
        DomElement declaration = (DomElement)this.myChildrenDescription.getUserData(DomExtension.KEY_DECLARATION);
        if (declaration != null) {
            return declaration.getXmlElement();
        }
        return new FakePsiElement(){

            public PsiElement getParent() {
                return DomUtil.getFile((DomElement)DomElementXmlDescriptor.this.mySomeElement);
            }
        };
    }

    @NonNls
    public String getName(PsiElement context) {
        String name = this.getDefaultName();
        if (context instanceof XmlTag) {
            XmlTag tag = (XmlTag)context;
            PsiFile file = tag.getContainingFile();
            DomElement element = this.myManager.getDomElement(tag);
            if (element == null && tag.getParentTag() != null) {
                element = this.myManager.getDomElement(tag.getParentTag());
            }
            if (element != null && file instanceof XmlFile && !(this.myChildrenDescription instanceof MyRootDomChildrenDescription)) {
                String s;
                String namespace = DomService.getInstance().getEvaluatedXmlName(element).evaluateChildName(this.myChildrenDescription.getXmlName()).getNamespace((XmlElement)tag, (XmlFile)file);
                if (!tag.getNamespaceByPrefix("").equals(namespace) && StringUtil.isNotEmpty((String)(s = tag.getPrefixByNamespace(namespace)))) {
                    return s + ":" + name;
                }
            }
        }
        return name;
    }

    @NonNls
    public String getName() {
        return this.getDefaultName();
    }

    public void init(PsiElement element) {
        throw new UnsupportedOperationException("Method init not implemented in " + this.getClass());
    }

    public Object[] getDependences() {
        throw new UnsupportedOperationException("Method getDependences not implemented in " + this.getClass());
    }

    private static class MyRootDomChildrenDescription
    implements DomChildrenDescription {
        private final DomElement myDomElement;

        public MyRootDomChildrenDescription(DomElement domElement) {
            this.myDomElement = domElement;
        }

        @NotNull
        public XmlName getXmlName() {
            throw new UnsupportedOperationException("Method getXmlName not implemented in " + this.getClass());
        }

        @NotNull
        public String getXmlElementName() {
            String string = this.myDomElement.getXmlElementName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/xml/impl/dom/DomElementXmlDescriptor$MyRootDomChildrenDescription.getXmlElementName must not return null");
            }
            return string;
        }

        @NotNull
        public String getCommonPresentableName(@NotNull DomNameStrategy strategy) {
            if (strategy == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/dom/DomElementXmlDescriptor$MyRootDomChildrenDescription.getCommonPresentableName must not be null");
            }
            throw new UnsupportedOperationException("Method getCommonPresentableName not implemented in " + this.getClass());
        }

        @NotNull
        public String getCommonPresentableName(@NotNull DomElement parent) {
            if (parent == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/dom/DomElementXmlDescriptor$MyRootDomChildrenDescription.getCommonPresentableName must not be null");
            }
            throw new UnsupportedOperationException("Method getCommonPresentableName not implemented in " + this.getClass());
        }

        @NotNull
        public List<? extends DomElement> getValues(@NotNull DomElement parent) {
            if (parent == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/dom/DomElementXmlDescriptor$MyRootDomChildrenDescription.getValues must not be null");
            }
            throw new UnsupportedOperationException("Method getValues not implemented in " + this.getClass());
        }

        @NotNull
        public List<? extends DomElement> getStableValues(@NotNull DomElement parent) {
            if (parent == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/dom/DomElementXmlDescriptor$MyRootDomChildrenDescription.getStableValues must not be null");
            }
            throw new UnsupportedOperationException("Method getStableValues not implemented in " + this.getClass());
        }

        @NotNull
        public Type getType() {
            throw new UnsupportedOperationException("Method getType not implemented in " + this.getClass());
        }

        @NotNull
        public DomNameStrategy getDomNameStrategy(@NotNull DomElement parent) {
            if (parent == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/impl/dom/DomElementXmlDescriptor$MyRootDomChildrenDescription.getDomNameStrategy must not be null");
            }
            throw new UnsupportedOperationException("Method getDomNameStrategy not implemented in " + this.getClass());
        }

        public <T> T getUserData(Key<T> key) {
            return null;
        }

        @Nullable
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            throw new UnsupportedOperationException("Method getAnnotation not implemented in " + this.getClass());
        }
    }
}

