/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerTreePanel
implements DnDSource {
    private final XDebuggerTree myTree;
    private final JPanel myMainPanel;
    private final PopupHandler myPopupHandler;

    public XDebuggerTreePanel(@NotNull XDebugSession session, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSourcePosition sourcePosition, final @NotNull @NonNls String popupActionGroupId) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel.<init> must not be null");
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel.<init> must not be null");
        }
        if (popupActionGroupId == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel.<init> must not be null");
        }
        this.myTree = new XDebuggerTree(session, editorsProvider, sourcePosition);
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)((Object)this.myTree)), "Center");
        final ActionManager actionManager = ActionManager.getInstance();
        this.myPopupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup group = (ActionGroup)actionManager.getAction(popupActionGroupId);
                ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("unknown", group);
                popupMenu.getComponent().show(comp, x, y);
            }
        };
        AnAction setValueAction = actionManager.getAction("XDebugger.SetValue");
        setValueAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)), (JComponent)((Object)this.myTree));
        AnAction jumpToSourceAction = actionManager.getAction("XDebugger.JumpToSource");
        jumpToSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)((Object)this.myTree));
        this.myTree.addMouseListener((MouseListener)this.myPopupHandler);
    }

    public void dispose() {
        ActionManager actionManager = ActionManager.getInstance();
        actionManager.getAction("XDebugger.SetValue").unregisterCustomShortcutSet((JComponent)((Object)this.myTree));
        actionManager.getAction("XDebugger.JumpToSource").unregisterCustomShortcutSet((JComponent)((Object)this.myTree));
        this.myTree.removeMouseListener((MouseListener)this.myPopupHandler);
    }

    public XDebuggerTree getTree() {
        return this.myTree;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public boolean canStartDragging(DnDAction action, Point dragOrigin) {
        return this.getNodesToDrag().length > 0;
    }

    private XValueNodeImpl[] getNodesToDrag() {
        return (XValueNodeImpl[])this.myTree.getSelectedNodes(XValueNodeImpl.class, (Tree.NodeFilter)new Tree.NodeFilter<XValueNodeImpl>(){

            public boolean accept(XValueNodeImpl node) {
                return ((XValue)node.getValueContainer()).getEvaluationExpression() != null;
            }
        });
    }

    public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
        return new DnDDragStartBean((Object)this.getNodesToDrag());
    }

    public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
        XValueNodeImpl[] nodes = this.getNodesToDrag();
        if (nodes.length == 1) {
            return DnDAwareTree.getDragImage((Tree)this.myTree, nodes[0].getPath(), dragOrigin);
        }
        return DnDAwareTree.getDragImage((Tree)this.myTree, XDebuggerBundle.message((String)"xdebugger.drag.text.0.elements", (Object[])new Object[]{nodes.length}), dragOrigin);
    }

    public void dragDropEnd() {
    }

    public void dropActionChanged(int gestureModifiers) {
    }
}

