/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointTypeDialogState;
import com.intellij.xdebugger.impl.breakpoints.ui.AbstractBreakpointPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.AddBreakpointAction;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPanelAction;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointsTree;
import com.intellij.xdebugger.impl.breakpoints.ui.actions.GoToBreakpointAction;
import com.intellij.xdebugger.impl.breakpoints.ui.actions.RemoveBreakpointAction;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NotNull;

public class XBreakpointsPanel<B extends XBreakpoint<?>>
extends AbstractBreakpointPanel<XBreakpoint> {
    private final Project myProject;
    private final DialogWrapper myParentDialog;
    private final XBreakpointType<B, ?> myType;
    private JPanel myMainPanel;
    private JPanel myPropertiesPanelWrapper;
    private JPanel myTreePanel;
    private JPanel myPropertiesPanel;
    private JPanel myButtonsPanel;
    private final XBreakpointsTree<B> myTree;
    private final XBreakpointPanelAction<B>[] myActions;
    private Map<XBreakpointPanelAction<B>, JButton> myButtons;
    private XBreakpointPropertiesPanel<B> mySelectedPropertiesPanel;
    private final Set<XBreakpointGroupingRule<B, ?>> mySelectedGroupingRules;
    private final List<XBreakpointGroupingRule<B, ?>> myAllGroupingRules;

    public XBreakpointsPanel(@NotNull Project project, @NotNull DialogWrapper parentDialog, @NotNull XBreakpointType<B, ?> type) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/XBreakpointsPanel.<init> must not be null");
        }
        if (parentDialog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/XBreakpointsPanel.<init> must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/XBreakpointsPanel.<init> must not be null");
        }
        super(type.getTitle(), type.getBreakpointsDialogHelpTopic(), XBreakpoint.class);
        this.myProject = project;
        this.myParentDialog = parentDialog;
        this.myType = type;
        this.$$$setupUI$$$();
        this.myAllGroupingRules = new ArrayList(this.myType.getGroupingRules());
        this.mySelectedGroupingRules = this.getInitialGroupingRules();
        this.myTree = XBreakpointsTree.createTree(this.myType, this.mySelectedGroupingRules);
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                XBreakpointsPanel.this.onSelectionChanged();
            }
        });
        ArrayList<XBreakpointPanelAction> actions = new ArrayList<XBreakpointPanelAction>();
        if (type.isAddBreakpointButtonVisible()) {
            actions.add(new AddBreakpointAction(this));
        }
        actions.add(new GoToBreakpointAction(this, XDebuggerBundle.message((String)"xbreakpoints.dialog.button.goto", (Object[])new Object[0]), true));
        actions.add(new GoToBreakpointAction(this, XDebuggerBundle.message((String)"xbreakpoints.dialog.button.view.source", (Object[])new Object[0]), false));
        actions.add(new RemoveBreakpointAction(this));
        this.myActions = actions.toArray(new XBreakpointPanelAction[actions.size()]);
        this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane(this.myTree), "Center");
        this.initButtons();
        this.onSelectionChanged();
    }

    private Set<XBreakpointGroupingRule<B, ?>> getInitialGroupingRules() {
        HashSet rules = new HashSet();
        XBreakpointTypeDialogState settings = ((XBreakpointManagerImpl)this.getBreakpointManager()).getDialogState(this.myType);
        if (settings != null) {
            for (XBreakpointGroupingRule<B, ?> rule : this.myAllGroupingRules) {
                if (!settings.getSelectedGroupingRules().contains(rule.getId())) continue;
                rules.add(rule);
            }
        }
        return rules;
    }

    private void onSelectionChanged() {
        Object oldBreakpoint;
        List<B> breakpoints = this.myTree.getSelectedBreakpoints();
        for (XBreakpointPanelAction<B> action : this.myActions) {
            JButton button = this.myButtons.get(action);
            button.setEnabled(action.isEnabled(breakpoints));
        }
        XBreakpoint selectedBreakpoint = breakpoints.size() == 1 ? (XBreakpoint)breakpoints.get(0) : null;
        Object v0 = oldBreakpoint = this.mySelectedPropertiesPanel != null ? this.mySelectedPropertiesPanel.getBreakpoint() : null;
        if (this.mySelectedPropertiesPanel != null && oldBreakpoint != selectedBreakpoint) {
            this.mySelectedPropertiesPanel.saveProperties();
            this.mySelectedPropertiesPanel.dispose();
            this.mySelectedPropertiesPanel = null;
            this.myPropertiesPanel.removeAll();
        }
        if (selectedBreakpoint != null && selectedBreakpoint != oldBreakpoint) {
            this.mySelectedPropertiesPanel = new XBreakpointPropertiesPanel<XBreakpoint>(this.myProject, this.getBreakpointManager(), selectedBreakpoint);
            this.myPropertiesPanel.add((Component)this.mySelectedPropertiesPanel.getMainPanel(), "Center");
            this.myPropertiesPanelWrapper.revalidate();
        }
        this.updatePropertiesWrapper();
    }

    private void updatePropertiesWrapper() {
        CardLayout cardLayout = (CardLayout)this.myPropertiesPanelWrapper.getLayout();
        cardLayout.show(this.myPropertiesPanelWrapper, this.mySelectedPropertiesPanel != null ? "properties" : "empty");
    }

    private void initButtons() {
        this.myButtons = new HashMap<XBreakpointPanelAction<B>, JButton>();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 2, 2, 2);
        for (XBreakpointPanelAction<B> action : this.myActions) {
            JButton button = this.createButton(action);
            this.myButtonsPanel.add((Component)button, constraints);
            this.myButtons.put(action, button);
        }
        for (XBreakpointGroupingRule<B, ?> groupingRule : this.myAllGroupingRules) {
            this.myButtonsPanel.add((Component)this.createGroupingRuleCheckBox(groupingRule), constraints);
        }
    }

    private JCheckBox createGroupingRuleCheckBox(final XBreakpointGroupingRule<B, ?> groupingRule) {
        final JCheckBox checkBox = new JCheckBox(groupingRule.getPresentableName());
        checkBox.setSelected(this.mySelectedGroupingRules.contains(groupingRule));
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (checkBox.isSelected()) {
                    XBreakpointsPanel.this.mySelectedGroupingRules.add(groupingRule);
                } else {
                    XBreakpointsPanel.this.mySelectedGroupingRules.remove(groupingRule);
                }
                XBreakpointsPanel.this.myTree.setGroupingRules(XBreakpointsPanel.this.getSelectedGroupingRules());
            }
        });
        return checkBox;
    }

    private List<XBreakpointGroupingRule<B, ?>> getSelectedGroupingRules() {
        ArrayList rules = new ArrayList();
        for (XBreakpointGroupingRule<B, ?> rule : this.myAllGroupingRules) {
            if (!this.mySelectedGroupingRules.contains(rule)) continue;
            rules.add(rule);
        }
        return rules;
    }

    private JButton createButton(final XBreakpointPanelAction<B> action) {
        final JButton button = new JButton(action.getName());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = XBreakpointsPanel.this.myTree.getSelectedBreakpoints();
                action.perform(list, button);
            }
        });
        return button;
    }

    @Override
    public void dispose() {
        if (this.mySelectedPropertiesPanel != null) {
            this.mySelectedPropertiesPanel.dispose();
        }
    }

    @Override
    public Icon getTabIcon() {
        for (XBreakpoint b : this.getBreakpoints()) {
            if (!b.isEnabled()) continue;
            return this.myType.getEnabledIcon();
        }
        return this.myType.getDisabledIcon();
    }

    @Override
    public void saveBreakpoints() {
        if (this.mySelectedPropertiesPanel != null) {
            this.mySelectedPropertiesPanel.saveProperties();
        }
        if (!this.mySelectedGroupingRules.isEmpty()) {
            XBreakpointTypeDialogState state = new XBreakpointTypeDialogState();
            for (XBreakpointGroupingRule<B, ?> rule : this.mySelectedGroupingRules) {
                state.getSelectedGroupingRules().add(rule.getId());
            }
            ((XBreakpointManagerImpl)this.getBreakpointManager()).putDialogState(this.myType, state);
        }
    }

    public XBreakpointManager getBreakpointManager() {
        return XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
    }

    @Override
    public void resetBreakpoints() {
        Collection<B> breakpoints = this.getBreakpoints();
        this.myTree.buildTree(breakpoints);
        this.fireBreakpointsChanged();
    }

    private Collection<? extends B> getBreakpoints() {
        return this.getBreakpointManager().getBreakpoints(this.myType);
    }

    @Override
    public boolean hasBreakpoints() {
        return !this.getBreakpoints().isEmpty();
    }

    @Override
    public JPanel getPanel() {
        return this.myMainPanel;
    }

    public XBreakpointType<B, ?> getType() {
        return this.myType;
    }

    @Override
    public boolean canSelectBreakpoint(XBreakpoint breakpoint) {
        return breakpoint.getType().equals(this.myType);
    }

    @Override
    public void selectBreakpoint(XBreakpoint breakpoint) {
        this.myTree.selectBreakpoint(breakpoint);
    }

    public DialogWrapper getParentDialog() {
        return this.myParentDialog;
    }

    public void hideBreakpointProperties() {
        if (this.mySelectedPropertiesPanel != null) {
            this.mySelectedPropertiesPanel.dispose();
            this.mySelectedPropertiesPanel = null;
            this.myPropertiesPanel.removeAll();
            this.updatePropertiesWrapper();
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPropertiesPanelWrapper = jPanel4 = new JPanel();
        jPanel4.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, "empty");
        this.myPropertiesPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, "properties");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 5, 5, 5), 7, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(6, 6, 0, 6), null, 0, 0, null, null));
        this.myTreePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel8.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myButtonsPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel8.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

