/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomFileIndex;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.ModelMergerImpl;
import com.intellij.util.xml.impl.DomAnchorImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.structure.DomStructureViewBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomServiceImpl
extends DomService {
    public ModelMerger createModelMerger() {
        return new ModelMergerImpl();
    }

    public <T extends DomElement> DomAnchor<T> createAnchor(T domElement) {
        return DomAnchorImpl.createAnchor(domElement);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public XmlFile getContainingFile(@NotNull DomElement domElement) {
        DomInvocationHandler handler;
        XmlFile xmlFile;
        if (domElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/DomServiceImpl.getContainingFile must not be null");
        }
        if (domElement instanceof DomFileElement) {
            xmlFile = ((DomFileElement)domElement).getFile();
            if (xmlFile == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomServiceImpl.getContainingFile must not return null");
            return xmlFile;
        }
        assert (handler != null) : domElement;
        for (handler = DomManagerImpl.getDomInvocationHandler(domElement); handler != null && !(handler instanceof DomRootInvocationHandler) && handler.getXmlTag() == null; handler = handler.getParentHandler()) {
        }
        if (handler instanceof DomRootInvocationHandler) {
            xmlFile = ((DomRootInvocationHandler)handler).getParent().getFile();
            if (xmlFile == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomServiceImpl.getContainingFile must not return null");
            return xmlFile;
        }
        assert (handler != null);
        XmlTag tag = handler.getXmlTag();
        assert (tag != null);
        while (true) {
            PsiElement parentTag;
            if (!((parentTag = PhysicalDomParentStrategy.getParentTagCandidate((XmlElement)tag)) instanceof XmlTag)) {
                xmlFile = (XmlFile)tag.getContainingFile();
                if (xmlFile != null) return xmlFile;
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomServiceImpl.getContainingFile must not return null");
            }
            tag = (XmlTag)parentTag;
        }
    }

    @NotNull
    public EvaluatedXmlName getEvaluatedXmlName(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/DomServiceImpl.getEvaluatedXmlName must not be null");
        }
        EvaluatedXmlName evaluatedXmlName = DomManagerImpl.getDomInvocationHandler(element).getXmlName();
        if (evaluatedXmlName == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomServiceImpl.getEvaluatedXmlName must not return null");
        }
        return evaluatedXmlName;
    }

    public Collection<VirtualFile> getDomFileCandidates(Class<? extends DomElement> description, Project project) {
        return FileBasedIndex.getInstance().getContainingFiles(DomFileIndex.NAME, description.getName(), GlobalSearchScope.allScope((Project)project));
    }

    public <T extends DomElement> List<DomFileElement<T>> getFileElements(Class<T> clazz, Project project, @Nullable GlobalSearchScope scope) {
        Collection list = scope == null ? this.getDomFileCandidates(clazz, project) : this.getDomFileCandidates(clazz, project, scope);
        ArrayList<DomFileElement<T>> result = new ArrayList<DomFileElement<T>>(list.size());
        for (VirtualFile file : list) {
            DomFileElement element;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof XmlFile) || (element = DomManager.getDomManager((Project)project).getFileElement((XmlFile)psiFile, clazz)) == null) continue;
            result.add(element);
        }
        return result;
    }

    public StructureViewBuilder createSimpleStructureViewBuilder(XmlFile file, Function<DomElement, DomService.StructureViewMode> modeProvider) {
        return new DomStructureViewBuilder(file, modeProvider);
    }
}

