/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.RootDomParentStrategy;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DomRootInvocationHandler
extends DomInvocationHandler<AbstractDomChildDescriptionImpl> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.DomRootInvocationHandler");
    private final DomFileElementImpl<?> myParent;

    public DomRootInvocationHandler(Class aClass, RootDomParentStrategy strategy, @NotNull DomFileElementImpl fileElement, @NotNull EvaluatedXmlName tagName) {
        if (fileElement == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/xml/impl/DomRootInvocationHandler.<init> must not be null");
        }
        if (tagName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/util/xml/impl/DomRootInvocationHandler.<init> must not be null");
        }
        super(aClass, strategy, tagName, new AbstractDomChildDescriptionImpl(aClass){

            @NotNull
            public List<? extends DomElement> getValues(@NotNull DomElement parent) {
                if (parent == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/DomRootInvocationHandler$1.getValues must not be null");
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public int compareTo(AbstractDomChildDescriptionImpl o) {
                throw new UnsupportedOperationException();
            }
        }, fileElement.getManager(), true);
        this.myParent = fileElement;
    }

    @Override
    public void undefineInternal() {
        try {
            XmlTag tag = this.getXmlTag();
            if (tag != null) {
                this.deleteTag(tag);
                this.detach();
                this.fireUndefinedEvent();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DomRootInvocationHandler)) {
            return false;
        }
        DomRootInvocationHandler handler = (DomRootInvocationHandler)((Object)obj);
        return this.myParent.equals(handler.myParent);
    }

    @Override
    public int hashCode() {
        return this.myParent.hashCode();
    }

    @Override
    @NotNull
    public String getXmlElementNamespace() {
        String string = this.getXmlName().getNamespace((XmlElement)this.getFile(), this.getFile());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomRootInvocationHandler.getXmlElementNamespace must not return null");
        }
        return string;
    }

    @Override
    public boolean isValid() {
        XmlTag tag = (XmlTag)this.getXmlElement();
        if (tag != null && !tag.isValid()) {
            return false;
        }
        return this.myParent.isValid();
    }

    @NotNull
    public DomFileElementImpl getParent() {
        this.checkIsValid();
        DomFileElementImpl<?> domFileElementImpl = this.myParent;
        if (domFileElementImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomRootInvocationHandler.getParent must not return null");
        }
        return domFileElementImpl;
    }

    @Override
    public DomElement createPathStableCopy() {
        final DomFileElement stableCopy = (DomFileElement)this.myParent.createStableCopy();
        return this.getManager().createStableValue(new NullableFactory<DomElement>(){

            public DomElement create() {
                return stableCopy.isValid() ? stableCopy.getRootElement() : null;
            }
        });
    }

    @Override
    protected XmlTag setEmptyXmlTag() {
        final XmlTag[] result = new XmlTag[]{null};
        this.getManager().runChange(new Runnable(){

            @Override
            public void run() {
                try {
                    String namespace = DomRootInvocationHandler.this.getXmlElementNamespace();
                    String nsDecl = StringUtil.isEmpty((String)namespace) ? "" : " xmlns=\"" + namespace + "\"";
                    XmlFile xmlFile = DomRootInvocationHandler.this.getFile();
                    XmlTag tag = XmlElementFactory.getInstance((Project)xmlFile.getProject()).createTagFromText("<" + DomRootInvocationHandler.this.getXmlElementName() + nsDecl + "/>");
                    result[0] = ((XmlDocument)xmlFile.getDocument().replace((PsiElement)((XmlFile)tag.getContainingFile()).getDocument())).getRootTag();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
        return result[0];
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public final DomNameStrategy getNameStrategy() {
        DomNameStrategy domNameStrategy;
        Class<?> rawType = this.getRawType();
        DomNameStrategy strategy = DomImplUtil.getDomNameStrategy(rawType, this.isAttribute());
        if (strategy != null) {
            domNameStrategy = strategy;
            if (domNameStrategy == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomRootInvocationHandler.getNameStrategy must not return null");
            return domNameStrategy;
        }
        domNameStrategy = DomNameStrategy.HYPHEN_STRATEGY;
        if (domNameStrategy != null) return domNameStrategy;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/DomRootInvocationHandler.getNameStrategy must not return null");
    }
}

