/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.XmlCompletionData;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.impl.GenericValueReferenceProvider;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;

public class DomCompletionContributor
extends CompletionContributor {
    private final GenericValueReferenceProvider myProvider = new GenericValueReferenceProvider();

    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        if (this.domKnowsBetter(parameters, result)) {
            result.stopHere();
        }
    }

    private boolean domKnowsBetter(final CompletionParameters parameters, final CompletionResultSet result) {
        final PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), (Class[])new Class[]{XmlTag.class, XmlAttributeValue.class});
        return element != null && (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (DomCompletionContributor.isSchemaEnumerated(element)) {
                    return false;
                }
                PsiReference[] references = DomCompletionContributor.this.myProvider.getReferencesByElement(element, new ProcessingContext());
                if (references.length > 0) {
                    return LegacyCompletionContributor.completeReference(parameters, result, new XmlCompletionData());
                }
                return false;
            }
        }) != false;
    }

    public static boolean isSchemaEnumerated(PsiElement element) {
        XmlAttributeDescriptor descriptor;
        PsiElement parent;
        XmlTag simpleContent;
        if (element instanceof XmlTag && (simpleContent = XmlUtil.getSchemaSimpleContent((XmlTag)element)) != null && XmlUtil.collectEnumerationValues(simpleContent, (java.util.HashSet<String>)new HashSet())) {
            return true;
        }
        return element instanceof XmlAttributeValue && (parent = element.getParent()) instanceof XmlAttribute && (descriptor = ((XmlAttribute)parent).getDescriptor()) != null && descriptor.isEnumerated();
    }
}

