/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChildrenDescriptionsHolder<T extends DomChildDescriptionImpl> {
    private final Map<XmlName, T> myMap = new THashMap();
    private final ChildrenDescriptionsHolder<T> myDelegate;
    private volatile List<T> myCached = null;

    public ChildrenDescriptionsHolder(@Nullable ChildrenDescriptionsHolder<T> delegate) {
        this.myDelegate = delegate;
    }

    public ChildrenDescriptionsHolder() {
        this(null);
    }

    final T addDescription(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/ChildrenDescriptionsHolder.addDescription must not be null");
        }
        this.myMap.put(((DomChildDescriptionImpl)t).getXmlName(), t);
        this.myCached = null;
        return t;
    }

    final void addDescriptions(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/ChildrenDescriptionsHolder.addDescriptions must not be null");
        }
        for (DomChildDescriptionImpl t : collection) {
            this.addDescription(t);
        }
    }

    @Nullable
    final T getDescription(XmlName name) {
        DomChildDescriptionImpl t = (DomChildDescriptionImpl)this.myMap.get(name);
        if (t != null) {
            return (T)t;
        }
        return this.myDelegate != null ? (T)this.myDelegate.getDescription(name) : null;
    }

    @Nullable
    final T getDescription(@NotNull String localName, String namespaceKey) {
        if (localName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/ChildrenDescriptionsHolder.getDescription must not be null");
        }
        return this.getDescription(new XmlName(localName, namespaceKey));
    }

    @Nullable
    final T findDescription(@NotNull String localName) {
        if (localName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/ChildrenDescriptionsHolder.findDescription must not be null");
        }
        for (XmlName xmlName : this.myMap.keySet()) {
            if (!xmlName.getLocalName().equals(localName)) continue;
            return (T)((DomChildDescriptionImpl)this.myMap.get(xmlName));
        }
        return this.myDelegate != null ? (T)this.myDelegate.findDescription(localName) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    final List<T> getDescriptions() {
        List<T> list;
        List<T> cached = this.myCached;
        if (cached != null) {
            list = cached;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/ChildrenDescriptionsHolder.getDescriptions must not return null");
            return list;
        }
        cached = new ArrayList<T>(this.myMap.values());
        if (this.myDelegate != null) {
            cached.addAll(this.myDelegate.myMap.values());
        }
        Collections.sort(cached);
        this.myCached = cached;
        list = cached;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/ChildrenDescriptionsHolder.getDescriptions must not return null");
    }
}

