/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.impl.ConvertContextImpl;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.GenericDomValueReference;
import com.intellij.util.xml.impl.GenericValueReferenceProvider;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import com.intellij.xml.XmlBundle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomHighlightingHelperImpl
extends DomHighlightingHelper {
    private final GenericValueReferenceProvider myProvider = new GenericValueReferenceProvider();
    private final DomElementAnnotationsManagerImpl myAnnotationsManager;

    public DomHighlightingHelperImpl(DomElementAnnotationsManagerImpl annotationsManager) {
        this.myAnnotationsManager = annotationsManager;
    }

    public void runAnnotators(DomElement element, DomElementAnnotationHolder holder, Class<? extends DomElement> rootClass) {
        this.myAnnotationsManager.annotate(element, holder, rootClass);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<DomElementProblemDescriptor> checkRequired(DomElement element, DomElementAnnotationHolder holder) {
        SmartList smartList;
        Required required = (Required)element.getAnnotation(Required.class);
        if (required != null) {
            XmlElement xmlElement = element.getXmlElement();
            if (xmlElement == null) {
                if (required.value()) {
                    String xmlElementName = element.getXmlElementName();
                    if (!(element instanceof GenericAttributeValue ? (smartList = Arrays.asList(holder.createProblem(element, IdeBundle.message((String)"attribute.0.should.be.defined", (Object[])new Object[]{xmlElementName})))) != null : (smartList = Arrays.asList(holder.createProblem(element, HighlightSeverity.ERROR, IdeBundle.message((String)"child.tag.0.should.be.defined", (Object[])new Object[]{xmlElementName}), new LocalQuickFix[]{new AddRequiredSubtagFix(xmlElementName, element.getXmlElementNamespace(), element.getParent().getXmlTag())}))) != null)) throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomHighlightingHelperImpl.checkRequired must not return null");
                    return smartList;
                }
            } else if (element instanceof GenericDomValue) {
                smartList = ContainerUtil.createMaybeSingletonList((Object)DomHighlightingHelperImpl.checkRequiredGenericValue((GenericDomValue)element, required, holder));
                if (smartList == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomHighlightingHelperImpl.checkRequired must not return null");
                return smartList;
            }
        }
        if (DomUtil.hasXml((DomElement)element)) {
            SmartList list = new SmartList();
            DomGenericInfo info = element.getGenericInfo();
            for (AbstractDomChildrenDescription description : info.getChildrenDescriptions()) {
                if (!(description instanceof DomCollectionChildDescription) || !description.getValues(element).isEmpty()) continue;
                DomCollectionChildDescription childDescription = (DomCollectionChildDescription)description;
                Required annotation = (Required)description.getAnnotation(Required.class);
                if (annotation == null || !annotation.value()) continue;
                list.add((Object)holder.createProblem(element, childDescription, IdeBundle.message((String)"child.tag.0.should.be.defined", (Object[])new Object[]{((DomCollectionChildDescription)description).getXmlElementName()})));
            }
            smartList = list;
            if (smartList == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomHighlightingHelperImpl.checkRequired must not return null");
            return smartList;
        }
        smartList = Collections.emptyList();
        if (smartList != null) return smartList;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomHighlightingHelperImpl.checkRequired must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<DomElementProblemDescriptor> checkResolveProblems(GenericDomValue element, DomElementAnnotationHolder holder) {
        SmartList smartList;
        Required required;
        if (StringUtil.isEmpty((String)element.getStringValue()) && (required = (Required)element.getAnnotation(Required.class)) != null && !required.nonEmpty()) {
            smartList = Collections.emptyList();
            if (smartList == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomHighlightingHelperImpl.checkResolveProblems must not return null");
            return smartList;
        } else {
            XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)element);
            if (valueElement == null || DomHighlightingHelperImpl.isSoftReference(element)) {
                smartList = Collections.emptyList();
                if (smartList == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomHighlightingHelperImpl.checkResolveProblems must not return null");
                return smartList;
            } else {
                String errorMessage;
                SmartList list = new SmartList();
                PsiReference[] psiReferences = this.myProvider.getReferencesByElement((PsiElement)valueElement, new ProcessingContext());
                GenericDomValueReference domReference = null;
                for (PsiReference reference : psiReferences) {
                    if (!(reference instanceof GenericDomValueReference)) continue;
                    domReference = (GenericDomValueReference)reference;
                    break;
                }
                Converter converter = WrappingConverter.getDeepestConverter((Converter)element.getConverter(), (GenericDomValue)element);
                boolean domReferenceResolveOK = domReference != null && !DomHighlightingHelperImpl.hasBadResolve(element, (PsiReference)domReference) || domReference != null && converter instanceof ResolvingConverter && ((ResolvingConverter)converter).getAdditionalVariants((ConvertContext)domReference.getConvertContext()).contains(element.getStringValue());
                boolean hasBadResolve = false;
                if (!domReferenceResolveOK) {
                    for (PsiReference reference : psiReferences) {
                        if (reference == domReference || !DomHighlightingHelperImpl.hasBadResolve(element, reference)) continue;
                        hasBadResolve = true;
                        list.add((Object)holder.createResolveProblem(element, reference));
                    }
                    boolean isResolvingConverter = converter instanceof ResolvingConverter;
                    if (!hasBadResolve && (domReference != null || isResolvingConverter && DomHighlightingHelperImpl.hasBadResolve(element, domReference = new GenericDomValueReference(element)))) {
                        hasBadResolve = true;
                        String errorMessage2 = converter.getErrorMessage(element.getStringValue(), (ConvertContext)new ConvertContextImpl(DomManagerImpl.getDomInvocationHandler((DomElement)element)));
                        if (errorMessage2 != null && XmlHighlightVisitor.getErrorDescription(domReference) != null) {
                            list.add((Object)holder.createResolveProblem(element, domReference));
                        }
                    }
                }
                if (!hasBadResolve && psiReferences.length == 0 && element.getValue() == null && !PsiTreeUtil.hasErrorElements((PsiElement)valueElement) && (errorMessage = converter.getErrorMessage(element.getStringValue(), (ConvertContext)new ConvertContextImpl(DomManagerImpl.getDomInvocationHandler((DomElement)element)))) != null) {
                    list.add((Object)holder.createProblem((DomElement)element, errorMessage));
                }
                if ((smartList = list) == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomHighlightingHelperImpl.checkResolveProblems must not return null");
                return smartList;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<DomElementProblemDescriptor> checkNameIdentity(DomElement element, DomElementAnnotationHolder holder) {
        List<DomElementProblemDescriptor> list;
        DomElement domElement;
        String elementName = ElementPresentationManager.getElementName((Object)element);
        if (StringUtil.isNotEmpty((String)elementName) && (domElement = DomUtil.findDuplicateNamedValue((DomElement)element, (String)elementName)) != null) {
            String typeName = ElementPresentationManager.getTypeNameForObject((Object)element);
            GenericDomValue genericDomValue = domElement.getGenericInfo().getNameDomElement(element);
            if (genericDomValue != null) {
                list = Arrays.asList(holder.createProblem((DomElement)genericDomValue, DomUtil.getFile((DomElement)domElement).equals(DomUtil.getFile((DomElement)element)) ? IdeBundle.message((String)"model.highlighting.identity", (Object[])new Object[]{typeName}) : IdeBundle.message((String)"model.highlighting.identity.in.other.file", (Object[])new Object[]{typeName, domElement.getXmlTag().getContainingFile().getName()})));
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomHighlightingHelperImpl.checkNameIdentity must not return null");
                return list;
            }
        }
        if ((list = Collections.emptyList()) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomHighlightingHelperImpl.checkNameIdentity must not return null");
    }

    private static boolean hasBadResolve(GenericDomValue value, PsiReference reference) {
        return XmlHighlightVisitor.hasBadResolve(reference);
    }

    private static boolean isSoftReference(GenericDomValue value) {
        Resolve resolve = (Resolve)value.getAnnotation(Resolve.class);
        if (resolve != null && resolve.soft()) {
            return true;
        }
        Convert convert = (Convert)value.getAnnotation(Convert.class);
        if (convert != null && convert.soft()) {
            return true;
        }
        Referencing referencing = (Referencing)value.getAnnotation(Referencing.class);
        return referencing != null && referencing.soft();
    }

    @Nullable
    private static DomElementProblemDescriptor checkRequiredGenericValue(GenericDomValue child, Required required, DomElementAnnotationHolder annotator) {
        String stringValue = child.getStringValue();
        if (stringValue == null) {
            return null;
        }
        if (required.nonEmpty() && DomHighlightingHelperImpl.isEmpty(child, stringValue)) {
            return annotator.createProblem((DomElement)child, IdeBundle.message((String)"value.must.not.be.empty", (Object[])new Object[0]));
        }
        if (required.identifier() && !DomHighlightingHelperImpl.isIdentifier(stringValue)) {
            return annotator.createProblem((DomElement)child, IdeBundle.message((String)"value.must.be.identifier", (Object[])new Object[0]));
        }
        return null;
    }

    private static boolean isIdentifier(String s) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(GenericDomValue child, String stringValue) {
        XmlAttributeValue value;
        if (stringValue.trim().length() != 0) {
            return false;
        }
        return !(child instanceof GenericAttributeValue) || (value = ((GenericAttributeValue)child).getXmlAttributeValue()) == null || !value.getTextRange().isEmpty();
    }

    private static class AddRequiredSubtagFix
    implements LocalQuickFix,
    IntentionAction {
        private final String tagName;
        private final String tagNamespace;
        private final XmlTag parentTag;

        public AddRequiredSubtagFix(@NotNull String _tagName, @NotNull String _tagNamespace, @NotNull XmlTag _parentTag) {
            if (_tagName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix.<init> must not be null");
            }
            if (_tagNamespace == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix.<init> must not be null");
            }
            if (_parentTag == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix.<init> must not be null");
            }
            this.tagName = _tagName;
            this.tagNamespace = _tagNamespace;
            this.parentTag = _parentTag;
        }

        @NotNull
        public String getName() {
            String string = XmlBundle.message((String)"insert.required.tag.fix", (Object[])new Object[]{this.tagName});
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix.getText must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix.getFamilyName must not return null");
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix.isAvailable must not be null");
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix.invoke must not be null");
            }
            this.doFix();
        }

        public boolean startInWriteAction() {
            return true;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix.applyFix must not be null");
            }
            this.doFix();
        }

        private void doFix() {
            if (!CodeInsightUtilBase.prepareFileForWrite(this.parentTag.getContainingFile())) {
                return;
            }
            try {
                this.parentTag.add((PsiElement)this.parentTag.createChildTag(this.tagName, this.tagNamespace, "", false));
            }
            catch (IncorrectOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

