/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ChangesTrackingTableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public abstract class ValidatingTableEditor<Item> {
    private static final Icon WARNING_ICON = UIUtil.getBalloonWarningIcon();
    private static final Icon EMPTY_ICON = new EmptyIcon(WARNING_ICON);
    private static final String REMOVE_KEY = "REMOVE_SELECTED";
    private JPanel myContentPane;
    private TableView<Item> myTable;
    private JButton myAddButton;
    private JButton myRemoveButton;
    private JLabel myMessageLabel;
    private HoverHyperlinkLabel myFixLink;
    private final List<String> myWarnings;
    private Fix myFixRunnable;

    protected abstract Item cloneOf(Item var1);

    @Nullable
    protected Pair<String, Fix> validate(List<Item> current, List<String> warnings) {
        String error = null;
        for (int i = 0; i < current.size(); ++i) {
            Item item = current.get(i);
            String s = this.validate(item);
            warnings.set(i, s);
            if (error != null) continue;
            error = s;
        }
        return error != null ? Pair.create(error, (Object)null) : null;
    }

    @Nullable
    protected String validate(Item item) {
        return null;
    }

    protected abstract Item createItem();

    private void createUIComponents() {
        this.myTable = new ChangesTrackingTableView<Item>(){

            @Override
            protected void onTextChanged(int row, int column, String value) {
                Object original = this.getItems().get(row);
                Object override = ValidatingTableEditor.this.cloneOf(original);
                ColumnInfo columnInfo = ValidatingTableEditor.this.getTableModel().getColumnInfos()[column];
                columnInfo.setValue(override, (Object)value);
                ValidatingTableEditor.this.updateMessage(row, override);
            }

            @Override
            protected void onEditingStopped() {
                ValidatingTableEditor.this.updateMessage(-1, null);
            }
        };
        this.myFixLink = new HoverHyperlinkLabel(null);
    }

    protected ValidatingTableEditor() {
        this.$$$setupUI$$$();
        this.myWarnings = new ArrayList<String>();
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ValidatingTableEditor.this.updateButtons();
            }
        });
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), REMOVE_KEY);
        this.myTable.getActionMap().put(REMOVE_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidatingTableEditor.this.removeSelected();
            }
        });
        this.myFixLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && ValidatingTableEditor.this.myFixRunnable != null) {
                    ValidatingTableEditor.this.myFixRunnable.run();
                }
            }
        });
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidatingTableEditor.this.addItem();
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidatingTableEditor.this.removeSelected();
            }
        });
    }

    private void removeSelected() {
        this.myTable.stopEditing();
        ArrayList<Item> items = new ArrayList<Item>(this.doGetItems());
        int[] rows = this.myTable.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            items.remove(rows[i]);
        }
        this.setItems(items);
        this.updateMessage(-1, null);
        if (!items.isEmpty()) {
            int index = Math.min(rows[0], items.size() - 1);
            this.myTable.getSelectionModel().addSelectionInterval(index, index);
        }
    }

    protected void addItem() {
        ArrayList<Item> items = new ArrayList<Item>(this.doGetItems());
        items.add(this.createItem());
        this.setItems(items);
        int row = items.size() - 1;
        this.myTable.getSelectionModel().setSelectionInterval(row, row);
        this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
        if (this.getTableModel().getColumnInfos()[1].isCellEditable(items.get(row))) {
            this.myTable.editCellAt(row, 1);
            IdeFocusManager.findInstanceByComponent((Component)this.myContentPane).requestFocus(this.myTable.getEditorComponent(), true);
        }
        this.updateMessage(-1, null);
    }

    private ListTableModel<Item> getTableModel() {
        return (ListTableModel)this.myTable.getModel();
    }

    public void setModel(ColumnInfo<Item, String>[] valueColumns, List<Item> items) {
        ColumnInfo[] columns = new ColumnInfo[valueColumns.length + 1];
        IconColumn iconColumn = new IconColumn();
        int maxHeight = iconColumn.getRowHeight();
        columns[0] = iconColumn;
        for (int i = 0; i < valueColumns.length; ++i) {
            columns[i + 1] = new ColumnInfoWrapper(valueColumns[i]);
            if (!(valueColumns[i] instanceof RowHeightProvider)) continue;
            maxHeight = Math.max(maxHeight, ((RowHeightProvider)valueColumns[i]).getRowHeight());
        }
        this.myTable.stopEditing();
        this.myTable.setModel(new ListTableModel(columns));
        if (maxHeight > 0) {
            this.myTable.setRowHeight(maxHeight);
        }
        this.setItems(items);
        this.updateMessage(-1, null);
    }

    public List<Item> getItems() {
        return Collections.unmodifiableList(this.doGetItems());
    }

    private List<Item> doGetItems() {
        ArrayList items = new ArrayList(this.getTableModel().getItems());
        if (this.myTable.isEditing()) {
            Component c = this.myTable.getEditorComponent();
            JTextField textField = c instanceof CellEditorComponentWithBrowseButton ? (JTextField)((CellEditorComponentWithBrowseButton)c).getChildComponent() : (JTextField)c;
            String value = textField.getText();
            ColumnInfo column = ((ListTableModel)this.myTable.getModel()).getColumnInfos()[this.myTable.getEditingColumn()];
            ((ColumnInfoWrapper)column).myDelegate.setValue(items.get(this.myTable.getEditingRow()), (Object)value);
        }
        return items;
    }

    private void setItems(List<Item> items) {
        if (items.isEmpty()) {
            this.getTableModel().setItems(Collections.emptyList());
            this.myWarnings.clear();
        } else {
            this.getTableModel().setItems(new ArrayList<Item>(items));
            for (Item item : items) {
                this.myWarnings.add(null);
            }
        }
        this.updateButtons();
    }

    public void setTableHeader(JTableHeader header) {
        this.myTable.setTableHeader(header);
    }

    private void updateButtons() {
        this.myRemoveButton.setEnabled(this.myTable.getSelectedRow() != -1);
    }

    public void updateMessage(int index, @Nullable Item override) {
        Pair<String, Fix> messageAndFix;
        ArrayList<Item> current = new ArrayList<Item>(this.doGetItems());
        if (override != null) {
            current.set(index, override);
        }
        if ((messageAndFix = this.validate(current, this.myWarnings)) != null) {
            this.myMessageLabel.setText((String)messageAndFix.first);
            this.myMessageLabel.setIcon(WARNING_ICON);
            this.myMessageLabel.setVisible(true);
            this.myFixRunnable = (Fix)messageAndFix.second;
            this.myFixLink.setVisible(this.myFixRunnable != null);
            this.myFixLink.setText(this.myFixRunnable != null ? this.myFixRunnable.getTitle() : null);
        } else {
            this.myMessageLabel.setText(" ");
            this.myMessageLabel.setIcon(EMPTY_ICON);
            this.myFixLink.setVisible(false);
            this.myFixRunnable = null;
        }
        this.myTable.repaint();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    public Component getContentPane() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 3, 0, 3, 7, 7, null, null, null));
        TableView<Item> tableView = this.myTable;
        jScrollPane.setViewportView((Component)tableView);
        this.myAddButton = jButton2 = new JButton();
        jButton2.setText("Add");
        jButton2.setMnemonic('D');
        jButton2.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRemoveButton = jButton = new JButton();
        jButton.setText("Remove");
        jButton.setMnemonic('R');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myFixLink;
        ((JLabel)hoverHyperlinkLabel).setText("Fix");
        jPanel2.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static class WarningIconCellRenderer
    extends DefaultTableCellRenderer {
        private final NullableComputable<String> myWarningProvider;

        public WarningIconCellRenderer(NullableComputable<String> warningProvider) {
            this.myWarningProvider = warningProvider;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String message = (String)this.myWarningProvider.compute();
            label.setIcon(message != null ? WARNING_ICON : null);
            label.setToolTipText(message);
            label.setHorizontalAlignment(0);
            label.setVerticalAlignment(0);
            return label;
        }
    }

    private class IconColumn
    extends ColumnInfo<Item, Object>
    implements RowHeightProvider {
        public IconColumn() {
            super(" ");
        }

        public String valueOf(Item item) {
            return null;
        }

        public int getWidth(JTable table) {
            return WARNING_ICON.getIconWidth() + 2;
        }

        @Override
        public int getRowHeight() {
            return WARNING_ICON.getIconHeight();
        }

        public TableCellRenderer getRenderer(final Item item) {
            return new WarningIconCellRenderer(new NullableComputable<String>(){

                public String compute() {
                    return (String)ValidatingTableEditor.this.myWarnings.get(ValidatingTableEditor.this.doGetItems().indexOf(item));
                }
            });
        }
    }

    private class ColumnInfoWrapper
    extends ColumnInfo<Item, String> {
        private final ColumnInfo<Item, String> myDelegate;

        public ColumnInfoWrapper(ColumnInfo<Item, String> delegate) {
            super(delegate.getName());
            this.myDelegate = delegate;
        }

        public String valueOf(Item item) {
            return (String)this.myDelegate.valueOf(item);
        }

        public boolean isCellEditable(Item item) {
            return this.myDelegate.isCellEditable(item);
        }

        public void setValue(Item item, String value) {
            this.myDelegate.setValue(item, (Object)value);
            ValidatingTableEditor.this.updateMessage(-1, null);
        }

        public TableCellEditor getEditor(Item item) {
            return this.myDelegate.getEditor(item);
        }
    }

    public static interface Fix
    extends Runnable {
        public String getTitle();
    }

    public static interface RowHeightProvider {
        public int getRowHeight();
    }
}

