/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.ByteBufferMap;
import com.intellij.util.io.WriteableMap;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

class ByteBufferMapWriteHandler<V> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.ByteBufferMapWriteHandler");
    private final ByteBufferMap.ValueProvider<V> myValueProvider;
    private final WriteableMap<V> myMap;
    private final int[] myKeyHashes;
    private final int myMod;
    private final DataOutput myOut;

    public ByteBufferMapWriteHandler(DataOutput stream, ByteBufferMap.ValueProvider<V> valueProvider, WriteableMap<V> map, double searchFactor) {
        this.myValueProvider = valueProvider;
        this.myMap = map;
        this.myKeyHashes = this.myMap.getHashCodesArray();
        int mod = (int)((double)this.myKeyHashes.length / searchFactor);
        this.myMod = mod != 0 ? mod : 1;
        this.myOut = stream;
    }

    public void execute() throws IOException {
        this.executeImpl(true);
    }

    public int calcLength() throws IOException {
        return this.executeImpl(false);
    }

    public int executeImpl(boolean write) throws IOException {
        int j;
        if (write) {
            this.myOut.writeInt(this.myMod);
        }
        int offset = 4;
        int[] overflowList = new int[this.myKeyHashes.length];
        int[] firstOverflowElem = new int[this.myMod];
        int[] occurs = new int[this.myMod];
        Arrays.fill(firstOverflowElem, -1);
        int i = this.myKeyHashes.length - 1;
        while (i >= 0) {
            int hashhash = this.hash(this.myKeyHashes[i]);
            overflowList[i] = firstOverflowElem[hashhash];
            firstOverflowElem[hashhash] = i--;
            int n = hashhash;
            occurs[n] = occurs[n] + 1;
        }
        offset += 4 * this.myMod;
        for (i = 0; i < this.myMod; ++i) {
            if (write) {
                this.myOut.writeInt(occurs[i] != 0 ? offset : -1);
            }
            if (occurs[i] != 0) {
                offset += 4;
            }
            int occurs_i = 0;
            int j2 = firstOverflowElem[i];
            while (j2 != -1) {
                offset += this.myMap.getKeyLength(j2) + 4;
                ++occurs_i;
                j2 = overflowList[j2];
            }
            LOG.assertTrue(occurs_i == occurs[i]);
        }
        for (i = 0; i < this.myMod; ++i) {
            if (occurs[i] == 0) continue;
            if (write) {
                this.myOut.writeInt(occurs[i]);
            }
            j = firstOverflowElem[i];
            while (j != -1) {
                if (write) {
                    this.myMap.writeKey(this.myOut, j);
                    this.myOut.writeInt(offset);
                }
                V value = this.myMap.getValue(j);
                offset += this.myValueProvider.length(value);
                j = overflowList[j];
            }
        }
        for (i = 0; i < this.myMod; ++i) {
            j = firstOverflowElem[i];
            while (j != -1) {
                V value = this.myMap.getValue(j);
                if (write) {
                    this.myValueProvider.write(this.myOut, value);
                }
                j = overflowList[j];
            }
        }
        return offset;
    }

    private int hash(int hashCode) {
        return Math.abs(hashCode) % this.myMod;
    }
}

