/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.PersistentHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapReduceIndex<Key, Value, Input>
implements UpdatableIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.MapReduceIndex");
    private final ID<Key, Value> myIndexId;
    private final DataIndexer<Key, Value, Input> myIndexer;
    protected final IndexStorage<Key, Value> myStorage;
    private PersistentHashMap<Integer, Collection<Key>> myInputsIndex;
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private Factory<PersistentHashMap<Integer, Collection<Key>>> myInputsIndexFactory;

    public MapReduceIndex(@Nullable ID<Key, Value> indexId, DataIndexer<Key, Value, Input> indexer, IndexStorage<Key, Value> storage) {
        this.myIndexId = indexId;
        this.myIndexer = indexer;
        this.myStorage = storage;
    }

    public IndexStorage<Key, Value> getStorage() {
        return this.myStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws StorageException {
        block9: {
            try {
                this.getWriteLock().lock();
                this.myStorage.clear();
                if (this.myInputsIndex == null) break block9;
                File baseFile = this.myInputsIndex.getBaseFile();
                try {
                    this.myInputsIndex.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                FileUtil.delete((File)baseFile);
                this.myInputsIndex = this.createInputsIndex();
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
    }

    @Override
    public void flush() throws StorageException {
        try {
            this.getReadLock().lock();
            PersistentHashMap<Integer, Collection<Key>> inputsIndex = this.myInputsIndex;
            if (inputsIndex != null && inputsIndex.isDirty()) {
                inputsIndex.force();
            }
            this.myStorage.flush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                throw new StorageException(cause);
            }
            throw e;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Lock lock = this.getWriteLock();
        try {
            lock.lock();
            try {
                this.myStorage.close();
            }
            finally {
                if (this.myInputsIndex != null) {
                    try {
                        this.myInputsIndex.close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
        catch (StorageException e) {
            LOG.error((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Lock getReadLock() {
        return this.myLock.readLock();
    }

    @Override
    public Lock getWriteLock() {
        return this.myLock.writeLock();
    }

    @Override
    public Collection<Key> getAllKeys() throws StorageException {
        HashSet allKeys = new HashSet();
        this.processAllKeys((Processor<Key>)new CommonProcessors.CollectProcessor(allKeys));
        return allKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAllKeys(Processor<Key> processor) throws StorageException {
        Lock lock = this.getReadLock();
        try {
            lock.lock();
            boolean bl = this.myStorage.processKeys(processor);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ValueContainer<Value> getData(Key key) throws StorageException {
        Lock lock = this.getReadLock();
        lock.lock();
        ValueContainer<Value> valueContainer = this.myStorage.read(key);
        ValueContainer<Value> valueContainer2 = valueContainer;
        if (valueContainer2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/MapReduceIndex.getData must not return null");
        }
        return valueContainer2;
        finally {
            lock.unlock();
        }
    }

    public void setInputIdToDataKeysIndex(Factory<PersistentHashMap<Integer, Collection<Key>>> factory) throws IOException {
        this.myInputsIndexFactory = factory;
        this.myInputsIndex = this.createInputsIndex();
    }

    private PersistentHashMap<Integer, Collection<Key>> createInputsIndex() throws IOException {
        Factory<PersistentHashMap<Integer, Collection<Key>>> factory = this.myInputsIndexFactory;
        if (factory != null) {
            try {
                return (PersistentHashMap)factory.create();
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }
        return null;
    }

    @Override
    public final void update(final int inputId, @Nullable Input content) throws StorageException {
        assert (this.myInputsIndex != null);
        Map data = content != null ? this.myIndexer.map(content) : Collections.emptyMap();
        this.updateWithMap(inputId, data, new Callable<Collection<Key>>(){

            @Override
            public Collection<Key> call() throws Exception {
                Collection oldKeys = (Collection)MapReduceIndex.this.myInputsIndex.get((Object)inputId);
                return oldKeys == null ? Collections.emptyList() : oldKeys;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWithMap(int inputId, Map<Key, Value> newData, Callable<Collection<Key>> oldKeysGetter) throws StorageException {
        block11: {
            this.getWriteLock().lock();
            try {
                try {
                    for (Key Key2 : oldKeysGetter.call()) {
                        this.myStorage.removeAllValues(Key2, inputId);
                    }
                }
                catch (Exception e) {
                    throw new StorageException(e);
                }
                for (Map.Entry entry : newData.entrySet()) {
                    this.myStorage.addValue(entry.getKey(), inputId, entry.getValue());
                }
                if (this.myInputsIndex == null) break block11;
                try {
                    Set<Key> newKeys = newData.keySet();
                    if (newKeys.size() > 0) {
                        this.myInputsIndex.put((Object)inputId, newKeys);
                    } else {
                        this.myInputsIndex.remove((Object)inputId);
                    }
                }
                catch (IOException e) {
                    throw new StorageException(e);
                }
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
    }
}

