/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.MaskProvider;
import com.intellij.openapi.ui.popup.MouseChecker;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.Processor;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentPopupBuilderImpl
implements ComponentPopupBuilder {
    private String myTitle = "";
    private boolean myResizable;
    private boolean myMovable;
    private final JComponent myComponent;
    private final JComponent myPrefferedFocusedComponent;
    private boolean myRequestFocus;
    private boolean myForceHeavyweight;
    private String myDimensionServiceKey = null;
    private Computable<Boolean> myCallback = null;
    private Project myProject;
    private boolean myCancelOnClickOutside = true;
    private final Set<JBPopupListener> myListeners = new LinkedHashSet<JBPopupListener>();
    private boolean myUseDimSevriceForXYLocation;
    private IconButton myCancelButton;
    private MouseChecker myCancelOnMouseOutCallback;
    private boolean myCancelOnWindow;
    private ActiveIcon myTitleIcon = new ActiveIcon((Icon)new EmptyIcon(0));
    private boolean myCancelKeyEnabled = true;
    private boolean myLocateByContent = false;
    private boolean myPlacewithinScreen = true;
    private Processor<JBPopup> myPinCallback = null;
    private Dimension myMinSize;
    private MaskProvider myMaskProvider;
    private float myAlpha;
    private ArrayList<Object> myUserData;
    private boolean myInStack = true;
    private boolean myModalContext = true;
    private Component[] myFocusOwners = new Component[0];
    private String myAd;
    private boolean myFocusable = true;
    private boolean myHeaderAlwaysFocusable;
    private InplaceButton myCommandButton;
    private List<Pair<ActionListener, KeyStroke>> myKeyboardActions = Collections.emptyList();
    private Component mySettingsButtons;
    private boolean myMayBeParent;

    public ComponentPopupBuilderImpl(JComponent component, JComponent prefferedFocusedComponent) {
        this.myComponent = component;
        this.myPrefferedFocusedComponent = prefferedFocusedComponent;
    }

    public ComponentPopupBuilder setMayBeParent(boolean mayBeParent) {
        this.myMayBeParent = mayBeParent;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setTitle(String title) {
        this.myTitle = title;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setTitle must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setResizable(boolean resizable) {
        this.myResizable = resizable;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setResizable must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setMovable(boolean movable) {
        this.myMovable = movable;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setMovable must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCancelOnClickOutside(boolean cancel) {
        this.myCancelOnClickOutside = cancel;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setCancelOnClickOutside must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCancelOnMouseOutCallback(MouseChecker shouldCancel) {
        this.myCancelOnMouseOutCallback = shouldCancel;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setCancelOnMouseOutCallback must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder addListener(JBPopupListener listener) {
        this.myListeners.add(listener);
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.addListener must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setRequestFocus must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setFocusable(boolean focusable) {
        this.myFocusable = focusable;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setFocusable must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setForceHeavyweight(boolean forceHeavyweight) {
        this.myForceHeavyweight = forceHeavyweight;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setForceHeavyweight must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setDimensionServiceKey(Project project, String dimensionServiceKey, boolean useForXYLocation) {
        this.myDimensionServiceKey = dimensionServiceKey;
        this.myUseDimSevriceForXYLocation = useForXYLocation;
        this.myProject = project;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setDimensionServiceKey must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCancelCallback(Computable<Boolean> shouldProceed) {
        this.myCallback = shouldProceed;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setCancelCallback must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCancelButton(@NotNull IconButton cancelButton) {
        if (cancelButton == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/ComponentPopupBuilderImpl.setCancelButton must not be null");
        }
        this.myCancelButton = cancelButton;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setCancelButton must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCommandButton(@NotNull InplaceButton button) {
        if (button == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/ComponentPopupBuilderImpl.setCommandButton must not be null");
        }
        this.myCommandButton = button;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setCommandButton must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCouldPin(@Nullable Processor<JBPopup> callback) {
        this.myPinCallback = callback;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setCouldPin must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setKeyboardActions(@NotNull List<Pair<ActionListener, KeyStroke>> keyboardActions) {
        if (keyboardActions == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/ComponentPopupBuilderImpl.setKeyboardActions must not be null");
        }
        this.myKeyboardActions = keyboardActions;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setKeyboardActions must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setSettingButtons(@NotNull Component button) {
        if (button == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/ComponentPopupBuilderImpl.setSettingButtons must not be null");
        }
        this.mySettingsButtons = button;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setSettingButtons must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCancelOnOtherWindowOpen(boolean cancelOnWindow) {
        this.myCancelOnWindow = cancelOnWindow;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setCancelOnOtherWindowOpen must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setProject(Project project) {
        this.myProject = project;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setProject must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public JBPopup createPopup() {
        AbstractPopup popup = new AbstractPopup().init(this.myProject, this.myComponent, this.myPrefferedFocusedComponent, this.myRequestFocus, this.myFocusable, this.myForceHeavyweight, this.myMovable, this.myDimensionServiceKey, this.myResizable, this.myTitle, this.myCallback, this.myCancelOnClickOutside, this.myListeners, this.myUseDimSevriceForXYLocation, this.myCommandButton, this.myCancelButton, this.myCancelOnMouseOutCallback, this.myCancelOnWindow, this.myTitleIcon, this.myCancelKeyEnabled, this.myLocateByContent, this.myPlacewithinScreen, this.myMinSize, this.myAlpha, this.myMaskProvider, this.myInStack, this.myModalContext, this.myFocusOwners, this.myAd, this.myHeaderAlwaysFocusable, this.myKeyboardActions, this.mySettingsButtons, this.myPinCallback, this.myMayBeParent);
        if (this.myUserData != null) {
            popup.setUserData(this.myUserData);
        }
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)popup);
        AbstractPopup abstractPopup = popup;
        if (abstractPopup == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.createPopup must not return null");
        }
        return abstractPopup;
    }

    @NotNull
    public ComponentPopupBuilder setRequestFocusCondition(Project project, Condition<Project> condition) {
        this.myRequestFocus = condition.value((Object)project);
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setRequestFocusCondition must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setTitleIcon(@NotNull ActiveIcon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/ComponentPopupBuilderImpl.setTitleIcon must not be null");
        }
        this.myTitleIcon = icon;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setTitleIcon must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCancelKeyEnabled(boolean enabled) {
        this.myCancelKeyEnabled = enabled;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setCancelKeyEnabled must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setLocateByContent(boolean byContent) {
        this.myLocateByContent = byContent;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setLocateByContent must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setLocateWithinScreenBounds(boolean within) {
        this.myPlacewithinScreen = within;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setLocateWithinScreenBounds must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setMinSize(Dimension minSize) {
        this.myMinSize = minSize;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setMinSize must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setMaskProvider(MaskProvider maskProvider) {
        this.myMaskProvider = maskProvider;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setMaskProvider must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setAlpha(float alpha) {
        this.myAlpha = alpha;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setAlpha must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setBelongsToGlobalPopupStack(boolean isInStack) {
        this.myInStack = isInStack;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setBelongsToGlobalPopupStack must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder addUserData(Object object) {
        if (this.myUserData == null) {
            this.myUserData = new ArrayList();
        }
        this.myUserData.add(object);
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.addUserData must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setModalContext(boolean modal) {
        this.myModalContext = modal;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setModalContext must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setFocusOwners(@NotNull Component[] focusOwners) {
        if (focusOwners == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/popup/ComponentPopupBuilderImpl.setFocusOwners must not be null");
        }
        this.myFocusOwners = focusOwners;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setFocusOwners must not return null");
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setAdText(@Nullable String text) {
        this.myAd = text;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ui/popup/ComponentPopupBuilderImpl.setAdText must not return null");
        }
        return componentPopupBuilderImpl;
    }
}

