/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.AbstractToolTipHandler;
import com.intellij.ui.TableCellKey;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class TableToolTipHandler
extends AbstractToolTipHandler<TableCellKey, JTable> {
    protected TableToolTipHandler(JTable table) {
        super(table);
    }

    public static void install(JTable table) {
        new TableToolTipHandler(table);
    }

    @Override
    public Rectangle getCellBounds(TableCellKey tableCellKey, Component rendererComponent) {
        Rectangle cellRect = this.getCellRect(tableCellKey);
        cellRect.width = rendererComponent.getPreferredSize().width;
        return cellRect;
    }

    private Rectangle getCellRect(TableCellKey tableCellKey) {
        return ((JTable)this.myComponent).getCellRect(tableCellKey.myRowIndex, tableCellKey.myColumnIndex, false);
    }

    @Override
    public Component getRendererComponent(TableCellKey key) {
        int modelColumnIndex = ((JTable)this.myComponent).convertColumnIndexToModel(key.myColumnIndex);
        TableModel model = ((JTable)this.myComponent).getModel();
        if (key.myRowIndex < 0 || key.myRowIndex >= model.getRowCount() || key.myColumnIndex < 0 || key.myColumnIndex >= model.getColumnCount()) {
            return null;
        }
        return ((JTable)this.myComponent).getCellRenderer(key.myRowIndex, key.myColumnIndex).getTableCellRendererComponent((JTable)this.myComponent, ((JTable)this.myComponent).getModel().getValueAt(key.myRowIndex, modelColumnIndex), ((JTable)this.myComponent).getSelectionModel().isSelectedIndex(key.myRowIndex), ((JTable)this.myComponent).hasFocus(), key.myRowIndex, key.myColumnIndex);
    }

    @Override
    public Rectangle getVisibleRect(TableCellKey key) {
        Rectangle columnVisibleRect = ((JTable)this.myComponent).getVisibleRect();
        Rectangle cellRect = this.getCellRect(key);
        int visibleRight = Math.min(columnVisibleRect.x + columnVisibleRect.width, cellRect.x + cellRect.width);
        columnVisibleRect.x = Math.min(columnVisibleRect.x, cellRect.x);
        columnVisibleRect.width = Math.max(0, visibleRight - columnVisibleRect.x);
        return columnVisibleRect;
    }

    @Override
    public TableCellKey getCellKeyForPoint(Point point) {
        int rowIndex = ((JTable)this.myComponent).rowAtPoint(point);
        if (rowIndex == -1) {
            return null;
        }
        int columnIndex = ((JTable)this.myComponent).columnAtPoint(point);
        if (columnIndex == -1) {
            return null;
        }
        return new TableCellKey(rowIndex, columnIndex);
    }
}

