/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.AbstractToolTipHandler;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class ListToolTipHandler
extends AbstractToolTipHandler<Integer, JList> {
    protected ListToolTipHandler(JList list) {
        super(list);
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToolTipHandler.this.repaintHint();
            }
        });
        list.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                ListToolTipHandler.this.hideHint();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ListToolTipHandler.this.hideHint();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ListToolTipHandler.this.hideHint();
            }
        });
    }

    public static void install(JList list) {
        new ListToolTipHandler(list);
    }

    @Override
    protected Integer getCellKeyForPoint(Point point) {
        int rowIndex = ((JList)this.myComponent).locationToIndex(point);
        return rowIndex != -1 ? new Integer(rowIndex) : null;
    }

    @Override
    protected Rectangle getCellBounds(Integer key, Component rendererComponent) {
        int rowIndex = key;
        Rectangle cellBounds = ((JList)this.myComponent).getCellBounds(rowIndex, rowIndex);
        cellBounds.width = rendererComponent.getPreferredSize().width;
        return cellBounds;
    }

    @Override
    protected Component getRendererComponent(Integer key) {
        ListCellRenderer renderer = ((JList)this.myComponent).getCellRenderer();
        if (renderer == null) {
            return null;
        }
        ListModel model = ((JList)this.myComponent).getModel();
        int rowIndex = key;
        if (rowIndex >= model.getSize()) {
            return null;
        }
        return renderer.getListCellRendererComponent((JList)this.myComponent, model.getElementAt(rowIndex), rowIndex, ((JList)this.myComponent).isSelectedIndex(rowIndex), ((JList)this.myComponent).hasFocus());
    }
}

