/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.Function;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;

public class ListSpeedSearch
extends SpeedSearchBase<JList> {
    private Function<Object, String> myElementTextDelegate;

    public ListSpeedSearch(JList list) {
        super(list);
    }

    public ListSpeedSearch(JList component, Function<Object, String> elementTextDelegate) {
        super(component);
        this.myElementTextDelegate = elementTextDelegate;
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        ListScrollingUtil.selectItem((JList)((JList)this.myComponent), (Object)element);
    }

    @Override
    protected int getSelectedIndex() {
        return ((JList)this.myComponent).getSelectedIndex();
    }

    @Override
    protected Object[] getAllElements() {
        ListModel model = ((JList)this.myComponent).getModel();
        if (model instanceof DefaultListModel) {
            return ((DefaultListModel)model).toArray();
        }
        Object[] elements = new Object[model.getSize()];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = model.getElementAt(i);
        }
        return elements;
    }

    @Override
    protected String getElementText(Object element) {
        if (this.myElementTextDelegate != null) {
            return (String)this.myElementTextDelegate.fun(element);
        }
        return element.toString();
    }
}

