/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.PatchedWeakReference;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformTestCase
extends UsefulTestCase
implements DataProvider {
    protected static IdeaTestApplication ourApplication;
    protected boolean myRunCommandForTest = false;
    protected ProjectManagerEx myProjectManager;
    protected Project myProject;
    protected Module myModule;
    protected static final Collection<File> myFilesToDelete;
    protected boolean myAssertionsInTestDetected;
    protected static final Logger LOG;
    public static Thread ourTestThread;
    private static TestCase ourTestCase;
    public static final long DEFAULT_TEST_TIME = 300L;
    public static long ourTestTime;
    private static final MyThreadGroup MY_THREAD_GROUP;
    private static final String ourOriginalTempDir;
    private EditorListenerTracker myEditorListenerTracker;
    private String myTempDirPath;
    private ThreadTracker myThreadTracker;

    protected static long getTimeRequired() {
        return 300L;
    }

    @Nullable
    protected String getApplicationConfigDirPath() throws Exception {
        return null;
    }

    protected void initApplication() throws Exception {
        boolean firstTime = ourApplication == null;
        ourApplication = IdeaTestApplication.getInstance(this.getApplicationConfigDirPath());
        ourApplication.setDataProvider(this);
        if (firstTime) {
            PlatformTestCase.cleanPersistedVFSContent();
        }
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFS)ManagingFS.getInstance()).cleanPersistedContents();
    }

    @Override
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        return CodeStyleSettingsManager.getSettings((Project)this.getProject());
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (ourTestCase != null) {
            String message = "Previous test " + ourTestCase + " hasn't called tearDown(). Probably overriden without super call.";
            ourTestCase = null;
            PlatformTestCase.fail((String)message);
        }
        IdeaLogger.ourErrorsOccurred = null;
        LOG.info(((Object)((Object)this)).getClass().getName() + ".setUp()");
        this.myTempDirPath = ourOriginalTempDir + "/" + this.getTestName(true) + "/";
        PlatformTestCase.setTmpDir(this.myTempDirPath);
        new File(this.myTempDirPath).mkdir();
        this.initApplication();
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        this.setUpProject();
        this.storeSettings();
        ourTestCase = this;
    }

    public Project getProject() {
        return this.myProject;
    }

    public final PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myProject);
    }

    public Module getModule() {
        return this.myModule;
    }

    protected void setUpProject() throws Exception {
        this.myProjectManager = ProjectManagerEx.getInstanceEx();
        PlatformTestCase.assertNotNull((String)"Cannot instantiate ProjectManager component", (Object)((Object)this.myProjectManager));
        File projectFile = this.getIprFile();
        LocalFileSystem.getInstance().refreshIoFiles(myFilesToDelete);
        this.myProject = PlatformTestCase.createProject(projectFile, ((Object)((Object)this)).getClass().getName() + "." + this.getName());
        this.setUpModule();
        this.setUpJdk();
        ProjectManagerEx.getInstanceEx().setCurrentTestProject(this.myProject);
        this.runStartupActivities();
    }

    @Nullable
    public static Project createProject(File projectFile, String creationPlace) {
        try {
            Project project = ProjectManagerEx.getInstanceEx().newProject(FileUtil.getNameWithoutExtension((File)projectFile), projectFile.getPath(), false, false);
            assert (project != null);
            project.putUserData(CREATION_PLACE, (Object)creationPlace);
            return project;
        }
        catch (TooManyProjectLeakedException e) {
            StringBuilder leakers = new StringBuilder();
            leakers.append("Too many projects leaked: \n");
            for (Project project : e.getLeakedProjects()) {
                String place = (String)project.getUserData(CREATION_PLACE);
                leakers.append((Object)(place != null ? place : project.getBaseDir()));
                leakers.append("\n");
            }
            PlatformTestCase.fail((String)leakers.toString());
            return null;
        }
    }

    protected void runStartupActivities() {
        ((StartupManagerImpl)StartupManager.getInstance((Project)this.myProject)).runStartupActivities();
        ((StartupManagerImpl)StartupManager.getInstance((Project)this.myProject)).runPostStartupActivities();
    }

    protected File getIprFile() throws IOException {
        File tempFile = FileUtil.createTempFile((String)("temp_" + this.getName()), (String)".ipr");
        myFilesToDelete.add(tempFile);
        return tempFile;
    }

    protected void setUpModule() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformTestCase.this.myModule = PlatformTestCase.this.createMainModule();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    protected Module createMainModule() throws IOException {
        return this.createModule(this.myProject.getName());
    }

    protected Module createModule(@NonNls String moduleName) {
        return this.doCreateRealModule(moduleName);
    }

    protected Module doCreateRealModule(String moduleName) {
        VirtualFile baseDir = this.myProject.getBaseDir();
        PlatformTestCase.assertNotNull((Object)baseDir);
        File moduleFile = new File(baseDir.getPath().replace('/', File.separatorChar), moduleName + ".iml");
        FileUtil.createIfDoesntExist((File)moduleFile);
        myFilesToDelete.add(moduleFile);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleFile);
        Module module = ModuleManager.getInstance((Project)this.myProject).newModule(virtualFile.getPath(), this.getModuleType());
        module.getModuleFile();
        return module;
    }

    protected ModuleType getModuleType() {
        return EmptyModuleType.getInstance();
    }

    public static void cleanupApplicationCaches(Project project) {
        if (project != null) {
            ((UndoManagerImpl)UndoManager.getInstance((Project)project)).dropHistoryInTests();
            ((PsiManagerEx)PsiManager.getInstance((Project)project)).getFileManager().cleanupForNextTest();
        }
        try {
            LocalFileSystemImpl localFileSystem = (LocalFileSystemImpl)LocalFileSystem.getInstance();
            if (localFileSystem != null) {
                localFileSystem.cleanupForNextTest();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        VirtualFilePointerManagerImpl virtualFilePointerManager = (VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance();
        if (virtualFilePointerManager != null) {
            virtualFilePointerManager.cleanupForNextTest();
        }
        PatchedWeakReference.clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        LightPlatformTestCase.doTearDown(this.getProject(), ourApplication, false);
        try {
            this.checkForSettingsDamage();
            try {
                this.disposeProject();
                for (File fileToDelete : myFilesToDelete) {
                    this.delete(fileToDelete);
                }
                LocalFileSystem.getInstance().refreshIoFiles(myFilesToDelete);
                FileUtil.asyncDelete((File)new File(this.myTempDirPath));
                PlatformTestCase.setTmpDir(ourOriginalTempDir);
                Throwable fromThreadGroup = MY_THREAD_GROUP.popThrowable();
                if (fromThreadGroup != null) {
                    throw new RuntimeException(fromThreadGroup);
                }
                if (!this.myAssertionsInTestDetected) {
                    if (IdeaLogger.ourErrorsOccurred != null) {
                        throw IdeaLogger.ourErrorsOccurred;
                    }
                    PlatformTestCase.assertNull((String)("Logger errors occurred in " + this.getFullName()), (Object)IdeaLogger.ourErrorsOccurred);
                }
            }
            finally {
                ourTestCase = null;
            }
            super.tearDown();
            this.myEditorListenerTracker.checkListenersLeak();
            this.myThreadTracker.checkLeak();
            LightPlatformTestCase.checkEditorsReleased();
        }
        finally {
            this.myProjectManager = null;
            this.myProject = null;
            this.myModule = null;
            myFilesToDelete.clear();
        }
    }

    private void disposeProject() {
        if (this.myProject != null) {
            Disposer.dispose((Disposable)this.myProject);
            ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
            if (projectManager != null) {
                projectManager.setCurrentTestProject(null);
            }
        }
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    @Override
    protected final <T extends Disposable> T disposeOnTearDown(T disposable) {
        Disposer.register((Disposable)this.myProject, disposable);
        return disposable;
    }

    private void resetClassFields(Class<?> aClass) {
        try {
            PlatformTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        if (aClass == PlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private String getFullName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    private void delete(File file) {
        boolean b = FileUtil.delete((File)file);
        if (!b && file.exists() && !this.myAssertionsInTestDetected) {
            PlatformTestCase.fail((String)("Can't delete " + file.getAbsolutePath() + " in " + this.getFullName()));
        }
    }

    protected void simulateProjectOpen() {
        ModuleManagerImpl mm = (ModuleManagerImpl)ModuleManager.getInstance((Project)this.myProject);
        StartupManagerImpl sm = (StartupManagerImpl)StartupManager.getInstance((Project)this.myProject);
        mm.projectOpened();
        this.setUpJdk();
        sm.runStartupActivities();
        sm.runPostStartupActivities();
    }

    protected void setUpJdk() {
        Module[] modules;
        final Sdk jdk = this.getTestProjectJdk();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            final ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ModifiableRootModel rootModel = rootManager.getModifiableModel();
                    rootModel.setSdk(jdk);
                    rootModel.commit();
                }
            });
        }
    }

    protected Sdk getTestProjectJdk() {
        return null;
    }

    public void runBare() throws Throwable {
        final Throwable[] throwable = new Throwable[1];
        Thread thread = new Thread(MY_THREAD_GROUP, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block10: {
                    PlatformTestCase.this.runBareImpl();
                    try {
                        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                PlatformTestCase.cleanupApplicationCaches(PlatformTestCase.this.getProject());
                                PlatformTestCase.this.resetAllFields();
                            }
                        }, ModalityState.NON_MODAL);
                    }
                    catch (Throwable e) {}
                    break block10;
                    catch (Throwable th) {
                        try {
                            throwable[0] = th;
                        }
                        catch (Throwable throwable3) {
                            try {
                                ApplicationManager.getApplication().invokeAndWait(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            throw throwable3;
                        }
                        try {
                            ApplicationManager.getApplication().invokeAndWait(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
                        }
                        catch (Throwable throwable4) {}
                    }
                }
            }
        }, "IDEA Test Case Thread");
        thread.start();
        thread.join();
        if (throwable[0] != null) {
            throw throwable[0];
        }
    }

    private void runBareImpl() throws Throwable {
        final Throwable[] throwables = new Throwable[1];
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ourTestThread = Thread.currentThread();
                ourTestTime = PlatformTestCase.getTimeRequired();
                try {
                    try {
                        PlatformTestCase.this.setUp();
                    }
                    catch (Throwable e) {
                        PlatformTestCase.this.disposeProject();
                        throw e;
                    }
                    try {
                        PlatformTestCase.this.myAssertionsInTestDetected = true;
                        PlatformTestCase.this.runTest();
                        PlatformTestCase.this.myAssertionsInTestDetected = false;
                    }
                    finally {
                        try {
                            PlatformTestCase.this.tearDown();
                        }
                        catch (Throwable th) {
                            th.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    throwables[0] = throwable;
                }
                finally {
                    ourTestThread = null;
                }
            }
        };
        this.runBareRunnable(runnable);
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        if (throwables[0] != null) {
            throw throwables[0];
        }
        PlatformTestCase.waitForAllLaters();
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private static void waitForAllLaters() throws InterruptedException, InvocationTargetException {
        for (int i = 0; i < 3; ++i) {
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        }
    }

    protected void runBareRunnable(Runnable runnable) throws Throwable {
        SwingUtilities.invokeAndWait(runnable);
    }

    protected void runTest() throws Throwable {
        final Throwable[] throwables = new Throwable[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformTestCase.super.runTest();
                }
                catch (InvocationTargetException e) {
                    e.fillInStackTrace();
                    throwables[0] = e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    e.fillInStackTrace();
                    throwables[0] = e;
                }
                catch (Throwable e) {
                    throwables[0] = e;
                }
            }
        };
        this.invokeTestRunnable(runnable);
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    protected boolean isRunInWriteAction() {
        return true;
    }

    protected void invokeTestRunnable(final Runnable runnable) throws Exception {
        final Exception[] e = new Exception[1];
        Runnable runnable1 = new Runnable(){

            @Override
            public void run() {
                try {
                    if (ApplicationManager.getApplication().isDispatchThread() && PlatformTestCase.this.isRunInWriteAction()) {
                        ApplicationManager.getApplication().runWriteAction(runnable);
                    } else {
                        runnable.run();
                    }
                }
                catch (Exception e1) {
                    e[0] = e1;
                }
            }
        };
        if (this.myRunCommandForTest) {
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable1, "", null);
        } else {
            runnable1.run();
        }
        if (e[0] != null) {
            throw e[0];
        }
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (PlatformDataKeys.EDITOR.is(dataId)) {
            return FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
        }
        return null;
    }

    public static File createTempDir(@NonNls String prefix) throws IOException {
        File tempDirectory = FileUtil.createTempDirectory((String)prefix, null);
        myFilesToDelete.add(tempDirectory);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                VirtualFileManager.getInstance().refresh(false);
            }
        });
        return tempDirectory;
    }

    protected static VirtualFile getVirtualFile(File file) {
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    protected File createTempDirectory() throws IOException {
        File dir = FileUtil.createTempDirectory((String)this.getTestName(true), null);
        myFilesToDelete.add(dir);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                VirtualFileManager.getInstance().refresh(false);
            }
        });
        return dir;
    }

    protected PsiFile getPsiFile(Document document) {
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
    }

    private static void setTmpDir(String path) {
        System.setProperty("java.io.tmpdir", path);
        try {
            Class<File> ioFile = File.class;
            Field field = ioFile.getDeclaredField("tmpdir");
            field.setAccessible(true);
            field.set(ioFile, null);
        }
        catch (NoSuchFieldException ignore) {
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
    }

    static {
        myFilesToDelete = new HashSet<File>();
        LOG = Logger.getInstance((String)"#com.intellij.testFramework.PlatformTestCase");
        ourTestCase = null;
        ourTestTime = 300L;
        MY_THREAD_GROUP = new MyThreadGroup();
        ourOriginalTempDir = FileUtil.getTempDirectory();
        Logger.setFactory((Logger.Factory)TestLoggerFactory.getInstance());
    }

    private static class MyThreadGroup
    extends ThreadGroup {
        private Throwable myThrowable;
        @NonNls
        private static final String IDEATEST_THREAD_GROUP = "IDEATest";

        private MyThreadGroup() {
            super(IDEATEST_THREAD_GROUP);
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.myThrowable = e;
            super.uncaughtException(t, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Throwable popThrowable() {
            try {
                Throwable throwable = this.myThrowable;
                return throwable;
            }
            finally {
                this.myThrowable = null;
            }
        }
    }
}

