/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.jetbrains.annotations.NonNls;

public class ExpectedHighlightingData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.testFramework.ExpectedHighlightingData");
    @NonNls
    private static final String ERROR_MARKER = "error";
    @NonNls
    private static final String WARNING_MARKER = "warning";
    @NonNls
    private static final String INFORMATION_MARKER = "weak_warning";
    @NonNls
    private static final String INFO_MARKER = "info";
    @NonNls
    private static final String END_LINE_HIGHLIGHT_MARKER = "EOLError";
    @NonNls
    private static final String END_LINE_WARNING_MARKER = "EOLWarning";
    @NonNls
    private static final String LINE_MARKER = "lineMarker";
    private final PsiFile myFile;
    @NonNls
    private static final String ANY_TEXT = "*";
    String myText;
    protected final Map<String, ExpectedHighlightingSet> highlightingTypes;
    private final Map<RangeMarker, LineMarkerInfo> lineMarkerInfos = new THashMap();
    private static final HighlightInfoType WHATEVER = new HighlightInfoType.HighlightInfoTypeImpl();

    public ExpectedHighlightingData(Document document, boolean checkWarnings, boolean checkInfos) {
        this(document, checkWarnings, false, checkInfos);
    }

    public ExpectedHighlightingData(Document document, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos) {
        this(document, checkWarnings, checkWeakWarnings, checkInfos, null);
    }

    public ExpectedHighlightingData(Document document, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos, PsiFile file) {
        this.myFile = file;
        this.myText = document.getText();
        this.highlightingTypes = new LinkedHashMap<String, ExpectedHighlightingSet>();
        this.highlightingTypes.put(ERROR_MARKER, new ExpectedHighlightingSet(HighlightInfoType.ERROR, HighlightSeverity.ERROR, false, true));
        this.highlightingTypes.put(WARNING_MARKER, new ExpectedHighlightingSet(HighlightInfoType.WARNING, HighlightSeverity.WARNING, false, checkWarnings));
        this.highlightingTypes.put(INFORMATION_MARKER, new ExpectedHighlightingSet(HighlightInfoType.INFO, HighlightSeverity.INFO, false, checkWeakWarnings));
        this.highlightingTypes.put("inject", new ExpectedHighlightingSet(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT, HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, false, checkInfos));
        this.highlightingTypes.put(INFO_MARKER, new ExpectedHighlightingSet(HighlightInfoType.TODO, HighlightSeverity.INFORMATION, false, checkInfos));
        for (SeveritiesProvider provider : (SeveritiesProvider[])Extensions.getExtensions(SeveritiesProvider.EP_NAME)) {
            for (HighlightInfoType type : provider.getSeveritiesHighlightInfoTypes()) {
                HighlightSeverity severity = type.getSeverity(null);
                this.highlightingTypes.put(severity.toString(), new ExpectedHighlightingSet(type, severity, false, true));
            }
        }
        this.highlightingTypes.put(END_LINE_HIGHLIGHT_MARKER, new ExpectedHighlightingSet(HighlightInfoType.ERROR, HighlightSeverity.ERROR, true, true));
        this.highlightingTypes.put(END_LINE_WARNING_MARKER, new ExpectedHighlightingSet(HighlightInfoType.WARNING, HighlightSeverity.WARNING, true, checkWarnings));
        this.initAdditionalHighlightingTypes();
        this.extractExpectedLineMarkerSet(document);
        this.extractExpectedHighlightsSet(document);
        this.refreshLineMarkers();
    }

    private void refreshLineMarkers() {
        for (Map.Entry<RangeMarker, LineMarkerInfo> entry : this.lineMarkerInfos.entrySet()) {
            RangeMarker rangeMarker = entry.getKey();
            int startOffset = rangeMarker.getStartOffset();
            int endOffset = rangeMarker.getEndOffset();
            final LineMarkerInfo value = entry.getValue();
            LineMarkerInfo markerInfo = new LineMarkerInfo(value.getElement(), new TextRange(startOffset, endOffset), null, value.updatePass, (Function)new Function<PsiElement, String>(){

                public String fun(PsiElement psiElement) {
                    return value.getLineMarkerTooltip();
                }
            }, null, GutterIconRenderer.Alignment.RIGHT);
            entry.setValue(markerInfo);
        }
    }

    private void extractExpectedLineMarkerSet(Document document) {
        Matcher m;
        String text = document.getText();
        String pat = ".*?((<lineMarker)(?: descr=\"((?:[^\"\\\\]|\\\\\")*)\")?>)(.*)";
        Pattern p = Pattern.compile(pat, 32);
        Pattern pat2 = Pattern.compile("(.*?)(</lineMarker>)(.*)", 32);
        while ((m = p.matcher(text)).matches()) {
            int startOffset = m.start(1);
            final String descr = m.group(3) != null ? m.group(3) : ANY_TEXT;
            String rest = m.group(4);
            document.replaceString(startOffset, m.end(1), (CharSequence)"");
            Matcher matcher2 = pat2.matcher(rest);
            LOG.assertTrue(matcher2.matches(), (Object)"Cannot find closing </lineMarker>");
            String content = matcher2.group(1);
            int endOffset = startOffset + matcher2.start(3);
            String endTag = matcher2.group(2);
            document.replaceString(startOffset, endOffset, (CharSequence)content);
            LineMarkerInfo markerInfo = new LineMarkerInfo((PsiElement)this.myFile, new TextRange(startOffset, endOffset -= endTag.length()), null, 11, (Function)new Function<PsiElement, String>(){

                public String fun(PsiElement psiElement) {
                    return descr;
                }
            }, null, GutterIconRenderer.Alignment.RIGHT);
            this.lineMarkerInfos.put(document.createRangeMarker(startOffset, endOffset), markerInfo);
            text = document.getText();
        }
    }

    protected void initAdditionalHighlightingTypes() {
    }

    private void extractExpectedHighlightsSet(Document document) {
        String text = document.getText();
        Set<String> markers = this.highlightingTypes.keySet();
        String typesRx = "(?:" + StringUtil.join(markers, (String)")|(?:") + ")";
        String openingTagRx = "<(" + typesRx + ")" + "(?:\\s+descr=\"((?:[^\"\\\\]|\\\\\"|\\\\\\\\\")*)\")?" + "(?:\\s+type=\"([0-9A-Z_]+)\")?" + "(?:\\s+foreground=\"([0-9xa-f]+)\")?" + "(?:\\s+background=\"([0-9xa-f]+)\")?" + "(?:\\s+effectcolor=\"([0-9xa-f]+)\")?" + "(?:\\s+effecttype=\"([A-Z]+)\")?" + "(?:\\s+fonttype=\"([0-9]+)\")?" + "(/)?>";
        Matcher matcher = Pattern.compile(openingTagRx).matcher(text);
        int pos = 0;
        Ref textOffset = Ref.create((Object)0);
        while (matcher.find(pos)) {
            textOffset.set((Object)((Integer)textOffset.get() + (matcher.start() - pos)));
            pos = this.extractExpectedHighlight(matcher, text, document, (Ref<Integer>)textOffset);
        }
    }

    private int extractExpectedHighlight(Matcher matcher, String text, Document document, Ref<Integer> textOffset) {
        int toContinueFrom;
        boolean closed;
        document.deleteString(((Integer)textOffset.get()).intValue(), (Integer)textOffset.get() + (matcher.end() - matcher.start()));
        int groupIdx = 1;
        String marker = matcher.group(groupIdx++);
        String descr = matcher.group(groupIdx++);
        String typeString = matcher.group(groupIdx++);
        String foregroundColor = matcher.group(groupIdx++);
        String backgroundColor = matcher.group(groupIdx++);
        String effectColor = matcher.group(groupIdx++);
        String effectType = matcher.group(groupIdx++);
        String fontType = matcher.group(groupIdx++);
        boolean bl = closed = matcher.group(groupIdx) != null;
        if (descr == null) {
            descr = ANY_TEXT;
        } else if (descr.equals("null")) {
            descr = null;
        }
        if (descr != null) {
            descr = descr.replaceAll("\\\\\\\\\"", "\"");
        }
        HighlightInfoType type = WHATEVER;
        if (typeString != null) {
            try {
                Field field = HighlightInfoType.class.getField(typeString);
                type = (HighlightInfoType)field.get(null);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            LOG.assertTrue(type != null, (Object)("Wrong highlight type: " + typeString));
        }
        TextAttributes forcedAttributes = null;
        if (foregroundColor != null) {
            forcedAttributes = new TextAttributes(Color.decode(foregroundColor), Color.decode(backgroundColor), Color.decode(effectColor), EffectType.valueOf((String)effectType), Integer.parseInt(fontType));
        }
        int rangeStart = (Integer)textOffset.get();
        if (closed) {
            toContinueFrom = matcher.end();
        } else {
            int pos = matcher.end();
            Matcher closingTagMatcher = Pattern.compile("</" + marker + ">").matcher(text);
            while (true) {
                int nextTagStart;
                if (!closingTagMatcher.find(pos)) {
                    LOG.assertTrue(closingTagMatcher.matches(), (Object)("Cannot find closing </" + marker + ">"));
                }
                int n = nextTagStart = matcher.find(pos) ? matcher.start() : text.length();
                if (closingTagMatcher.start() < nextTagStart) {
                    textOffset.set((Object)((Integer)textOffset.get() + (closingTagMatcher.start() - pos)));
                    document.deleteString(((Integer)textOffset.get()).intValue(), (Integer)textOffset.get() + (closingTagMatcher.end() - closingTagMatcher.start()));
                    toContinueFrom = closingTagMatcher.end();
                    break;
                }
                textOffset.set((Object)((Integer)textOffset.get() + (nextTagStart - pos)));
                pos = this.extractExpectedHighlight(matcher, text, document, textOffset);
            }
        }
        ExpectedHighlightingSet expectedHighlightingSet = this.highlightingTypes.get(marker);
        if (expectedHighlightingSet.enabled) {
            HighlightInfo highlightInfo = new HighlightInfo(forcedAttributes, type, rangeStart, (Integer)textOffset.get(), descr, descr, expectedHighlightingSet.severity, expectedHighlightingSet.endOfLine, null, false);
            expectedHighlightingSet.infos.add(highlightInfo);
        }
        return toContinueFrom;
    }

    public Collection<HighlightInfo> getExtractedHighlightInfos() {
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        Collection<ExpectedHighlightingSet> collection = this.highlightingTypes.values();
        for (ExpectedHighlightingSet set : collection) {
            result.addAll(set.infos);
        }
        return result;
    }

    public void checkLineMarkers(Collection<LineMarkerInfo> markerInfos, String text) {
        int x2;
        int x1;
        int y2;
        int y1;
        int endOffset;
        int startOffset;
        String fileName = this.myFile == null ? "" : this.myFile.getName() + ": ";
        String failMessage = "";
        if (markerInfos != null) {
            for (LineMarkerInfo info : markerInfos) {
                if (ExpectedHighlightingData.containsLineMarker(info, this.lineMarkerInfos.values())) continue;
                startOffset = info.startOffset;
                endOffset = info.endOffset;
                y1 = StringUtil.offsetToLineNumber((CharSequence)text, (int)startOffset);
                y2 = StringUtil.offsetToLineNumber((CharSequence)text, (int)endOffset);
                x1 = startOffset - StringUtil.lineColToOffset((CharSequence)text, (int)y1, (int)0);
                x2 = endOffset - StringUtil.lineColToOffset((CharSequence)text, (int)y2, (int)0);
                if (failMessage.length() != 0) {
                    failMessage = failMessage + '\n';
                }
                failMessage = failMessage + fileName + "Extra line marker highlighted " + "(" + (x1 + 1) + ", " + (y1 + 1) + ")" + "-" + "(" + (x2 + 1) + ", " + (y2 + 1) + ")" + ": '" + info.getLineMarkerTooltip() + "'";
            }
        }
        for (LineMarkerInfo expectedLineMarker : this.lineMarkerInfos.values()) {
            if (ExpectedHighlightingData.containsLineMarker(expectedLineMarker, markerInfos)) continue;
            startOffset = expectedLineMarker.startOffset;
            endOffset = expectedLineMarker.endOffset;
            y1 = StringUtil.offsetToLineNumber((CharSequence)text, (int)startOffset);
            y2 = StringUtil.offsetToLineNumber((CharSequence)text, (int)endOffset);
            x1 = startOffset - StringUtil.lineColToOffset((CharSequence)text, (int)y1, (int)0);
            x2 = endOffset - StringUtil.lineColToOffset((CharSequence)text, (int)y2, (int)0);
            if (failMessage.length() != 0) {
                failMessage = failMessage + '\n';
            }
            failMessage = failMessage + fileName + "Line marker was not highlighted " + "(" + (x1 + 1) + ", " + (y1 + 1) + ")" + "-" + "(" + (x2 + 1) + ", " + (y2 + 1) + ")" + ": '" + expectedLineMarker.getLineMarkerTooltip() + "'";
        }
        if (failMessage.length() > 0) {
            Assert.assertTrue((String)failMessage, (boolean)false);
        }
    }

    private static boolean containsLineMarker(LineMarkerInfo info, Collection<LineMarkerInfo> where) {
        String infoTooltip = info.getLineMarkerTooltip();
        for (LineMarkerInfo markerInfo : where) {
            String markerInfoTooltip;
            if (markerInfo.startOffset != info.startOffset || markerInfo.endOffset != info.endOffset || !Comparing.equal((String)infoTooltip, (String)(markerInfoTooltip = markerInfo.getLineMarkerTooltip())) && !ANY_TEXT.equals(markerInfoTooltip) && !ANY_TEXT.equals(infoTooltip)) continue;
            return true;
        }
        return false;
    }

    public void checkResult(Collection<HighlightInfo> infos, String text) {
        String fileName = this.myFile == null ? "" : this.myFile.getName() + ": ";
        String failMessage = "";
        for (HighlightInfo info : infos) {
            if (this.expectedInfosContainsInfo(info)) continue;
            int startOffset = info.startOffset;
            int endOffset = info.endOffset;
            String s = text.substring(startOffset, endOffset);
            String desc = info.description;
            int y1 = StringUtil.offsetToLineNumber((CharSequence)text, (int)startOffset);
            int y2 = StringUtil.offsetToLineNumber((CharSequence)text, (int)endOffset);
            int x1 = startOffset - StringUtil.lineColToOffset((CharSequence)text, (int)y1, (int)0);
            int x2 = endOffset - StringUtil.lineColToOffset((CharSequence)text, (int)y2, (int)0);
            if (failMessage.length() != 0) {
                failMessage = failMessage + '\n';
            }
            failMessage = failMessage + fileName + "Extra text fragment highlighted " + "(" + (x1 + 1) + ", " + (y1 + 1) + ")" + "-" + "(" + (x2 + 1) + ", " + (y2 + 1) + ")" + " :'" + s + "'" + (desc == null ? "" : " (" + desc + ")") + " [" + info.type + "]";
        }
        Collection<ExpectedHighlightingSet> expectedHighlights = this.highlightingTypes.values();
        for (ExpectedHighlightingSet highlightingSet : expectedHighlights) {
            Set<HighlightInfo> expInfos = highlightingSet.infos;
            for (HighlightInfo expectedInfo : expInfos) {
                if (ExpectedHighlightingData.infosContainsExpectedInfo(infos, expectedInfo) || !highlightingSet.enabled) continue;
                int startOffset = expectedInfo.startOffset;
                int endOffset = expectedInfo.endOffset;
                String s = text.substring(startOffset, endOffset);
                String desc = expectedInfo.description;
                int y1 = StringUtil.offsetToLineNumber((CharSequence)text, (int)startOffset);
                int y2 = StringUtil.offsetToLineNumber((CharSequence)text, (int)endOffset);
                int x1 = startOffset - StringUtil.lineColToOffset((CharSequence)text, (int)y1, (int)0);
                int x2 = endOffset - StringUtil.lineColToOffset((CharSequence)text, (int)y2, (int)0);
                if (failMessage.length() != 0) {
                    failMessage = failMessage + '\n';
                }
                failMessage = failMessage + fileName + "Text fragment was not highlighted " + "(" + (x1 + 1) + ", " + (y1 + 1) + ")" + "-" + "(" + (x2 + 1) + ", " + (y2 + 1) + ")" + " :'" + s + "'" + (desc == null ? "" : " (" + desc + ")");
            }
        }
        if (failMessage.length() > 0) {
            this.compareTexts(infos, text, failMessage);
        }
    }

    private void compareTexts(Collection<HighlightInfo> infos, String text, String failMessage) {
        ArrayList<HighlightInfo> list = new ArrayList<HighlightInfo>(infos);
        Collections.sort(list, new Comparator<HighlightInfo>(){

            @Override
            public int compare(HighlightInfo o1, HighlightInfo o2) {
                int start = o2.startOffset - o1.startOffset;
                return start != 0 ? start : o1.endOffset - o2.endOffset;
            }
        });
        StringBuilder sb = new StringBuilder();
        int end = text.length();
        HighlightInfo prev = null;
        String prevSeverity = null;
        block0: for (HighlightInfo info : list) {
            for (Map.Entry<String, ExpectedHighlightingSet> entry : this.highlightingTypes.entrySet()) {
                ExpectedHighlightingSet set = entry.getValue();
                if (!set.enabled || set.severity != info.getSeverity() || set.endOfLine != info.isAfterEndOfLine) continue;
                String severity = entry.getKey();
                if (prev != null && info.endOffset > prev.startOffset) {
                    Assert.assertTrue((String)("Overlapped highlightings: " + info + " and " + prev), (info.endOffset >= prev.endOffset ? 1 : 0) != 0);
                    int offset = prevSeverity.length() * 2 + 14 + (prev.description != null ? prev.description.length() : 4) + (prev.endOffset - prev.startOffset) + (info.endOffset - prev.endOffset);
                    sb.insert(offset, "</" + severity + ">");
                    sb.insert(0, text.substring(info.startOffset, prev.startOffset));
                    sb.insert(0, "<" + severity + " descr=\"" + info.description + "\">");
                } else {
                    sb.insert(0, text.substring(info.endOffset, end));
                    sb.insert(0, "<" + severity + " descr=\"" + info.description + "\">" + text.substring(info.startOffset, info.endOffset) + "</" + severity + ">");
                }
                end = info.startOffset;
                prev = info;
                prevSeverity = severity;
                continue block0;
            }
        }
        sb.insert(0, text.substring(0, end));
        Assert.assertEquals((String)(failMessage + "\n"), (String)this.myText, (String)sb.toString());
        Assert.fail((String)failMessage);
    }

    private static boolean infosContainsExpectedInfo(Collection<HighlightInfo> infos, HighlightInfo expectedInfo) {
        for (HighlightInfo info : infos) {
            if (!ExpectedHighlightingData.infoEquals(expectedInfo, info)) continue;
            return true;
        }
        return false;
    }

    private boolean expectedInfosContainsInfo(HighlightInfo info) {
        if (info.getTextAttributes(null) == TextAttributes.ERASE_MARKER) {
            return true;
        }
        Collection<ExpectedHighlightingSet> expectedHighlights = this.highlightingTypes.values();
        for (ExpectedHighlightingSet highlightingSet : expectedHighlights) {
            if (highlightingSet.severity != info.getSeverity()) continue;
            if (!highlightingSet.enabled) {
                return true;
            }
            Set<HighlightInfo> infos = highlightingSet.infos;
            for (HighlightInfo expectedInfo : infos) {
                if (!ExpectedHighlightingData.infoEquals(expectedInfo, info)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean infoEquals(HighlightInfo expectedInfo, HighlightInfo info) {
        if (expectedInfo == info) {
            return true;
        }
        return !(info.getSeverity() != expectedInfo.getSeverity() || info.startOffset != expectedInfo.startOffset || info.endOffset != expectedInfo.endOffset || info.isAfterEndOfLine != expectedInfo.isAfterEndOfLine || expectedInfo.type != WHATEVER && !expectedInfo.type.equals(info.type) || !Comparing.strEqual((String)ANY_TEXT, (String)expectedInfo.description) && !Comparing.strEqual((String)info.description, (String)expectedInfo.description) || expectedInfo.forcedTextAttributes != null && !expectedInfo.getTextAttributes(null).equals((Object)info.getTextAttributes(null)));
    }

    public static class ExpectedHighlightingSet {
        private final boolean endOfLine;
        final boolean enabled;
        final Set<HighlightInfo> infos;
        final HighlightInfoType defaultErrorType;
        final HighlightSeverity severity;

        public ExpectedHighlightingSet(HighlightInfoType defaultErrorType, HighlightSeverity severity, boolean endOfLine, boolean enabled) {
            this.endOfLine = endOfLine;
            this.enabled = enabled;
            this.infos = new THashSet();
            this.defaultErrorType = defaultErrorType;
            this.severity = severity;
        }
    }
}

